/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.collect.ImmutableList;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.MappingsImpl;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraRecipientRewriteTableDAO {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement insertStatement;
    private final PreparedStatement deleteStatement;
    private final PreparedStatement retrieveMappingStatement;
    private final PreparedStatement retrieveAllMappingsStatement;

    @Inject
    public CassandraRecipientRewriteTableDAO(Session session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.insertStatement = this.prepareInsertStatement(session);
        this.deleteStatement = this.prepareDelete(session);
        this.retrieveMappingStatement = this.prepareRetrieveMappingStatement(session);
        this.retrieveAllMappingsStatement = this.prepareRetrieveAllMappingStatement(session);
    }

    private PreparedStatement prepareRetrieveAllMappingStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"user", "domain", "mapping"}).from("rrt"));
    }

    private PreparedStatement prepareRetrieveMappingStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"mapping"}).from("rrt").where(QueryBuilder.eq((String)"user", (Object)QueryBuilder.bindMarker((String)"user"))).and(QueryBuilder.eq((String)"domain", (Object)QueryBuilder.bindMarker((String)"domain"))));
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("rrt").where(QueryBuilder.eq((String)"user", (Object)QueryBuilder.bindMarker((String)"user"))).and(QueryBuilder.eq((String)"domain", (Object)QueryBuilder.bindMarker((String)"domain"))).and(QueryBuilder.eq((String)"mapping", (Object)QueryBuilder.bindMarker((String)"mapping"))));
    }

    private PreparedStatement prepareInsertStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"rrt").value("user", (Object)QueryBuilder.bindMarker((String)"user")).value("domain", (Object)QueryBuilder.bindMarker((String)"domain")).value("mapping", (Object)QueryBuilder.bindMarker((String)"mapping")));
    }

    public Mono<Void> addMapping(MappingSource source, Mapping mapping) {
        return this.executor.executeVoid((Statement)this.insertStatement.bind().setString("user", source.getFixedUser()).setString("domain", source.getFixedDomain()).setString("mapping", mapping.asString()));
    }

    Mono<Void> removeMapping(MappingSource source, Mapping mapping) {
        return this.executor.executeVoid((Statement)this.deleteStatement.bind().setString("user", source.getFixedUser()).setString("domain", source.getFixedDomain()).setString("mapping", mapping.asString()));
    }

    Mono<MappingsImpl> retrieveMappings(MappingSource source) {
        return this.executor.executeRows((Statement)this.retrieveMappingStatement.bind().setString("user", source.getFixedUser()).setString("domain", source.getFixedDomain())).map(row -> row.getString("mapping")).collect(ImmutableList.toImmutableList()).map(MappingsImpl::fromCollection).filter(Predicate.not(MappingsImpl::isEmpty));
    }

    public Flux<Pair<MappingSource, Mapping>> getAllMappings() {
        return this.executor.executeRows((Statement)this.retrieveAllMappingsStatement.bind()).map(row -> Pair.of((Object)MappingSource.fromUser((String)row.getString("user"), (String)row.getString("domain")), (Object)Mapping.of((String)row.getString("mapping"))));
    }
}

