/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.io.Closeable;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.events.EventBus;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.message.request.ExamineRequest;
import org.apache.james.imap.processor.AbstractSelectionProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;

public class ExamineProcessor
extends AbstractSelectionProcessor<ExamineRequest> {
    public ExamineProcessor(ImapProcessor next, MailboxManager mailboxManager, EventBus eventBus, StatusResponseFactory statusResponseFactory, MetricFactory metricFactory) {
        super(ExamineRequest.class, next, mailboxManager, statusResponseFactory, true, metricFactory, eventBus);
    }

    @Override
    protected Closeable addContextToMDC(ExamineRequest request) {
        return MDCBuilder.create().addToContext("action", "EXAMINE").addToContext("mailbox", request.getMailboxName()).addToContext("condstore", Boolean.toString(request.getCondstore())).addToContextIfPresent("knownModseq", Optional.ofNullable(request.getKnownModSeq()).map(Objects::toString)).addToContext("knownUids", UidRange.toString(request.getKnownUidSet())).addToContext("knownIdRange", IdRange.toString(request.getKnownSequenceSet())).addToContext("lastKnownUidValidity", request.getLastKnownUidValidity().toString()).addToContext("uidSet", UidRange.toString(request.getUidSet())).build();
    }
}

