/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import java.util.EnumSet;
import javax.inject.Inject;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.StatusDataItems;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.message.request.StatusRequest;

public class StatusCommandParser
extends AbstractImapCommandParser {
    @Inject
    public StatusCommandParser(StatusResponseFactory statusResponseFactory) {
        super(ImapConstants.STATUS_COMMAND, statusResponseFactory);
    }

    @Override
    protected ImapMessage decode(ImapRequestLineReader request, Tag tag, ImapSession session) throws DecodingException {
        String mailboxName = request.mailbox();
        StatusDataItems statusDataItems = StatusCommandParser.statusDataItems(request);
        request.eol();
        return new StatusRequest(mailboxName, statusDataItems, tag);
    }

    static StatusDataItems statusDataItems(ImapRequestLineReader request) throws DecodingException {
        return new StatusDataItems(StatusCommandParser.splitWords(request));
    }

    private static EnumSet<StatusDataItems.StatusItem> splitWords(ImapRequestLineReader request) throws DecodingException {
        EnumSet<StatusDataItems.StatusItem> words = EnumSet.noneOf(StatusDataItems.StatusItem.class);
        request.nextWordChar();
        request.consumeChar('(');
        request.nextWordChar();
        while (request.nextChar() != ')') {
            words.add(StatusCommandParser.parseStatus(request));
            request.nextWordChar();
        }
        request.consumeChar(')');
        return words;
    }

    private static StatusDataItems.StatusItem parseStatus(ImapRequestLineReader request) throws DecodingException {
        char c = request.nextWordChar();
        if (c == 'a' || c == 'A') {
            return StatusCommandParser.readAppendLimit(request);
        }
        if (c == 'm' || c == 'M') {
            return StatusCommandParser.readM(request);
        }
        if (c == 'd' || c == 'D') {
            return StatusCommandParser.readDeleted(request);
        }
        if (c == 'r' || c == 'R') {
            return StatusCommandParser.readRecent(request);
        }
        if (c == 'h' || c == 'H') {
            return StatusCommandParser.readHighestModseq(request);
        }
        if (c == 'u' || c == 'U') {
            return StatusCommandParser.readU(request);
        }
        if (c == 's' || c == 'S') {
            return StatusCommandParser.readSize(request);
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown status item: '" + request.consumeWord(ImapRequestLineReader.NoopCharValidator.INSTANCE) + "'");
    }

    private static StatusDataItems.StatusItem readM(ImapRequestLineReader request) throws DecodingException {
        request.consume();
        char c2 = request.nextChar();
        if (c2 == 'e' || c2 == 'E') {
            return StatusCommandParser.readMessages(request);
        }
        return StatusCommandParser.readMailboxId(request);
    }

    private static StatusDataItems.StatusItem readU(ImapRequestLineReader request) throws DecodingException {
        StatusCommandParser.assertChar(request, 'u', 'U');
        char c = request.nextWordChar();
        if (c == 'n' || c == 'N') {
            return StatusCommandParser.readUnseen(request);
        }
        StatusCommandParser.assertChar(request, 'i', 'I');
        StatusCommandParser.assertChar(request, 'd', 'D');
        c = request.nextWordChar();
        if (c == 'n' || c == 'N') {
            return StatusCommandParser.readUidNext(request);
        }
        StatusCommandParser.readValidity(request);
        return StatusDataItems.StatusItem.UID_VALIDITY;
    }

    private static void readValidity(ImapRequestLineReader request) throws DecodingException {
        StatusCommandParser.assertChar(request, 'v', 'V');
        StatusCommandParser.assertChar(request, 'a', 'A');
        StatusCommandParser.assertChar(request, 'l', 'L');
        StatusCommandParser.assertChar(request, 'i', 'I');
        StatusCommandParser.assertChar(request, 'd', 'D');
        StatusCommandParser.assertChar(request, 'i', 'I');
        StatusCommandParser.assertChar(request, 't', 'T');
        StatusCommandParser.assertChar(request, 'y', 'Y');
    }

    private static StatusDataItems.StatusItem readAppendLimit(ImapRequestLineReader request) throws DecodingException {
        StatusCommandParser.assertChar(request, 'a', 'A');
        StatusCommandParser.assertChar(request, 'p', 'P');
        StatusCommandParser.assertChar(request, 'p', 'P');
        StatusCommandParser.assertChar(request, 'e', 'E');
        StatusCommandParser.assertChar(request, 'n', 'N');
        StatusCommandParser.assertChar(request, 'd', 'D');
        StatusCommandParser.assertChar(request, 'l', 'L');
        StatusCommandParser.assertChar(request, 'i', 'I');
        StatusCommandParser.assertChar(request, 'm', 'M');
        StatusCommandParser.assertChar(request, 'i', 'I');
        StatusCommandParser.assertChar(request, 't', 'T');
        return StatusDataItems.StatusItem.APPENDLIMIT;
    }

    private static StatusDataItems.StatusItem readSize(ImapRequestLineReader request) throws DecodingException {
        StatusCommandParser.assertChar(request, 's', 'S');
        StatusCommandParser.assertChar(request, 'i', 'I');
        StatusCommandParser.assertChar(request, 'z', 'Z');
        StatusCommandParser.assertChar(request, 'e', 'E');
        return StatusDataItems.StatusItem.SIZE;
    }

    private static StatusDataItems.StatusItem readUidNext(ImapRequestLineReader request) throws DecodingException {
        StatusCommandParser.assertChar(request, 'n', 'N');
        StatusCommandParser.assertChar(request, 'e', 'E');
        StatusCommandParser.assertChar(request, 'x', 'X');
        StatusCommandParser.assertChar(request, 't', 'T');
        return StatusDataItems.StatusItem.UID_NEXT;
    }

    private static StatusDataItems.StatusItem readUnseen(ImapRequestLineReader request) throws DecodingException {
        StatusCommandParser.assertChar(request, 'n', 'N');
        StatusCommandParser.assertChar(request, 's', 'S');
        StatusCommandParser.assertChar(request, 'e', 'E');
        StatusCommandParser.assertChar(request, 'e', 'E');
        StatusCommandParser.assertChar(request, 'n', 'N');
        return StatusDataItems.StatusItem.UNSEEN;
    }

    private static StatusDataItems.StatusItem readHighestModseq(ImapRequestLineReader request) throws DecodingException {
        StatusCommandParser.assertChar(request, 'h', 'H');
        StatusCommandParser.assertChar(request, 'i', 'I');
        StatusCommandParser.assertChar(request, 'g', 'G');
        StatusCommandParser.assertChar(request, 'h', 'H');
        StatusCommandParser.assertChar(request, 'e', 'E');
        StatusCommandParser.assertChar(request, 's', 'S');
        StatusCommandParser.assertChar(request, 't', 'T');
        StatusCommandParser.assertChar(request, 'm', 'M');
        StatusCommandParser.assertChar(request, 'o', 'O');
        StatusCommandParser.assertChar(request, 'd', 'D');
        StatusCommandParser.assertChar(request, 's', 'S');
        StatusCommandParser.assertChar(request, 'e', 'E');
        StatusCommandParser.assertChar(request, 'q', 'Q');
        return StatusDataItems.StatusItem.HIGHEST_MODSEQ;
    }

    private static StatusDataItems.StatusItem readRecent(ImapRequestLineReader request) throws DecodingException {
        StatusCommandParser.assertChar(request, 'r', 'R');
        StatusCommandParser.assertChar(request, 'e', 'E');
        StatusCommandParser.assertChar(request, 'c', 'C');
        StatusCommandParser.assertChar(request, 'e', 'E');
        StatusCommandParser.assertChar(request, 'n', 'N');
        StatusCommandParser.assertChar(request, 't', 'T');
        return StatusDataItems.StatusItem.RECENT;
    }

    private static StatusDataItems.StatusItem readMessages(ImapRequestLineReader request) throws DecodingException {
        StatusCommandParser.assertChar(request, 'e', 'E');
        StatusCommandParser.assertChar(request, 's', 'S');
        StatusCommandParser.assertChar(request, 's', 'S');
        StatusCommandParser.assertChar(request, 'a', 'A');
        StatusCommandParser.assertChar(request, 'g', 'G');
        StatusCommandParser.assertChar(request, 'e', 'E');
        StatusCommandParser.assertChar(request, 's', 'S');
        return StatusDataItems.StatusItem.MESSAGES;
    }

    private static StatusDataItems.StatusItem readDeleted(ImapRequestLineReader request) throws DecodingException {
        StatusCommandParser.assertChar(request, 'd', 'D');
        StatusCommandParser.assertChar(request, 'e', 'E');
        StatusCommandParser.assertChar(request, 'l', 'L');
        StatusCommandParser.assertChar(request, 'e', 'E');
        StatusCommandParser.assertChar(request, 't', 'T');
        StatusCommandParser.assertChar(request, 'e', 'E');
        StatusCommandParser.assertChar(request, 'd', 'D');
        char c = request.nextWordChar();
        if (c == '-') {
            StatusCommandParser.assertChar(request, '-', '-');
            StatusCommandParser.assertChar(request, 's', 'S');
            StatusCommandParser.assertChar(request, 't', 'T');
            StatusCommandParser.assertChar(request, 'o', 'O');
            StatusCommandParser.assertChar(request, 'r', 'R');
            StatusCommandParser.assertChar(request, 'a', 'A');
            StatusCommandParser.assertChar(request, 'g', 'G');
            StatusCommandParser.assertChar(request, 'e', 'E');
            return StatusDataItems.StatusItem.DELETED_STORAGE;
        }
        return StatusDataItems.StatusItem.DELETED;
    }

    private static StatusDataItems.StatusItem readMailboxId(ImapRequestLineReader request) throws DecodingException {
        StatusCommandParser.assertChar(request, 'a', 'A');
        StatusCommandParser.assertChar(request, 'i', 'I');
        StatusCommandParser.assertChar(request, 'l', 'L');
        StatusCommandParser.assertChar(request, 'b', 'B');
        StatusCommandParser.assertChar(request, 'o', 'O');
        StatusCommandParser.assertChar(request, 'x', 'X');
        StatusCommandParser.assertChar(request, 'i', 'I');
        StatusCommandParser.assertChar(request, 'd', 'D');
        return StatusDataItems.StatusItem.MAILBOXID;
    }

    private static void assertChar(ImapRequestLineReader reader, char low, char up) throws DecodingException {
        char c = reader.consume();
        if (c != low && c != up) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unexpected token in Status item. Expecting " + up + " got " + c);
        }
    }
}

