/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ShardPath
implements PlainJsonSerializable {
    private final String dataPath;
    private final boolean isCustomDataPath;
    private final String statePath;
    public static final JsonpDeserializer<ShardPath> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardPath::setupShardPathDeserializer);

    private ShardPath(Builder builder) {
        this.dataPath = ApiTypeHelper.requireNonNull(builder.dataPath, this, "dataPath");
        this.isCustomDataPath = ApiTypeHelper.requireNonNull(builder.isCustomDataPath, this, "isCustomDataPath");
        this.statePath = ApiTypeHelper.requireNonNull(builder.statePath, this, "statePath");
    }

    public static ShardPath of(Function<Builder, ObjectBuilder<ShardPath>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String dataPath() {
        return this.dataPath;
    }

    public final boolean isCustomDataPath() {
        return this.isCustomDataPath;
    }

    public final String statePath() {
        return this.statePath;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("data_path");
        generator.write(this.dataPath);
        generator.writeKey("is_custom_data_path");
        generator.write(this.isCustomDataPath);
        generator.writeKey("state_path");
        generator.write(this.statePath);
    }

    protected static void setupShardPathDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dataPath, JsonpDeserializer.stringDeserializer(), "data_path");
        op.add(Builder::isCustomDataPath, JsonpDeserializer.booleanDeserializer(), "is_custom_data_path");
        op.add(Builder::statePath, JsonpDeserializer.stringDeserializer(), "state_path");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ShardPath> {
        private String dataPath;
        private Boolean isCustomDataPath;
        private String statePath;

        public final Builder dataPath(String value) {
            this.dataPath = value;
            return this;
        }

        public final Builder isCustomDataPath(boolean value) {
            this.isCustomDataPath = value;
            return this;
        }

        public final Builder statePath(String value) {
            this.statePath = value;
            return this;
        }

        @Override
        public ShardPath build() {
            this._checkSingleUse();
            return new ShardPath(this);
        }
    }
}

