/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres;

import com.google.common.hash.Hashing;
import jakarta.inject.Inject;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.ThreadNotFoundException;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.postgres.PostgresMessageId;
import org.apache.james.mailbox.postgres.mail.dao.PostgresThreadDAO;
import org.apache.james.mailbox.store.mail.ThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.model.MimeMessageId;
import org.apache.james.mailbox.store.mail.model.Subject;
import org.apache.james.mailbox.store.search.SearchUtil;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresThreadIdGuessingAlgorithm
implements ThreadIdGuessingAlgorithm {
    private static final boolean DISABLE_THREADS = Boolean.valueOf(System.getProperty("james.mailbox.threads.disable", "false"));
    private final PostgresThreadDAO.Factory threadDAOFactory;

    @Inject
    public PostgresThreadIdGuessingAlgorithm(PostgresThreadDAO.Factory threadDAOFactory) {
        this.threadDAOFactory = threadDAOFactory;
    }

    public Mono<ThreadId> guessThreadIdReactive(MessageId messageId, Optional<MimeMessageId> mimeMessageId, Optional<MimeMessageId> inReplyTo, Optional<List<MimeMessageId>> references, Optional<Subject> subject, MailboxSession session) {
        PostgresThreadDAO threadDAO = this.threadDAOFactory.create(session.getUser().getDomainPart());
        Set<Integer> hashMimeMessageIds = this.buildMimeMessageIdSet(mimeMessageId, inReplyTo, references).stream().map(mimeMessageId1 -> Hashing.murmur3_32_fixed().hashBytes(mimeMessageId1.getValue().getBytes()).asInt()).collect(Collectors.toSet());
        Optional<Integer> hashBaseSubject = subject.map(value -> new Subject(SearchUtil.getBaseSubject((String)value.getValue()))).map(subject1 -> Hashing.murmur3_32_fixed().hashBytes(subject1.getValue().getBytes()).asInt());
        return threadDAO.findThreads(session.getUser(), hashMimeMessageIds).filter(pair -> ((Optional)pair.getLeft()).equals(hashBaseSubject)).next().map(Pair::getRight).switchIfEmpty(Mono.just((Object)ThreadId.fromBaseMessageId((MessageId)messageId))).flatMap(threadId -> threadDAO.insertSome(session.getUser(), hashMimeMessageIds, (PostgresMessageId)PostgresMessageId.class.cast(messageId), (ThreadId)threadId, hashBaseSubject).then(Mono.just((Object)threadId)));
    }

    public Flux<MessageId> getMessageIdsInThread(ThreadId threadId, MailboxSession session) {
        if (DISABLE_THREADS) {
            return Flux.just((Object)threadId.getBaseMessageId());
        }
        PostgresThreadDAO threadDAO = this.threadDAOFactory.create(session.getUser().getDomainPart());
        return threadDAO.findMessageIds(threadId, session.getUser()).switchIfEmpty((Publisher)Flux.error((Throwable)new ThreadNotFoundException(threadId)));
    }

    private Set<MimeMessageId> buildMimeMessageIdSet(Optional<MimeMessageId> mimeMessageId, Optional<MimeMessageId> inReplyTo, Optional<List<MimeMessageId>> references) {
        HashSet<MimeMessageId> mimeMessageIds = new HashSet<MimeMessageId>();
        mimeMessageId.ifPresent(mimeMessageIds::add);
        inReplyTo.ifPresent(mimeMessageIds::add);
        references.ifPresent(mimeMessageIds::addAll);
        return mimeMessageIds;
    }
}

