/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.web;

import org.apache.jena.atlas.lib.Lib;

public enum HttpMethod {
    METHOD_DELETE("DELETE"),
    METHOD_HEAD("HEAD"),
    METHOD_GET("GET"),
    METHOD_QUERY("QUERY"),
    METHOD_OPTIONS("OPTIONS"),
    METHOD_PATCH("PATCH"),
    METHOD_POST("POST"),
    METHOD_PUT("PUT"),
    METHOD_TRACE("TRACE");

    private final String method;

    private HttpMethod(String name) {
        this.method = name;
    }

    public String method() {
        return this.method;
    }

    public static HttpMethod fromString(String name) {
        try {
            return HttpMethod.valueOf(Lib.uppercase((String)name));
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }
}

