/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import java.util.function.Predicate;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;

public class FilterUniqueCache<T>
implements Predicate<T> {
    private final Cache<T, Object> seen;

    public FilterUniqueCache(int size) {
        this.seen = CacheFactory.createCache(size);
    }

    @Override
    public boolean test(T item) {
        boolean wasSeen = this.seen.containsKey(item);
        this.seen.put(item, Boolean.TRUE);
        return !wasSeen;
    }
}

