/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URL;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanProxyInvocationHandler;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMetaRuntimeException;
import org.apache.juneau.Delegate;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.Setter;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.annotation.Example;
import org.apache.juneau.annotation.NameProperty;
import org.apache.juneau.annotation.Null;
import org.apache.juneau.annotation.ParentProperty;
import org.apache.juneau.annotation.Swap;
import org.apache.juneau.annotation.Swaps;
import org.apache.juneau.annotation.URI;
import org.apache.juneau.collections.AList;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.FieldInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.Mutater;
import org.apache.juneau.reflect.Mutaters;
import org.apache.juneau.reflect.ReflectFlags;
import org.apache.juneau.transform.AnnotationBeanFilterBuilder;
import org.apache.juneau.transform.AutoListSwap;
import org.apache.juneau.transform.AutoMapSwap;
import org.apache.juneau.transform.AutoNumberSwap;
import org.apache.juneau.transform.AutoObjectSwap;
import org.apache.juneau.transform.BeanFilter;
import org.apache.juneau.transform.BuilderSwap;
import org.apache.juneau.transform.DefaultSwaps;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.transform.Surrogate;
import org.apache.juneau.transform.SurrogateSwap;

@Bean(bpi="innerClass,classCategory,elementType,keyType,valueType,notABeanReason,initException,beanMeta")
public final class ClassMeta<T>
implements Type {
    final Class<T> innerClass;
    final ClassInfo info;
    private final Class<? extends T> implClass;
    private final ClassCategory cc;
    private final Method fromStringMethod;
    private final ConstructorInfo noArgConstructor;
    private final ConstructorInfo stringConstructor;
    private final Method exampleMethod;
    private final Field exampleField;
    private final Setter namePropertyMethod;
    private final Setter parentPropertyMethod;
    private final boolean isDelegate;
    private final boolean isAbstract;
    private final boolean isMemberClass;
    private final Object primitiveDefault;
    private final Map<String, Method> publicMethods;
    private final PojoSwap<?, ?>[] childPojoSwaps;
    private final ConcurrentHashMap<Class<?>, PojoSwap<?, ?>> childSwapMap;
    private final ConcurrentHashMap<Class<?>, PojoSwap<?, ?>> childUnswapMap;
    private final PojoSwap<T, ?>[] swaps;
    private final BeanFilter beanFilter;
    private final BuilderSwap<T, ?> builderSwap;
    private final BeanContext beanContext;
    private final ClassMeta<?> elementType;
    private final ClassMeta<?> keyType;
    private final ClassMeta<?> valueType;
    private final BeanMeta<T> beanMeta;
    private final String typePropertyName;
    private final String notABeanReason;
    private final String dictionaryName;
    private final Throwable initException;
    private final InvocationHandler invocationHandler;
    private final BeanRegistry beanRegistry;
    private final ClassMeta<?>[] args;
    private final Object example;
    private final Map<Class<?>, Mutater<?, T>> fromMutaters = new ConcurrentHashMap();
    private final Map<Class<?>, Mutater<T, ?>> toMutaters = new ConcurrentHashMap();
    private final Mutater<String, T> stringMutater;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(false);
    private final Lock rLock = this.lock.readLock();
    private final Lock wLock = this.lock.writeLock();

    ClassMeta(Class<T> innerClass, BeanContext beanContext, Class<? extends T> implClass, BeanFilter beanFilter, PojoSwap<T, ?>[] swaps, PojoSwap<?, ?>[] childPojoSwaps, Object example) {
        this.innerClass = innerClass;
        this.info = ClassInfo.of(innerClass);
        this.beanContext = beanContext;
        String notABeanReason = null;
        this.wLock.lock();
        try {
            if (beanContext != null && beanContext.cmCache != null && ClassMeta.isCacheable(innerClass)) {
                beanContext.cmCache.put(innerClass, this);
            }
            ClassMetaBuilder<? extends T> builder = new ClassMetaBuilder<T>(innerClass, beanContext, implClass, beanFilter, swaps, childPojoSwaps, example);
            this.cc = builder.cc;
            this.isDelegate = builder.isDelegate;
            this.fromStringMethod = builder.fromStringMethod;
            this.parentPropertyMethod = builder.parentPropertyMethod;
            this.namePropertyMethod = builder.namePropertyMethod;
            this.noArgConstructor = builder.noArgConstructor;
            this.stringConstructor = builder.stringConstructor;
            this.primitiveDefault = builder.primitiveDefault;
            this.publicMethods = builder.publicMethods;
            this.beanFilter = beanFilter;
            this.swaps = builder.swaps.isEmpty() ? null : builder.swaps.toArray((PojoSwap[])new PojoSwap[builder.swaps.size()]);
            this.builderSwap = builder.builderSwap;
            this.keyType = builder.keyType;
            this.valueType = builder.valueType;
            this.elementType = builder.elementType;
            notABeanReason = builder.notABeanReason;
            this.beanMeta = builder.beanMeta;
            this.initException = builder.initException;
            this.typePropertyName = builder.typePropertyName;
            this.dictionaryName = builder.dictionaryName;
            this.invocationHandler = builder.invocationHandler;
            this.beanRegistry = builder.beanRegistry;
            this.isMemberClass = builder.isMemberClass;
            this.isAbstract = builder.isAbstract;
            this.implClass = builder.implClass;
            this.childUnswapMap = builder.childUnswapMap;
            this.childSwapMap = builder.childSwapMap;
            this.childPojoSwaps = builder.childPojoSwaps;
            this.exampleMethod = builder.exampleMethod;
            this.exampleField = builder.exampleField;
            this.example = builder.example;
            this.args = null;
            this.stringMutater = builder.stringMutater;
        }
        catch (ClassMetaRuntimeException e) {
            notABeanReason = e.getMessage();
            throw e;
        }
        finally {
            this.notABeanReason = notABeanReason;
            this.wLock.unlock();
        }
    }

    private static boolean isCacheable(Class<?> c) {
        String n = c.getName();
        char x = n.charAt(n.length() - 1);
        return x < '0' || x > '9' || n.indexOf("$$") == -1 && !n.startsWith("sun") && !n.startsWith("com.sun") && n.indexOf("$Proxy") == -1;
    }

    final void waitForInit() {
        this.rLock.lock();
        this.rLock.unlock();
    }

    ClassMeta(ClassMeta<T> mainType, ClassMeta<?> keyType, ClassMeta<?> valueType, ClassMeta<?> elementType) {
        this.innerClass = mainType.innerClass;
        this.info = mainType.info;
        this.implClass = mainType.implClass;
        this.childPojoSwaps = mainType.childPojoSwaps;
        this.childSwapMap = mainType.childSwapMap;
        this.childUnswapMap = mainType.childUnswapMap;
        this.cc = mainType.cc;
        this.fromStringMethod = mainType.fromStringMethod;
        this.noArgConstructor = mainType.noArgConstructor;
        this.stringConstructor = mainType.stringConstructor;
        this.namePropertyMethod = mainType.namePropertyMethod;
        this.parentPropertyMethod = mainType.parentPropertyMethod;
        this.isDelegate = mainType.isDelegate;
        this.isAbstract = mainType.isAbstract;
        this.isMemberClass = mainType.isMemberClass;
        this.primitiveDefault = mainType.primitiveDefault;
        this.publicMethods = mainType.publicMethods;
        this.beanContext = mainType.beanContext;
        this.elementType = elementType;
        this.keyType = keyType;
        this.valueType = valueType;
        this.invocationHandler = mainType.invocationHandler;
        this.beanMeta = mainType.beanMeta;
        this.typePropertyName = mainType.typePropertyName;
        this.dictionaryName = mainType.dictionaryName;
        this.notABeanReason = mainType.notABeanReason;
        this.swaps = mainType.swaps;
        this.builderSwap = mainType.builderSwap;
        this.beanFilter = mainType.beanFilter;
        this.initException = mainType.initException;
        this.beanRegistry = mainType.beanRegistry;
        this.exampleMethod = mainType.exampleMethod;
        this.exampleField = mainType.exampleField;
        this.example = mainType.example;
        this.args = null;
        this.stringMutater = mainType.stringMutater;
    }

    ClassMeta(ClassMeta<?>[] args) {
        this.innerClass = Object[].class;
        this.info = ClassInfo.of(this.innerClass);
        this.args = args;
        this.implClass = null;
        this.childPojoSwaps = null;
        this.childSwapMap = null;
        this.childUnswapMap = null;
        this.cc = ClassCategory.ARGS;
        this.fromStringMethod = null;
        this.noArgConstructor = null;
        this.stringConstructor = null;
        this.namePropertyMethod = null;
        this.parentPropertyMethod = null;
        this.isDelegate = false;
        this.isAbstract = false;
        this.isMemberClass = false;
        this.primitiveDefault = null;
        this.publicMethods = null;
        this.beanContext = null;
        this.elementType = null;
        this.keyType = null;
        this.valueType = null;
        this.invocationHandler = null;
        this.beanMeta = null;
        this.typePropertyName = null;
        this.dictionaryName = null;
        this.notABeanReason = null;
        this.swaps = null;
        this.builderSwap = null;
        this.beanFilter = null;
        this.initException = null;
        this.beanRegistry = null;
        this.exampleMethod = null;
        this.exampleField = null;
        this.example = null;
        this.stringMutater = null;
    }

    public ClassInfo getInfo() {
        return this.info;
    }

    public String getBeanTypePropertyName() {
        return this.typePropertyName;
    }

    public String getDictionaryName() {
        return this.dictionaryName;
    }

    public BeanRegistry getBeanRegistry() {
        return this.beanRegistry;
    }

    public ClassCategory getClassCategory() {
        return this.cc;
    }

    public boolean isAssignableFrom(Class<?> c) {
        return this.info.isChildOf(c);
    }

    public boolean isInstanceOf(Class<?> c) {
        return this.info.isParentOf(c);
    }

    protected boolean hasChildPojoSwaps() {
        return this.childPojoSwaps != null;
    }

    protected PojoSwap<?, ?> getChildPojoSwapForSwap(Class<?> normalClass) {
        if (this.childSwapMap != null) {
            PojoSwap s = this.childSwapMap.get(normalClass);
            if (s == null) {
                PojoSwap s2;
                for (PojoSwap pojoSwap : this.childPojoSwaps) {
                    if (s != null || !pojoSwap.getNormalClass().isParentOf(normalClass)) continue;
                    s = pojoSwap;
                }
                if (s == null) {
                    s = PojoSwap.NULL;
                }
                if ((s2 = this.childSwapMap.putIfAbsent(normalClass, s)) != null) {
                    s = s2;
                }
            }
            if (s == PojoSwap.NULL) {
                return null;
            }
            return s;
        }
        return null;
    }

    protected PojoSwap<?, ?> getChildPojoSwapForUnswap(Class<?> swapClass) {
        if (this.childUnswapMap != null) {
            PojoSwap s = this.childUnswapMap.get(swapClass);
            if (s == null) {
                PojoSwap s2;
                for (PojoSwap pojoSwap : this.childPojoSwaps) {
                    if (s != null || !pojoSwap.getSwapClass().isParentOf(swapClass)) continue;
                    s = pojoSwap;
                }
                if (s == null) {
                    s = PojoSwap.NULL;
                }
                if ((s2 = this.childUnswapMap.putIfAbsent(swapClass, s)) != null) {
                    s = s2;
                }
            }
            if (s == PojoSwap.NULL) {
                return null;
            }
            return s;
        }
        return null;
    }

    protected static <T> Constructor<? extends T> findNoArgConstructor(Class<?> c, Visibility v) {
        ClassInfo ci = ClassInfo.of(c);
        if (ci.isAbstract()) {
            return null;
        }
        boolean isMemberClass = ci.isMemberClass() && ci.isNotStatic();
        for (ConstructorInfo cc : ci.getPublicConstructors()) {
            if (!cc.hasNumParams(isMemberClass ? 1 : 0) || !cc.isVisible(v) || !cc.isNotDeprecated()) continue;
            return v.transform(cc.inner());
        }
        return null;
    }

    public Class<T> getInnerClass() {
        return this.innerClass;
    }

    @BeanIgnore
    public ClassMeta<?> getSerializedClassMeta(BeanSession session) {
        PojoSwap<T, ?> ps = this.getSwap(session);
        return ps == null ? this : ps.getSwapClassMeta(session);
    }

    @BeanIgnore
    public T getExample(BeanSession session) {
        try {
            Object etExample;
            if (this.example != null) {
                if (this.isInstance(this.example)) {
                    return (T)this.example;
                }
                if (this.example instanceof String) {
                    if (this.isCharSequence()) {
                        return (T)this.example;
                    }
                    String s = this.example.toString();
                    if (this.isMapOrBean() && StringUtils.isJsonObject(s, false)) {
                        return JsonParser.DEFAULT.parse(s, this);
                    }
                    if (this.isCollectionOrArray() && StringUtils.isJsonArray(s, false)) {
                        return JsonParser.DEFAULT.parse(s, this);
                    }
                }
                if (this.example instanceof Map && this.isMapOrBean()) {
                    return JsonParser.DEFAULT.parse(SimpleJsonSerializer.DEFAULT_READABLE.toString(this.example), this);
                }
                if (this.example instanceof Collection && this.isCollectionOrArray()) {
                    return JsonParser.DEFAULT.parse(SimpleJsonSerializer.DEFAULT_READABLE.serialize(this.example), this);
                }
            }
            if (this.exampleMethod != null) {
                return (T)MethodInfo.of(this.exampleMethod).invokeFuzzy(null, session);
            }
            if (this.exampleField != null) {
                return (T)this.exampleField.get(null);
            }
            if (this.isCollection()) {
                etExample = this.getElementType().getExample(session);
                if (etExample != null) {
                    if (this.canCreateNewInstance()) {
                        Collection c = (Collection)this.newInstance();
                        c.add(etExample);
                        return (T)c;
                    }
                    return (T)Collections.singleton(etExample);
                }
            } else if (this.isArray()) {
                etExample = this.getElementType().getExample(session);
                if (etExample != null) {
                    Object o = Array.newInstance(this.getElementType().innerClass, 1);
                    Array.set(o, 0, etExample);
                    return (T)o;
                }
            } else if (this.isMap()) {
                Object vtExample = this.getValueType().getExample(session);
                Object ktExample = this.getKeyType().getExample(session);
                if (ktExample != null && vtExample != null) {
                    if (this.canCreateNewInstance()) {
                        Map m = (Map)this.newInstance();
                        m.put(ktExample, vtExample);
                        return (T)m;
                    }
                    return (T)Collections.singletonMap(ktExample, vtExample);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new ClassMetaRuntimeException(e);
        }
    }

    public ClassMeta<?> getElementType() {
        return this.elementType;
    }

    public ClassMeta<?> getKeyType() {
        return this.keyType;
    }

    public ClassMeta<?> getValueType() {
        return this.valueType;
    }

    public boolean isDelegate() {
        return this.isDelegate;
    }

    public boolean isMap() {
        return this.cc == ClassCategory.MAP || this.cc == ClassCategory.BEANMAP;
    }

    public boolean isMapOrBean() {
        return this.cc == ClassCategory.MAP || this.cc == ClassCategory.BEANMAP || this.beanMeta != null;
    }

    public boolean isBeanMap() {
        return this.cc == ClassCategory.BEANMAP;
    }

    public boolean isCollection() {
        return this.cc == ClassCategory.COLLECTION;
    }

    public boolean isOptional() {
        return this.cc == ClassCategory.OPTIONAL;
    }

    public boolean isCollectionOrArray() {
        return this.cc == ClassCategory.COLLECTION || this.cc == ClassCategory.ARRAY;
    }

    public boolean isCollectionOrArrayOrOptional() {
        return this.cc == ClassCategory.COLLECTION || this.cc == ClassCategory.ARRAY || this.cc == ClassCategory.OPTIONAL;
    }

    public boolean isSet() {
        return this.cc == ClassCategory.COLLECTION && this.info.isChildOf(Set.class);
    }

    public boolean isList() {
        return this.cc == ClassCategory.COLLECTION && this.info.isChildOf(List.class);
    }

    public boolean isByteArray() {
        return this.cc == ClassCategory.ARRAY && this.innerClass == byte[].class;
    }

    public boolean isClass() {
        return this.cc == ClassCategory.CLASS;
    }

    public boolean isMethod() {
        return this.cc == ClassCategory.METHOD;
    }

    public boolean isEnum() {
        return this.cc == ClassCategory.ENUM;
    }

    public boolean isArray() {
        return this.cc == ClassCategory.ARRAY;
    }

    public boolean isBean() {
        return this.beanMeta != null;
    }

    public boolean isObject() {
        return this.cc == ClassCategory.OBJ;
    }

    public boolean isNotObject() {
        return this.cc != ClassCategory.OBJ;
    }

    public boolean isNumber() {
        return this.cc == ClassCategory.NUMBER || this.cc == ClassCategory.DECIMAL;
    }

    public boolean isDecimal() {
        return this.cc == ClassCategory.DECIMAL;
    }

    public boolean isFloat() {
        return this.innerClass == Float.class || this.innerClass == Float.TYPE;
    }

    public boolean isDouble() {
        return this.innerClass == Double.class || this.innerClass == Double.TYPE;
    }

    public boolean isShort() {
        return this.innerClass == Short.class || this.innerClass == Short.TYPE;
    }

    public boolean isInteger() {
        return this.innerClass == Integer.class || this.innerClass == Integer.TYPE;
    }

    public boolean isLong() {
        return this.innerClass == Long.class || this.innerClass == Long.TYPE;
    }

    public boolean isType(Class<?> c) {
        return this.info.isChildOf(c);
    }

    public boolean isBoolean() {
        return this.cc == ClassCategory.BOOLEAN;
    }

    public boolean isCharSequence() {
        return this.cc == ClassCategory.STR || this.cc == ClassCategory.CHARSEQ;
    }

    public boolean isString() {
        return this.cc == ClassCategory.STR;
    }

    public boolean isChar() {
        return this.cc == ClassCategory.CHAR;
    }

    public boolean isPrimitive() {
        return this.innerClass.isPrimitive();
    }

    public boolean isDateOrCalendar() {
        return this.cc == ClassCategory.DATE;
    }

    public boolean isDateOrCalendarOrTemporal() {
        return this.cc == ClassCategory.DATE || this.info.isChildOf(Temporal.class);
    }

    public boolean isDate() {
        return this.cc == ClassCategory.DATE && this.info.isChildOf(Date.class);
    }

    public boolean isTemporal() {
        return this.info.isChildOf(Temporal.class);
    }

    public boolean isCalendar() {
        return this.cc == ClassCategory.DATE && this.info.isChildOf(Calendar.class);
    }

    public boolean isUri() {
        return this.cc == ClassCategory.URI;
    }

    public boolean isReader() {
        return this.cc == ClassCategory.READER;
    }

    public boolean isInputStream() {
        return this.cc == ClassCategory.INPUTSTREAM;
    }

    public boolean isVoid() {
        return this.cc == ClassCategory.VOID;
    }

    public boolean isArgs() {
        return this.cc == ClassCategory.ARGS;
    }

    public ClassMeta<?>[] getArgs() {
        return this.args;
    }

    public ClassMeta<?> getArg(int index) {
        if (this.args != null && index >= 0 && index < this.args.length) {
            return this.args[index];
        }
        throw new BeanRuntimeException("Invalid argument index specified:  {0}.  Only {1} arguments are defined.", index, this.args == null ? 0 : this.args.length);
    }

    public boolean isNullable() {
        if (this.innerClass.isPrimitive()) {
            return this.cc == ClassCategory.CHAR;
        }
        return true;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isMemberClass() {
        return this.isMemberClass;
    }

    public Map<String, Method> getPublicMethods() {
        return this.publicMethods;
    }

    public PojoSwap<T, ?> getSwap(BeanSession session) {
        if (this.swaps != null) {
            int matchQuant = 0;
            int matchIndex = -1;
            for (int i = 0; i < this.swaps.length; ++i) {
                int q = this.swaps[i].match(session);
                if (q <= matchQuant) continue;
                matchQuant = q;
                matchIndex = i;
            }
            if (matchIndex > -1) {
                return this.swaps[matchIndex];
            }
        }
        return null;
    }

    public BuilderSwap<T, ?> getBuilderSwap(BeanSession session) {
        return this.builderSwap;
    }

    public BeanMeta<T> getBeanMeta() {
        return this.beanMeta;
    }

    public ConstructorInfo getConstructor() {
        return this.noArgConstructor;
    }

    public InvocationHandler getProxyInvocationHandler() {
        return this.invocationHandler;
    }

    public boolean canCreateNewInstance() {
        if (this.isMemberClass) {
            return false;
        }
        if (this.noArgConstructor != null) {
            return true;
        }
        if (this.getProxyInvocationHandler() != null) {
            return true;
        }
        return this.isArray() && this.elementType.canCreateNewInstance();
    }

    public boolean canCreateNewInstance(Object outer) {
        if (this.isMemberClass) {
            return outer != null && this.noArgConstructor != null && this.noArgConstructor.hasParamTypes(outer.getClass());
        }
        return this.canCreateNewInstance();
    }

    public boolean canCreateNewBean(Object outer) {
        if (this.beanMeta == null) {
            return false;
        }
        if (this.beanMeta.constructor == null) {
            return false;
        }
        if (this.isMemberClass) {
            return outer != null && this.beanMeta.constructor.hasParamTypes(outer.getClass());
        }
        return true;
    }

    public boolean canCreateNewInstanceFromString(Object outer) {
        if (this.fromStringMethod != null) {
            return true;
        }
        if (this.stringConstructor != null) {
            if (this.isMemberClass) {
                return outer != null && this.stringConstructor.hasParamTypes(outer.getClass(), String.class);
            }
            return true;
        }
        return false;
    }

    public Setter getNameProperty() {
        return this.namePropertyMethod;
    }

    public Setter getParentProperty() {
        return this.parentPropertyMethod;
    }

    public synchronized String getNotABeanReason() {
        return this.notABeanReason;
    }

    public Throwable getInitException() {
        return this.initException;
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public T getPrimitiveDefault() {
        return (T)this.primitiveDefault;
    }

    public Optional<?> getOptionalDefault() {
        if (this.isOptional()) {
            return Optional.ofNullable(this.getElementType().getOptionalDefault());
        }
        return null;
    }

    public String toString(Object t) {
        if (t == null) {
            return null;
        }
        if (this.isEnum() && this.beanContext.isUseEnumNames()) {
            return ((Enum)t).name();
        }
        return t.toString();
    }

    public T newInstanceFromString(Object outer, String arg) throws ExecutableException {
        if (this.isEnum() && this.beanContext.isUseEnumNames() && this.fromStringMethod != null) {
            return Enum.valueOf(this.innerClass, arg);
        }
        Method m = this.fromStringMethod;
        if (m != null) {
            try {
                return (T)m.invoke(null, arg);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new ExecutableException(e);
            }
        }
        ConstructorInfo c = this.stringConstructor;
        if (c != null) {
            if (this.isMemberClass) {
                return c.invoke(outer, arg);
            }
            return c.invoke(arg);
        }
        throw new InstantiationError("No string constructor or valueOf(String) method found for class '" + this.getInnerClass().getName() + "'");
    }

    public T newInstance() throws ExecutableException {
        if (this.isArray()) {
            return (T)Array.newInstance(this.getInnerClass().getComponentType(), 0);
        }
        ConstructorInfo c = this.getConstructor();
        if (c != null) {
            return c.invoke(null);
        }
        InvocationHandler h = this.getProxyInvocationHandler();
        if (h != null) {
            return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.getInnerClass(), Serializable.class}, h);
        }
        if (this.isArray()) {
            return (T)Array.newInstance(this.elementType.innerClass, 0);
        }
        return null;
    }

    public T newInstance(Object outer) throws ExecutableException {
        if (this.isMemberClass) {
            return this.noArgConstructor.invoke(outer);
        }
        return this.newInstance();
    }

    public boolean same(ClassMeta<?> cm) {
        if (this.equals(cm)) {
            return true;
        }
        return this.isPrimitive() && this.cc == cm.cc;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean simple) {
        return this.toString(new StringBuilder(), simple).toString();
    }

    protected StringBuilder toString(StringBuilder sb, boolean simple) {
        String n = this.innerClass.getName();
        if (simple) {
            int i = n.lastIndexOf(46);
            n = n.substring(i == -1 ? 0 : i + 1).replace('$', '.');
        }
        if (this.cc == ClassCategory.ARRAY) {
            return this.elementType.toString(sb, simple).append('[').append(']');
        }
        if (this.cc == ClassCategory.MAP) {
            return sb.append(n).append(this.keyType.isObject() && this.valueType.isObject() ? "" : "<" + this.keyType.toString(simple) + "," + this.valueType.toString(simple) + ">");
        }
        if (this.cc == ClassCategory.BEANMAP) {
            return sb.append(BeanMap.class.getName()).append('<').append(n).append('>');
        }
        if (this.cc == ClassCategory.COLLECTION || this.cc == ClassCategory.OPTIONAL) {
            return sb.append(n).append(this.elementType.isObject() ? "" : "<" + this.elementType.toString(simple) + ">");
        }
        return sb.append(n);
    }

    public boolean isInstance(Object o) {
        if (o != null) {
            return this.info.isParentOf(o.getClass()) || this.isPrimitive() && this.info.getPrimitiveWrapper() == o.getClass();
        }
        return false;
    }

    public String getFullName() {
        return this.info.getFullName();
    }

    public String getName() {
        return this.innerClass.getName();
    }

    public String getSimpleName() {
        return this.innerClass.getSimpleName();
    }

    public boolean hasReaderMutater() {
        return this.hasMutaterFrom(Reader.class);
    }

    public Mutater<Reader, T> getReaderMutater() {
        return this.getFromMutater(Reader.class);
    }

    public boolean hasInputStreamMutater() {
        return this.hasMutaterFrom(InputStream.class);
    }

    public Mutater<InputStream, T> getInputStreamMutater() {
        return this.getFromMutater(InputStream.class);
    }

    public boolean hasStringMutater() {
        return this.stringMutater != null;
    }

    public Mutater<String, T> getStringMutater() {
        return this.stringMutater;
    }

    public boolean hasMutaterFrom(Class<?> c) {
        return this.getFromMutater(c) != null;
    }

    public boolean hasMutaterFrom(ClassMeta<?> c) {
        return this.getFromMutater(c.getInnerClass()) != null;
    }

    public boolean hasMutaterTo(Class<?> c) {
        return this.getToMutater(c) != null;
    }

    public boolean hasMutaterTo(ClassMeta<?> c) {
        return this.getToMutater(c.getInnerClass()) != null;
    }

    public T mutateFrom(Object o) {
        Mutater<?, T> t = this.getFromMutater(o.getClass());
        return t == null ? null : (T)t.mutate(o);
    }

    public <O> O mutateTo(Object o, Class<O> c) {
        Mutater<T, O> t = this.getToMutater(c);
        return t == null ? null : (O)t.mutate(o);
    }

    public <O> O mutateTo(Object o, ClassMeta<O> c) {
        return this.mutateTo(o, c.getInnerClass());
    }

    public <I> Mutater<I, T> getFromMutater(Class<I> c) {
        Mutater<Object, Object> t = this.fromMutaters.get(c);
        if (t == Mutaters.NULL) {
            return null;
        }
        if (t == null) {
            t = Mutaters.get(c, this.innerClass);
            if (t == null) {
                t = Mutaters.NULL;
            }
            this.fromMutaters.put(c, t);
        }
        return t == Mutaters.NULL ? null : t;
    }

    public <O> Mutater<T, O> getToMutater(Class<O> c) {
        Mutater<Object, Object> t = this.toMutaters.get(c);
        if (t == Mutaters.NULL) {
            return null;
        }
        if (t == null) {
            t = Mutaters.get(this.innerClass, c);
            if (t == null) {
                t = Mutaters.NULL;
            }
            this.toMutaters.put(c, t);
        }
        return t == Mutaters.NULL ? null : t;
    }

    public boolean hasAnnotation(Class<? extends Annotation> a) {
        return this.getLastAnnotation(a) != null;
    }

    public <A extends Annotation> A getLastAnnotation(Class<A> a) {
        return this.info.getLastAnnotation(a, this.beanContext == null ? BeanContext.DEFAULT : this.beanContext);
    }

    public <A extends Annotation> List<A> getAnnotations(Class<A> a) {
        return this.info.getAnnotations(a, this.beanContext == null ? BeanContext.DEFAULT : this.beanContext);
    }

    public int hashCode() {
        return this.innerClass.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof ClassMeta && ObjectUtils.eq(this, (ClassMeta)o, (x, y) -> ObjectUtils.eq(x.innerClass, y.innerClass));
    }

    private final class ClassMetaBuilder<T> {
        Class<T> innerClass;
        ClassInfo ci;
        Class<? extends T> implClass;
        BeanContext beanContext;
        ClassCategory cc;
        boolean isDelegate;
        boolean isMemberClass;
        boolean isAbstract;
        Method fromStringMethod;
        Setter parentPropertyMethod;
        Setter namePropertyMethod;
        ConstructorInfo noArgConstructor;
        ConstructorInfo stringConstructor;
        Object primitiveDefault;
        Map<String, Method> publicMethods;
        ClassMeta<?> keyType;
        ClassMeta<?> valueType;
        ClassMeta<?> elementType;
        String typePropertyName;
        String notABeanReason;
        String dictionaryName;
        Throwable initException;
        BeanMeta beanMeta;
        AList<PojoSwap> swaps;
        BuilderSwap builderSwap;
        InvocationHandler invocationHandler;
        BeanRegistry beanRegistry;
        PojoSwap<?, ?>[] childPojoSwaps;
        ConcurrentHashMap<Class<?>, PojoSwap<?, ?>> childSwapMap;
        ConcurrentHashMap<Class<?>, PojoSwap<?, ?>> childUnswapMap;
        Method exampleMethod;
        Field exampleField;
        Object example;
        Mutater<String, T> stringMutater;

        ClassMetaBuilder(Class<T> innerClass, BeanContext beanContext, Class<? extends T> implClass, BeanFilter beanFilter, PojoSwap<T, ?>[] swaps, PojoSwap<?, ?>[] childPojoSwaps, Object example) {
            Class<T> c;
            BeanContext bc;
            block97: {
                this.cc = ClassCategory.OTHER;
                this.isDelegate = false;
                this.isMemberClass = false;
                this.isAbstract = false;
                this.fromStringMethod = null;
                this.parentPropertyMethod = null;
                this.namePropertyMethod = null;
                this.noArgConstructor = null;
                this.stringConstructor = null;
                this.primitiveDefault = null;
                this.publicMethods = new LinkedHashMap<String, Method>();
                this.keyType = null;
                this.valueType = null;
                this.elementType = null;
                this.typePropertyName = null;
                this.notABeanReason = null;
                this.dictionaryName = null;
                this.initException = null;
                this.beanMeta = null;
                this.swaps = AList.of();
                this.invocationHandler = null;
                this.beanRegistry = null;
                this.innerClass = innerClass;
                this.beanContext = beanContext;
                bc = beanContext;
                this.implClass = implClass;
                ClassInfo ici = ClassInfo.of(implClass);
                this.childPojoSwaps = childPojoSwaps;
                if (childPojoSwaps == null) {
                    this.childSwapMap = null;
                    this.childUnswapMap = null;
                } else {
                    this.childSwapMap = new ConcurrentHashMap();
                    this.childUnswapMap = new ConcurrentHashMap();
                }
                c = innerClass;
                this.ci = ClassInfo.of(c);
                if (this.ci.isProxy()) {
                    this.ci = this.ci.getProxyFor();
                    this.innerClass = this.ci.inner();
                    innerClass = this.innerClass;
                }
                if (c.isPrimitive()) {
                    if (c == Boolean.TYPE) {
                        this.cc = ClassCategory.BOOLEAN;
                    } else if (c == Byte.TYPE || c == Short.TYPE || c == Integer.TYPE || c == Long.TYPE || c == Float.TYPE || c == Double.TYPE) {
                        this.cc = c == Float.TYPE || c == Double.TYPE ? ClassCategory.DECIMAL : ClassCategory.NUMBER;
                    } else if (c == Character.TYPE) {
                        this.cc = ClassCategory.CHAR;
                    } else if (c == Void.TYPE || c == Void.class) {
                        this.cc = ClassCategory.VOID;
                    }
                } else {
                    if (this.ci.isChildOf(Delegate.class)) {
                        this.isDelegate = true;
                    }
                    if (c == Object.class) {
                        this.cc = ClassCategory.OBJ;
                    } else if (c.isEnum()) {
                        this.cc = ClassCategory.ENUM;
                    } else if (c.equals(Class.class)) {
                        this.cc = ClassCategory.CLASS;
                    } else if (this.ci.isChildOf(Method.class)) {
                        this.cc = ClassCategory.METHOD;
                    } else if (this.ci.isChildOf(CharSequence.class)) {
                        this.cc = c.equals(String.class) ? ClassCategory.STR : ClassCategory.CHARSEQ;
                    } else if (this.ci.isChildOf(Number.class)) {
                        this.cc = this.ci.isChildOfAny(Float.class, Double.class) ? ClassCategory.DECIMAL : ClassCategory.NUMBER;
                    } else if (this.ci.isChildOf(Collection.class)) {
                        this.cc = ClassCategory.COLLECTION;
                    } else if (this.ci.isChildOf(Map.class)) {
                        this.cc = this.ci.isChildOf(BeanMap.class) ? ClassCategory.BEANMAP : ClassCategory.MAP;
                    } else if (c == Character.class) {
                        this.cc = ClassCategory.CHAR;
                    } else if (c == Boolean.class) {
                        this.cc = ClassCategory.BOOLEAN;
                    } else if (this.ci.isChildOfAny(Date.class, Calendar.class)) {
                        this.cc = ClassCategory.DATE;
                    } else if (c.isArray()) {
                        this.cc = ClassCategory.ARRAY;
                    } else if (this.ci.isChildOfAny(URL.class, java.net.URI.class) || bc.hasAnnotation(URI.class, c)) {
                        this.cc = ClassCategory.URI;
                    } else if (this.ci.isChildOf(Reader.class)) {
                        this.cc = ClassCategory.READER;
                    } else if (this.ci.isChildOf(InputStream.class)) {
                        this.cc = ClassCategory.INPUTSTREAM;
                    } else if (this.ci.is(Optional.class)) {
                        this.cc = ClassCategory.OPTIONAL;
                    }
                }
                this.isMemberClass = this.ci.isMemberClass() && this.ci.isNotStatic();
                block13: for (String methodName : new String[]{"fromString", "fromValue", "valueOf", "parse", "parseString", "forName", "forString"}) {
                    if (this.fromStringMethod != null) continue;
                    for (MethodInfo m : this.ci.getPublicMethods()) {
                        if (!m.isAll(ReflectFlags.STATIC, ReflectFlags.PUBLIC, ReflectFlags.NOT_DEPRECATED) || !m.hasName(methodName) || !m.hasReturnType(c) || !m.hasParamTypes(String.class)) continue;
                        this.fromStringMethod = m.inner();
                        continue block13;
                    }
                }
                for (MethodInfo m : this.ci.getPublicMethods()) {
                    if (!m.isAll(ReflectFlags.PUBLIC, ReflectFlags.NOT_DEPRECATED, ReflectFlags.STATIC) || !m.hasName("example") || !m.hasFuzzyParamTypes(BeanSession.class)) continue;
                    this.exampleMethod = m.inner();
                    break;
                }
                for (FieldInfo f : this.ci.getAllFieldsParentFirst()) {
                    if (bc.hasAnnotation(ParentProperty.class, f)) {
                        if (f.isStatic()) {
                            throw new ClassMetaRuntimeException(c, "@ParentProperty used on invalid field ''{0}''.  Must be static.", f);
                        }
                        f.setAccessible();
                        this.parentPropertyMethod = new Setter.FieldSetter(f.inner());
                    }
                    if (!bc.hasAnnotation(NameProperty.class, f)) continue;
                    if (f.isStatic()) {
                        throw new ClassMetaRuntimeException(c, "@NameProperty used on invalid field ''{0}''.  Must be static.", f);
                    }
                    f.setAccessible();
                    this.namePropertyMethod = new Setter.FieldSetter(f.inner());
                }
                for (FieldInfo f : this.ci.getDeclaredFields()) {
                    if (!bc.hasAnnotation(Example.class, f)) continue;
                    if (!f.isStatic() || !this.ci.isParentOf(f.getType().inner())) {
                        throw new ClassMetaRuntimeException(c, "@Example used on invalid field ''{0}''.  Must be static and an instance of the type.", f);
                    }
                    f.setAccessible();
                    this.exampleField = f.inner();
                }
                for (MethodInfo m : this.ci.getAllMethodsParentFirst()) {
                    if (bc.hasAnnotation(ParentProperty.class, m)) {
                        if (m.isStatic() || !m.hasNumParams(1)) {
                            throw new ClassMetaRuntimeException(c, "@ParentProperty used on invalid method ''{0}''.  Must not be static and have one argument.", m);
                        }
                        m.setAccessible();
                        this.parentPropertyMethod = new Setter.MethodSetter(m.inner());
                    }
                    if (!bc.hasAnnotation(NameProperty.class, m)) continue;
                    if (m.isStatic() || !m.hasNumParams(1)) {
                        throw new ClassMetaRuntimeException(c, "@NameProperty used on invalid method ''{0}''.  Must not be static and have one argument.", m);
                    }
                    m.setAccessible();
                    this.namePropertyMethod = new Setter.MethodSetter(m.inner());
                }
                for (MethodInfo m : this.ci.getDeclaredMethods()) {
                    if (!bc.hasAnnotation(Example.class, m)) continue;
                    if (!(m.isStatic() && m.hasFuzzyParamTypes(BeanSession.class) && this.ci.isParentOf(m.getReturnType().inner()))) {
                        throw new ClassMetaRuntimeException(c, "@Example used on invalid method ''{0}''.  Must be static and return an instance of the declaring class.", m);
                    }
                    m.setAccessible();
                    this.exampleMethod = m.inner();
                }
                this.isAbstract = this.ci.isAbstract() && this.ci.isNotPrimitive();
                for (ConstructorInfo cs : this.ci.getPublicConstructors()) {
                    ClassInfo arg;
                    if (!cs.isPublic() || !cs.isNotDeprecated()) continue;
                    List<ClassInfo> pt = cs.getParamTypes();
                    if (pt.size() == (this.isMemberClass ? 1 : 0) && c != Object.class && !this.isAbstract) {
                        this.noArgConstructor = cs;
                        continue;
                    }
                    if (pt.size() != (this.isMemberClass ? 2 : 1) || !(arg = pt.get(this.isMemberClass ? 1 : 0)).is(String.class)) continue;
                    this.stringConstructor = cs;
                }
                this.primitiveDefault = this.ci.getPrimitiveDefault();
                for (MethodInfo m : this.ci.getPublicMethods()) {
                    if (!m.isAll(ReflectFlags.PUBLIC, ReflectFlags.NOT_DEPRECATED)) continue;
                    this.publicMethods.put(m.getSignature(), m.inner());
                }
                if (innerClass != Object.class) {
                    ClassInfo x = implClass == null ? this.ci : ici;
                    this.noArgConstructor = x.getPublicConstructor(new Class[0]);
                }
                if (beanFilter == null) {
                    beanFilter = this.findBeanFilter(bc);
                }
                if (swaps != null) {
                    this.swaps.a(swaps);
                }
                if (bc != null) {
                    this.builderSwap = BuilderSwap.findSwapFromPojoClass(bc, c, bc.getBeanConstructorVisibility(), bc.getBeanMethodVisibility());
                }
                this.findSwaps(this.swaps, bc);
                try {
                    ClassMeta<?>[] parameters;
                    if (this.cc == ClassCategory.ARRAY) {
                        this.elementType = this.findClassMeta(innerClass.getComponentType());
                        break block97;
                    }
                    if (this.cc == ClassCategory.MAP) {
                        parameters = this.findParameters();
                        if (parameters != null && parameters.length == 2) {
                            this.keyType = parameters[0];
                            this.valueType = parameters[1];
                        } else {
                            this.keyType = this.findClassMeta(Object.class);
                            this.valueType = this.findClassMeta(Object.class);
                        }
                        break block97;
                    }
                    if (this.cc == ClassCategory.COLLECTION || this.cc == ClassCategory.OPTIONAL) {
                        parameters = this.findParameters();
                        this.elementType = parameters != null && parameters.length == 1 ? parameters[0] : this.findClassMeta(Object.class);
                        break block97;
                    }
                    if (this.cc != ClassCategory.OTHER) break block97;
                    BeanMeta newMeta = null;
                    try {
                        newMeta = new BeanMeta(ClassMeta.this, bc, beanFilter, null);
                        this.notABeanReason = newMeta.notABeanReason;
                        this.beanRegistry = newMeta.beanRegistry;
                        this.typePropertyName = newMeta.typePropertyName;
                    }
                    catch (RuntimeException e) {
                        this.notABeanReason = e.getMessage();
                        throw e;
                    }
                    if (this.notABeanReason == null) {
                        this.beanMeta = newMeta;
                    }
                }
                catch (NoClassDefFoundError e) {
                    this.initException = e;
                }
                catch (RuntimeException e) {
                    this.initException = e;
                    throw e;
                }
            }
            if (this.beanMeta != null) {
                this.dictionaryName = this.beanMeta.getDictionaryName();
            }
            if (this.beanMeta != null && bc != null && bc.isUseInterfaceProxies() && innerClass.isInterface()) {
                this.invocationHandler = new BeanProxyInvocationHandler(this.beanMeta);
            }
            if (bc != null) {
                for (Bean b : bc.getAnnotations(Bean.class, c)) {
                    if (b.beanDictionary().length != 0) {
                        this.beanRegistry = new BeanRegistry(bc, null, b.beanDictionary());
                    }
                    if (b.dictionary().length != 0) {
                        this.beanRegistry = new BeanRegistry(bc, null, b.dictionary());
                    }
                    if (this.dictionaryName != null || b.typeName().isEmpty()) continue;
                    this.dictionaryName = b.typeName();
                }
            }
            if (example == null && bc != null) {
                for (Example e : bc.getAnnotations(Example.class, c)) {
                    if (e.value().isEmpty()) continue;
                    example = e.value();
                }
            }
            if (example == null) {
                switch (this.cc) {
                    case BOOLEAN: {
                        example = true;
                        break;
                    }
                    case CHAR: {
                        example = Character.valueOf('a');
                        break;
                    }
                    case CHARSEQ: 
                    case STR: {
                        example = "foo";
                        break;
                    }
                    case DECIMAL: {
                        if (ClassMeta.this.isFloat()) {
                            example = new Float(1.0f);
                            break;
                        }
                        if (!ClassMeta.this.isDouble()) break;
                        example = new Double(1.0);
                        break;
                    }
                    case ENUM: {
                        Iterator i = EnumSet.allOf(c).iterator();
                        if (!i.hasNext()) break;
                        example = i.next();
                        break;
                    }
                    case NUMBER: {
                        if (ClassMeta.this.isShort()) {
                            example = new Short(1);
                            break;
                        }
                        if (ClassMeta.this.isInteger()) {
                            example = new Integer(1);
                            break;
                        }
                        if (!ClassMeta.this.isLong()) break;
                        example = new Long(1L);
                        break;
                    }
                }
            }
            this.example = example;
            this.stringMutater = Mutaters.get(String.class, c);
        }

        private BeanFilter findBeanFilter(BeanContext bc) {
            try {
                List<Bean> ba = ClassMeta.this.info.getAnnotations(Bean.class, bc);
                if (!ba.isEmpty()) {
                    return new AnnotationBeanFilterBuilder<T>(this.innerClass, ba).build();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        private void findSwaps(List<PojoSwap> l, BeanContext bc) {
            PojoSwap<?, ?> defaultSwap;
            if (bc != null) {
                for (Swap swap : bc.getAnnotations(Swap.class, this.innerClass)) {
                    l.add(this.createPojoSwap(swap));
                }
                for (Swaps swaps : bc.getAnnotations(Swaps.class, this.innerClass)) {
                    for (Swap swap : swaps.value()) {
                        l.add(this.createPojoSwap(swap));
                    }
                }
            }
            if ((defaultSwap = DefaultSwaps.find(this.ci)) == null) {
                defaultSwap = AutoObjectSwap.find(bc, this.ci);
            }
            if (defaultSwap == null) {
                defaultSwap = AutoNumberSwap.find(bc, this.ci);
            }
            if (defaultSwap == null) {
                defaultSwap = AutoMapSwap.find(bc, this.ci);
            }
            if (defaultSwap == null) {
                defaultSwap = AutoListSwap.find(bc, this.ci);
            }
            if (defaultSwap != null) {
                l.add(defaultSwap);
            }
        }

        private PojoSwap<T, ?> createPojoSwap(Swap s) {
            List<SurrogateSwap<?, ?>> l;
            ClassInfo ci;
            Class<?> c = s.value();
            if (c == Null.class) {
                c = s.impl();
            }
            if ((ci = ClassInfo.of(c)).isChildOf(PojoSwap.class)) {
                PojoSwap ps = ClassUtils.castOrCreate(PojoSwap.class, c);
                if (s.mediaTypes().length > 0) {
                    ps.forMediaTypes(MediaType.ofAll(s.mediaTypes()));
                }
                if (!s.template().isEmpty()) {
                    ps.withTemplate(s.template());
                }
                return ps;
            }
            if (ci.isChildOf(Surrogate.class) && !(l = SurrogateSwap.findPojoSwaps(c, this.beanContext)).isEmpty()) {
                return l.iterator().next();
            }
            throw new ClassMetaRuntimeException(c, "Invalid swap class ''{0}'' specified.  Must extend from PojoSwap or Surrogate.", c);
        }

        private ClassMeta<?> findClassMeta(Class<?> c) {
            return this.beanContext.getClassMeta(c, false);
        }

        private ClassMeta<?>[] findParameters() {
            return this.beanContext.findParameters(this.innerClass, this.innerClass);
        }
    }

    static enum ClassCategory {
        MAP,
        COLLECTION,
        CLASS,
        METHOD,
        NUMBER,
        DECIMAL,
        BOOLEAN,
        CHAR,
        DATE,
        ARRAY,
        ENUM,
        OTHER,
        CHARSEQ,
        STR,
        OBJ,
        URI,
        BEANMAP,
        READER,
        INPUTSTREAM,
        VOID,
        ARGS,
        OPTIONAL;

    }
}

