/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.function.Supplier;
import org.apache.juneau.http.Constants;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.header.BasicStringRangeArrayHeader;
import org.apache.juneau.internal.Cache;

@Header(value="Accept-Encoding")
public class AcceptEncoding
extends BasicStringRangeArrayHeader {
    private static final long serialVersionUID = 1L;
    private static final Cache<String, AcceptEncoding> CACHE = new Cache(Constants.NOCACHE, Constants.CACHE_MAX_SIZE);

    public static AcceptEncoding of(String value) {
        if (value == null) {
            return null;
        }
        AcceptEncoding x = CACHE.get(value);
        if (x == null) {
            x = CACHE.put(value, new AcceptEncoding(value));
        }
        return x;
    }

    public static AcceptEncoding of(Object value) {
        if (value == null) {
            return null;
        }
        return new AcceptEncoding(value);
    }

    public static AcceptEncoding of(Supplier<?> value) {
        if (value == null) {
            return null;
        }
        return new AcceptEncoding(value);
    }

    public AcceptEncoding(Object value) {
        super("Accept-Encoding", value);
    }

    public AcceptEncoding(String value) {
        this((Object)value);
    }
}

