/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.apache.juneau.utils.Mutable;

public class ObjectUtils {
    public static Enum<?>[] getEnumConstants(Class<?> c) {
        return (Enum[])c.getEnumConstants();
    }

    public static <T> T castOrNull(Object o, Class<T> c) {
        if (c.isInstance(o)) {
            return (T)o;
        }
        return null;
    }

    public static int firstNonZero(int ... ints) {
        for (int i : ints) {
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    @SafeVarargs
    public static <T> T firstNonEmpty(T ... o) {
        for (T oo : o) {
            if (ObjectUtils.isEmpty(oo)) continue;
            return oo;
        }
        return null;
    }

    public static int compare(Object o1, Object o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.getClass() == o2.getClass() && o1 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        return 0;
    }

    public static final int compare(int i1, int i2) {
        return i1 < i2 ? -1 : (i1 == i2 ? 0 : 1);
    }

    public static <T, U> boolean eq(T o1, U o2, BiPredicate<T, U> test) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        return test.test(o1, o2);
    }

    public static boolean eq(Object o1, Object o2) {
        return Objects.equals(o1, o2);
    }

    public static <T, U> boolean ne(T o1, U o2, BiPredicate<T, U> test) {
        if (o1 == null) {
            return o2 != null;
        }
        if (o2 == null) {
            return true;
        }
        if (o1 == o2) {
            return false;
        }
        return !test.test(o1, o2);
    }

    public static boolean ne(Object o1, Object o2) {
        return !Objects.equals(o1, o2);
    }

    public static Object unwrap(Object o) {
        while (o instanceof Supplier) {
            o = ((Supplier)o).get();
        }
        while (o instanceof Mutable) {
            o = ((Mutable)o).get();
        }
        return o;
    }

    public static boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof Collection) {
            return ((Collection)o).isEmpty();
        }
        if (o instanceof Map) {
            return ((Map)o).isEmpty();
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o) == 0;
        }
        return o.toString().isEmpty();
    }

    public static boolean isNotEmpty(Object o) {
        return !ObjectUtils.isEmpty(o);
    }

    @SafeVarargs
    public static <T> T firstNonNull(T ... t) {
        if (t != null) {
            for (T tt : t) {
                if (tt == null) continue;
                return tt;
            }
        }
        return null;
    }
}

