/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.processor;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.processor.ResponseProcessor;
import org.apache.juneau.rest.util.FinishableServletOutputStream;

public final class HttpEntityProcessor
implements ResponseProcessor {
    @Override
    public int process(RestOpSession opSession) throws IOException {
        RestResponse res = opSession.getResponse();
        HttpEntity e = res.getContent(HttpEntity.class);
        if (e == null) {
            return 0;
        }
        res.setHeader(e.getContentType());
        res.setHeader(e.getContentEncoding());
        long contentLength = e.getContentLength();
        if (contentLength >= 0L) {
            res.setHeader(HttpHeaders.contentLength(contentLength));
        }
        try (FinishableServletOutputStream os = res.getNegotiatedOutputStream();){
            e.writeTo((OutputStream)((Object)os));
            ((OutputStream)((Object)os)).flush();
        }
        return 1;
    }
}

