/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.openapi3;

import java.lang.reflect.Type;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.dto.openapi3.Example;
import org.apache.juneau.dto.openapi3.OpenApiElement;
import org.apache.juneau.dto.openapi3.SchemaInfo;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;

@Bean(properties="description,explode,deprecated,allowEmptyValue,allowReserved,schema,example,examples,$ref,*")
@FluentSetters
public class HeaderInfo
extends OpenApiElement {
    private String description;
    private String ref;
    private Boolean required;
    private Boolean explode;
    private Boolean deprecated;
    private Boolean allowEmptyValue;
    private Boolean allowReserved;
    private SchemaInfo schema;
    private Object example;
    private Map<String, Example> examples;

    public HeaderInfo() {
    }

    public HeaderInfo(HeaderInfo copyFrom) {
        super(copyFrom);
        this.description = copyFrom.description;
        this.example = copyFrom.example;
        this.allowEmptyValue = copyFrom.allowEmptyValue;
        this.schema = copyFrom.schema;
        this.allowReserved = copyFrom.allowReserved;
        this.required = copyFrom.required;
        this.ref = copyFrom.ref;
        this.explode = copyFrom.explode;
        this.deprecated = copyFrom.deprecated;
        this.examples = copyFrom.examples == null ? null : new LinkedHashMap<String, Example>();
        for (Map.Entry<String, Example> e : copyFrom.examples.entrySet()) {
            this.examples.put(e.getKey(), e.getValue().copy());
        }
    }

    public HeaderInfo copy() {
        return new HeaderInfo(this);
    }

    @Override
    protected HeaderInfo strict() {
        super.strict();
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public HeaderInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public HeaderInfo setRequired(Boolean value) {
        this.required = value;
        return this;
    }

    public Boolean getExplode() {
        return this.explode;
    }

    public HeaderInfo setExplode(Boolean value) {
        this.explode = value;
        return this;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public HeaderInfo setDeprecated(Boolean value) {
        this.deprecated = value;
        return this;
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public HeaderInfo setAllowEmptyValue(Boolean value) {
        this.allowEmptyValue = value;
        return this;
    }

    public Boolean getAllowReserved() {
        return this.allowReserved;
    }

    public HeaderInfo setAllowReserved(Boolean value) {
        this.allowReserved = value;
        return this;
    }

    public SchemaInfo getSchema() {
        return this.schema;
    }

    public HeaderInfo setSchema(SchemaInfo value) {
        this.schema = value;
        return this;
    }

    @Beanp(value="$ref")
    public String getRef() {
        return this.ref;
    }

    @Beanp(value="$ref")
    public HeaderInfo setRef(String value) {
        this.ref = value;
        return this;
    }

    @Beanp(value="x-example")
    public Object getExample() {
        return this.example;
    }

    @Beanp(value="x-example")
    public HeaderInfo setExample(Object value) {
        this.example = value;
        return this;
    }

    public Map<String, Example> getExamples() {
        return this.examples;
    }

    public HeaderInfo setExamples(Map<String, Example> value) {
        this.examples = CollectionUtils.copyOf(value);
        return this;
    }

    public HeaderInfo addExample(String name, Example example) {
        this.examples = CollectionUtils.mapBuilder(this.examples).sparse().add(name, example).build();
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "description": {
                return (T)this.getDescription();
            }
            case "required": {
                return ConverterUtils.toType(this.getRequired(), type);
            }
            case "explode": {
                return ConverterUtils.toType(this.getExplode(), type);
            }
            case "deprecated": {
                return ConverterUtils.toType(this.getDeprecated(), type);
            }
            case "allowEmptyValue": {
                return ConverterUtils.toType(this.getAllowEmptyValue(), type);
            }
            case "allowReserved": {
                return ConverterUtils.toType(this.getAllowReserved(), type);
            }
            case "$ref": {
                return ConverterUtils.toType(this.getRef(), type);
            }
            case "schema": {
                return ConverterUtils.toType(this.getSchema(), type);
            }
            case "x-example": {
                return ConverterUtils.toType(this.getExample(), type);
            }
            case "examples": {
                return ConverterUtils.toType(this.getExamples(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public HeaderInfo set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "description": {
                return this.setDescription(StringUtils.stringify(value));
            }
            case "required": {
                return this.setRequired(ConverterUtils.toBoolean(value));
            }
            case "explode": {
                return this.setExplode(ConverterUtils.toBoolean(value));
            }
            case "deprecated": {
                return this.setDeprecated(ConverterUtils.toBoolean(value));
            }
            case "allowEmptyValue": {
                return this.setAllowEmptyValue(ConverterUtils.toBoolean(value));
            }
            case "$ref": {
                return this.setRef(StringUtils.stringify(value));
            }
            case "schema": {
                return this.setSchema(ConverterUtils.toType(value, SchemaInfo.class));
            }
            case "x-example": {
                return this.setExample(StringUtils.stringify(value));
            }
            case "examples": {
                return this.setExamples(CollectionUtils.mapBuilder(String.class, Example.class, new Type[0]).sparse().addAny(value).build());
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setBuilder(String.class, new Type[0]).addIf(this.description != null, "description").addIf(this.required != null, "required").addIf(this.explode != null, "explode").addIf(this.deprecated != null, "deprecated").addIf(this.allowEmptyValue != null, "allowEmptyValue").addIf(this.ref != null, "$ref").addIf(this.allowReserved != null, "allowReserved").addIf(this.schema != null, "schema").addIf(this.example != null, "example").addIf(this.examples != null, "examples").build();
        return new MultiSet<String>(s, super.keySet());
    }

    public HeaderInfo resolveRefs(Swagger swagger, Deque<String> refStack, int maxDepth) {
        if (this.ref != null) {
            if (refStack.contains(this.ref) || refStack.size() >= maxDepth) {
                return this;
            }
            refStack.addLast(this.ref);
            HeaderInfo r = swagger.findRef(this.ref, HeaderInfo.class).resolveRefs(swagger, refStack, maxDepth);
            refStack.removeLast();
            return r;
        }
        return this;
    }
}

