/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.juneau.internal.ConsumerUtils;

public final class ArrayBuilder<E> {
    private Predicate<E> filter;
    private final Class<E> elementType;
    private int size = -1;
    private int i = 0;
    private List<E> list;

    public static <E> ArrayBuilder<E> of(Class<E> elementType) {
        return new ArrayBuilder<E>(elementType);
    }

    public ArrayBuilder(Class<E> elementType) {
        this.elementType = elementType;
    }

    public ArrayBuilder<E> size(int value) {
        this.size = value;
        return this;
    }

    public ArrayBuilder<E> filter(Predicate<E> value) {
        this.filter = value;
        return this;
    }

    public ArrayBuilder<E> add(E t) {
        if (ConsumerUtils.test(this.filter, t)) {
            if (this.list == null) {
                this.list = this.size < 0 ? new ArrayList() : new ArrayList(this.size);
            }
            this.list.add(t);
            ++this.i;
        }
        return this;
    }

    public E[] orElse(E[] def) {
        if (this.list == null) {
            return def;
        }
        Object[] t = (Object[])Array.newInstance(this.elementType, this.list == null ? 0 : this.list.size());
        if (this.list != null) {
            this.list.toArray(t);
        }
        return t;
    }
}

