/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.common.utils.Snippet;

public final class Flag {
    private boolean value;

    public static Flag create() {
        return Flag.of(false);
    }

    public static Flag of(boolean value) {
        return new Flag(value);
    }

    private Flag(boolean value) {
        this.value = value;
    }

    public Flag ifSet(Snippet snippet) {
        if (this.value) {
            this.runSnippet(snippet);
        }
        return this;
    }

    public Flag ifNotSet(Snippet snippet) {
        if (!this.value) {
            this.runSnippet(snippet);
        }
        return this;
    }

    private void runSnippet(Snippet snippet) {
        try {
            snippet.run();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw ThrowableUtils.asRuntimeException(e);
        }
    }

    public boolean getAndSet() {
        boolean b = this.value;
        this.value = true;
        return b;
    }

    public boolean getAndUnset() {
        boolean v = this.value;
        this.value = false;
        return v;
    }

    public Flag set() {
        this.value = true;
        return this;
    }

    public Flag unset() {
        this.value = false;
        return this;
    }

    public boolean isSet() {
        return this.value;
    }

    public boolean isUnset() {
        return !this.value;
    }

    public Flag setIf(boolean value) {
        this.value |= value;
        return this;
    }
}

