/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ad;

import java.util.Collection;
import org.ldaptive.LdapAttribute;
import org.ldaptive.SortBehavior;
import org.ldaptive.ad.io.UnicodePwdValueTranscoder;

public class UnicodePwdAttribute
extends LdapAttribute {
    private static final long serialVersionUID = -6140237711183070669L;
    private static final String ATTR_NAME = "unicodePwd";
    private static final UnicodePwdValueTranscoder TRANSCODER = new UnicodePwdValueTranscoder();

    public UnicodePwdAttribute() {
        super(SortBehavior.UNORDERED, true);
        this.setName(ATTR_NAME);
    }

    public UnicodePwdAttribute(String ... values) {
        this();
        this.addStringValue(values);
    }

    @Override
    public Collection<String> getStringValues() {
        return this.getValues(TRANSCODER);
    }

    @Override
    public void addStringValue(String ... value) {
        for (String s : value) {
            this.addValue(TRANSCODER, value);
        }
    }

    @Override
    public void removeStringValue(String ... value) {
        for (String s : value) {
            this.removeBinaryValue(new byte[][]{TRANSCODER.encodeBinaryValue(s)});
        }
    }
}

