/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.impl.curator;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.ServerMode;
import org.apache.kylin.common.util.ZKUtil;
import org.apache.kylin.job.Scheduler;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.exception.SchedulerException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.impl.curator.CuratorLeaderSelector;
import org.apache.kylin.job.lock.JobLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorScheduler
implements Scheduler<AbstractExecutable> {
    private static final Logger logger = LoggerFactory.getLogger(CuratorScheduler.class);
    private boolean started = false;
    private CuratorFramework curatorClient = null;
    private static CuratorLeaderSelector jobClient = null;
    private KylinConfig kylinConfig;
    private AtomicInteger count = new AtomicInteger();
    static final String JOB_ENGINE_LEADER_PATH = "/job_engine/leader";

    public CuratorScheduler() {
    }

    @VisibleForTesting
    CuratorScheduler(CuratorFramework curatorClient) {
        this.curatorClient = curatorClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(JobEngineConfig jobEngineConfig, JobLock jobLock) throws SchedulerException {
        this.kylinConfig = jobEngineConfig.getConfig();
        CuratorScheduler curatorScheduler = this;
        synchronized (curatorScheduler) {
            if (this.started) {
                logger.info("CuratorScheduler already started, skipped.");
                return;
            }
            if (this.curatorClient == null) {
                this.curatorClient = ZKUtil.getZookeeperClient(this.kylinConfig);
            }
            String restAddress = this.kylinConfig.getServerRestAddress();
            String jobEnginePath = JOB_ENGINE_LEADER_PATH;
            if (ServerMode.isJob(jobEngineConfig.getConfig())) {
                jobClient = new CuratorLeaderSelector(this.curatorClient, jobEnginePath, restAddress, jobEngineConfig);
                try {
                    logger.info("start Job Engine, lock path is: " + jobEnginePath);
                    jobClient.start();
                    this.monitorJobEngine();
                }
                catch (IOException e) {
                    throw new SchedulerException(e);
                }
            } else {
                logger.info("server mode: " + jobEngineConfig.getConfig().getServerMode() + ", no need to run job scheduler");
            }
            this.started = true;
        }
    }

    private void monitorJobEngine() {
        logger.info("Start collect monitor ZK Participants");
        CuratorScheduler curatorScheduler = this;
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean hasLeadership = jobClient.hasLeadership();
                    boolean hasDefaultSchedulerStarted = jobClient.hasDefaultSchedulerStarted();
                    if (hasLeadership != hasDefaultSchedulerStarted) {
                        logger.error("Node(" + InetAddress.getLocalHost().getHostAddress() + ") job server state conflict. Is ZK leader: " + hasLeadership + "; Is active job server: " + hasDefaultSchedulerStarted);
                    }
                    if (CuratorScheduler.this.count.incrementAndGet() == 10) {
                        logger.info("Current Participants: " + jobClient.getParticipants());
                        CuratorScheduler.this.count.set(0);
                    }
                }
                catch (Throwable th) {
                    logger.error("Error when getting JVM info.", th);
                }
            }
        }, 3L, curatorScheduler.kylinConfig.getInstanceFromEnv().getZKMonitorInterval(), TimeUnit.SECONDS);
    }

    @Override
    public void shutdown() throws SchedulerException {
        IOUtils.closeQuietly((Closeable)this.curatorClient);
        IOUtils.closeQuietly((Closeable)jobClient);
        this.started = false;
    }

    public static String slickMetadataPrefix(String metadataPrefix) {
        if (metadataPrefix.indexOf("/") >= 0) {
            if (metadataPrefix.endsWith("/")) {
                metadataPrefix = metadataPrefix.substring(0, metadataPrefix.length() - 2);
            }
            return metadataPrefix.substring(metadataPrefix.lastIndexOf("/") + 1);
        }
        return metadataPrefix;
    }

    @Override
    public boolean hasStarted() {
        return this.started;
    }

    public static CuratorLeaderSelector getLeaderSelector() {
        return jobClient;
    }
}

