/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.shaded.com.codahale.metrics.json;

import java.io.IOException;
import java.util.Arrays;
import org.apache.kylin.job.shaded.com.codahale.metrics.health.HealthCheck;
import org.apache.kylin.job.shaded.com.codahale.metrics.json.MetricsModule;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.core.Version;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.Module;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.module.SimpleSerializers;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;

public class HealthCheckModule
extends Module {
    @Override
    public String getModuleName() {
        return "healthchecks";
    }

    @Override
    public Version version() {
        return MetricsModule.VERSION;
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        context.addSerializers(new SimpleSerializers(Arrays.asList(new HealthCheckResultSerializer())));
    }

    private static class HealthCheckResultSerializer
    extends StdSerializer<HealthCheck.Result> {
        private HealthCheckResultSerializer() {
            super(HealthCheck.Result.class);
        }

        @Override
        public void serialize(HealthCheck.Result result, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            json.writeBooleanField("healthy", result.isHealthy());
            String message = result.getMessage();
            if (message != null) {
                json.writeStringField("message", message);
            }
            this.serializeThrowable(json, result.getError(), "error");
            json.writeEndObject();
        }

        private void serializeThrowable(JsonGenerator json, Throwable error, String name) throws IOException {
            if (error != null) {
                json.writeObjectFieldStart(name);
                json.writeStringField("message", error.getMessage());
                json.writeArrayFieldStart("stack");
                for (StackTraceElement element : error.getStackTrace()) {
                    json.writeString(element.toString());
                }
                json.writeEndArray();
                if (error.getCause() != null) {
                    this.serializeThrowable(json, error.getCause(), "cause");
                }
                json.writeEndObject();
            }
        }
    }
}

