/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.map.bitmap;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.measure.bitmap.BitmapCounter;
import org.apache.kylin.measure.map.MapKeySerializer;

public abstract class BitmapCounterMap<T>
implements Serializable {
    private final MapKeySerializer<T> keySerializer;
    private Map<T, BitmapCounter> counterMap;

    BitmapCounterMap(MapKeySerializer<T> keySerializer) {
        this.keySerializer = keySerializer;
        this.counterMap = Maps.newHashMap();
    }

    private BitmapCounter getMutableBitmap(T key) {
        BitmapCounter bitmap = this.counterMap.get(key);
        if (bitmap == null) {
            bitmap = this.newBitmapCounter();
            this.counterMap.put(key, bitmap);
        }
        return bitmap;
    }

    public void add(T key, int value) {
        this.getMutableBitmap(key).add(value);
    }

    public void clear() {
        this.counterMap = Maps.newHashMap();
    }

    public void orWith(BitmapCounterMap another) {
        Map<T, BitmapCounter> inputCounterMap = another.counterMap;
        for (T key : inputCounterMap.keySet()) {
            this.getMutableBitmap(key).orWith(inputCounterMap.get(key));
        }
    }

    public long getCount() {
        long result = 0L;
        for (BitmapCounter bitmapCounter : this.counterMap.values()) {
            result += bitmapCounter.getCount();
        }
        return result;
    }

    public int getMemBytes() {
        int result = 0;
        for (BitmapCounter bitmapCounter : this.counterMap.values()) {
            result += bitmapCounter.getMemBytes();
        }
        return result;
    }

    public int peekLength(ByteBuffer in) {
        ByteBuffer bbf = in.slice();
        try {
            this.getCounterMap(bbf);
            return bbf.position();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write(ByteBuffer out) throws IOException {
        BytesUtil.writeVInt(this.counterMap.size(), out);
        for (T key : this.counterMap.keySet()) {
            this.keySerializer.writeKey(out, key);
            this.counterMap.get(key).write(out);
        }
    }

    public void readFields(ByteBuffer in) throws IOException {
        this.counterMap = this.getCounterMap(in);
    }

    private Map<T, BitmapCounter> getCounterMap(ByteBuffer in) throws IOException {
        int size = BytesUtil.readVInt(in);
        HashMap<T, BitmapCounter> counterMap = Maps.newHashMapWithExpectedSize(size);
        for (int i = 0; i < size; ++i) {
            T key = this.keySerializer.readKey(in);
            BitmapCounter bitmapCounter = this.newBitmapCounter();
            bitmapCounter.readFields(in);
            counterMap.put(key, bitmapCounter);
        }
        return counterMap;
    }

    protected abstract BitmapCounter newBitmapCounter();
}

