/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.io.Serializable;
import java.util.Locale;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ColumnDesc
implements Serializable {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="datatype")
    private String datatype;
    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String comment;
    @JsonProperty(value="data_gen")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String dataGen;
    @JsonProperty(value="index")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String index;
    @JsonProperty(value="cc_expr")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String computedColumnExpr = null;
    private DataType type;
    private TableDesc table;
    private int zeroBasedIndex = -1;
    private boolean isNullable = true;
    private TblColRef ref;

    public ColumnDesc() {
    }

    public ColumnDesc(ColumnDesc other) {
        this.id = other.id;
        this.name = other.name;
        this.datatype = other.datatype;
        this.dataGen = other.datatype;
        this.comment = other.comment;
        this.dataGen = other.dataGen;
        this.index = other.index;
        this.computedColumnExpr = other.computedColumnExpr;
    }

    public ColumnDesc(String id, String name, String datatype, String comment, String dataGen, String index, String computedColumnExpr) {
        this.id = id;
        this.name = name;
        this.datatype = datatype;
        this.comment = comment;
        this.dataGen = dataGen;
        this.index = index;
        this.computedColumnExpr = computedColumnExpr;
    }

    @Deprecated
    public TblColRef getRef() {
        if (this.ref == null) {
            this.ref = new TblColRef(this);
        }
        return this.ref;
    }

    public int getZeroBasedIndex() {
        return this.zeroBasedIndex;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
        this.type = DataType.getType(datatype);
    }

    public DataType getUpgradedType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        if (id != null) {
            this.zeroBasedIndex = Integer.parseInt(id) - 1;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TableDesc getTable() {
        return this.table;
    }

    public void setTable(TableDesc table) {
        this.table = table;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public DataType getType() {
        if (this.type == null && this.datatype != null) {
            this.type = DataType.getType(this.datatype);
        }
        return this.type;
    }

    public String getTypeName() {
        return this.type.getName();
    }

    public int getTypePrecision() {
        return this.type.getPrecision();
    }

    public int getTypeScale() {
        return this.type.getScale();
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public void setNullable(boolean nullable) {
        this.isNullable = nullable;
    }

    public String getDataGen() {
        return this.dataGen;
    }

    public String getIndex() {
        return this.index;
    }

    public String getComputedColumnExpr() {
        Preconditions.checkState(this.computedColumnExpr != null);
        return this.computedColumnExpr;
    }

    public boolean isComputedColumn() {
        return this.computedColumnExpr != null;
    }

    public void init(TableDesc table) {
        DataType normalized;
        this.table = table;
        if (this.name != null) {
            this.name = this.name.toUpperCase(Locale.ROOT);
        }
        if (this.id != null) {
            this.zeroBasedIndex = Integer.parseInt(this.id) - 1;
        }
        if ((normalized = DataType.getType(this.datatype)) == null) {
            this.setDatatype(null);
        } else {
            this.setDatatype(normalized.toString());
        }
    }

    public static ColumnDesc mockup(TableDesc table, int oneBasedColumnIndex, String name, String datatype) {
        ColumnDesc desc = new ColumnDesc();
        String id = "" + oneBasedColumnIndex;
        desc.setId(id);
        desc.setName(name);
        desc.setDatatype(datatype);
        desc.init(table);
        return desc;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnDesc other = (ColumnDesc)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.table == null ? other.table != null : !this.table.getIdentity().equals(other.table.getIdentity()));
    }

    public String toString() {
        return "ColumnDesc{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", datatype='" + this.datatype + '\'' + ", comment='" + this.comment + '\'' + '}';
    }
}

