/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ModelDimensionDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="table")
    private String table;
    @JsonProperty(value="columns")
    private String[] columns;

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public void setColumns(String[] columns) {
        this.columns = columns;
    }

    void init(DataModelDesc model) {
        this.table = this.table.toUpperCase(Locale.ROOT);
        if (this.columns != null) {
            StringUtil.toUpperCaseArray(this.columns, this.columns);
        }
        if (model != null) {
            this.table = model.findTable(this.table).getAlias();
            if (this.columns != null) {
                for (int i = 0; i < this.columns.length; ++i) {
                    TblColRef column = model.findColumn(this.table, this.columns[i]);
                    if (column.getColumnDesc().isComputedColumn() && !model.isFactTable(column.getTableRef())) {
                        throw new RuntimeException("Computed Column on lookup table is not allowed");
                    }
                    this.columns[i] = column.getName();
                }
            }
        }
    }

    public static void capicalizeStrings(List<ModelDimensionDesc> dimensions) {
        if (dimensions != null) {
            for (ModelDimensionDesc modelDimensionDesc : dimensions) {
                modelDimensionDesc.init(null);
            }
        }
    }

    public static int getColumnCount(List<ModelDimensionDesc> modelDimensionDescs) {
        int count = 0;
        for (ModelDimensionDesc modelDimensionDesc : modelDimensionDescs) {
            if (modelDimensionDesc.getColumns() == null) continue;
            count += modelDimensionDesc.getColumns().length;
        }
        return count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelDimensionDesc that = (ModelDimensionDesc)o;
        return Objects.equals(this.table, that.table) && Arrays.equals(this.columns, that.columns);
    }

    public int hashCode() {
        int result = Objects.hash(this.table);
        result = 31 * result + Arrays.hashCode(this.columns);
        return result;
    }
}

