/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.query;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.stream.core.query.HavingFilterChecker;
import org.apache.kylin.stream.core.query.ResponseResultSchema;
import org.apache.kylin.stream.core.storage.Record;

public class RecordsAggregator
implements Iterable<Record> {
    private SortedMap<String[], MeasureAggregator[]> aggBufMap;
    private ResponseResultSchema schema;
    private int[] groupIndexes;
    private int pushDownLimit;
    private TupleFilter havingFilter;
    final Comparator<String[]> comparator = new Comparator<String[]>(){

        @Override
        public int compare(String[] o1, String[] o2) {
            int result = 0;
            for (int i = 0; i < RecordsAggregator.this.groupIndexes.length; ++i) {
                int groupIdx = RecordsAggregator.this.groupIndexes[i];
                if (o1[groupIdx] == null && o2[groupIdx] == null) continue;
                if (o1[groupIdx] != null && o2[groupIdx] == null) {
                    return 1;
                }
                if (o1[groupIdx] == null && o2[groupIdx] != null) {
                    return -1;
                }
                result = o1[groupIdx].compareTo(o2[groupIdx]);
                if (result == 0) continue;
                return result;
            }
            return result;
        }
    };

    public RecordsAggregator(ResponseResultSchema schema, Set<TblColRef> groups, TupleFilter havingFilter) {
        this.schema = schema;
        this.havingFilter = havingFilter;
        this.groupIndexes = new int[groups.size()];
        int i = 0;
        for (TblColRef group : groups) {
            this.groupIndexes[i] = schema.getIndexOfDimension(group);
            ++i;
        }
        this.aggBufMap = Maps.newTreeMap(this.comparator);
        this.pushDownLimit = Integer.MAX_VALUE;
    }

    @Override
    public Iterator<Record> iterator() {
        Iterator<Map.Entry<String[], MeasureAggregator[]>> it;
        final Iterator<Map.Entry<String[], MeasureAggregator[]>> input = it = this.aggBufMap.entrySet().iterator();
        return new Iterator<Record>(){
            Record oneRecord;
            Map.Entry<String[], MeasureAggregator[]> returningEntry;
            final HavingFilterChecker havingFilterChecker;
            {
                this.oneRecord = new Record(RecordsAggregator.this.schema.getDimensionCount(), RecordsAggregator.this.schema.getMetricsCount());
                this.returningEntry = null;
                this.havingFilterChecker = RecordsAggregator.this.havingFilter == null ? null : new HavingFilterChecker(RecordsAggregator.this.havingFilter, RecordsAggregator.this.schema);
            }

            @Override
            public boolean hasNext() {
                while (input.hasNext()) {
                    this.returningEntry = (Map.Entry)input.next();
                    if (this.havingFilterChecker != null) {
                        if (!this.havingFilterChecker.check(this.returningEntry.getValue())) continue;
                        return true;
                    }
                    return true;
                }
                return false;
            }

            @Override
            public Record next() {
                String[] dimVals = this.returningEntry.getKey();
                for (int i = 0; i < dimVals.length; ++i) {
                    this.oneRecord.setDimension(i, dimVals[i]);
                }
                MeasureAggregator[] measures = this.returningEntry.getValue();
                for (int i = 0; i < measures.length; ++i) {
                    this.oneRecord.setMetric(i, measures[i].getState());
                }
                return this.oneRecord;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("unSupportOperation!");
            }
        };
    }

    public void aggregate(Iterator<Record> records) {
        while (records.hasNext()) {
            this.aggregate(records.next());
        }
    }

    public void aggregate(Record record) {
        String[] copyDimVals = new String[this.schema.getDimensionCount()];
        String[] dimVals = record.getDimensions();
        System.arraycopy(dimVals, 0, copyDimVals, 0, dimVals.length);
        this.aggregate(copyDimVals, record.getMetrics());
    }

    public void aggregate(String[] dimVals, Object[] metricsVals) {
        MeasureAggregator[] aggrs = (MeasureAggregator[])this.aggBufMap.get(dimVals);
        if (aggrs == null) {
            if (this.aggBufMap.size() >= this.pushDownLimit) {
                return;
            }
            aggrs = this.newAggregators();
            this.aggBufMap.put(dimVals, aggrs);
        }
        for (int i = 0; i < aggrs.length; ++i) {
            aggrs[i].aggregate(metricsVals[i]);
        }
    }

    private MeasureAggregator[] newAggregators() {
        String[] aggrFuncs = this.schema.getAggrFuncs();
        MeasureAggregator[] result = new MeasureAggregator[aggrFuncs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = MeasureAggregator.create(aggrFuncs[i], this.schema.getMetricsDataType(i));
        }
        return result;
    }
}

