/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.cube.kv.CubeDimEncMap;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dict.BuiltInFunctionTransformer;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.IDimensionEncodingMap;
import org.apache.kylin.dimension.TimeDerivedColumnType;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.FilterOptimizeTransformer;
import org.apache.kylin.metadata.filter.ITupleFilterTransformer;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.StringCodeSystem;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.TupleFilterSerializer;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.stream.core.query.IStreamingGTSearcher;
import org.apache.kylin.stream.core.query.IStreamingSearchResult;
import org.apache.kylin.stream.core.query.ResponseResultSchema;
import org.apache.kylin.stream.core.query.ResultCollector;
import org.apache.kylin.stream.core.query.StreamingSearchContext;
import org.apache.kylin.stream.core.storage.columnar.ColumnarMetricsEncoding;
import org.apache.kylin.stream.core.storage.columnar.ColumnarRecordCodec;
import org.apache.kylin.stream.core.storage.columnar.DataSegmentFragment;
import org.apache.kylin.stream.core.storage.columnar.FragmentData;
import org.apache.kylin.stream.core.storage.columnar.FragmentSearchResult;
import org.apache.kylin.stream.core.storage.columnar.ParsedStreamingCubeInfo;
import org.apache.kylin.stream.core.storage.columnar.protocol.CuboidMetaInfo;
import org.apache.kylin.stream.core.storage.columnar.protocol.FragmentMetaInfo;
import org.apache.kylin.stream.core.util.CompareFilterTimeRangeChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentFileSearcher
implements IStreamingGTSearcher {
    private static Logger logger = LoggerFactory.getLogger(FragmentFileSearcher.class);
    private FragmentData fragmentData;
    private DataSegmentFragment fragment;

    public FragmentFileSearcher(DataSegmentFragment fragment, FragmentData fragmentData) {
        this.fragment = fragment;
        this.fragmentData = fragmentData;
    }

    @Override
    public void search(StreamingSearchContext searchContext, ResultCollector collector) throws IOException {
        CuboidMetaInfo cuboidMetaInfo;
        String timezone = searchContext.getCubeDesc().getConfig().getStreamingDerivedTimeTimezone();
        long timezoneOffset = 0L;
        if (timezone != null && timezone.length() > 0) {
            timezoneOffset = TimeZone.getTimeZone(timezone).getRawOffset();
        }
        FragmentMetaInfo fragmentMetaInfo = this.fragmentData.getFragmentMetaInfo();
        if (searchContext.hitBasicCuboid()) {
            cuboidMetaInfo = fragmentMetaInfo.getBasicCuboidMetaInfo();
        } else {
            cuboidMetaInfo = fragmentMetaInfo.getCuboidMetaInfo(searchContext.getHitCuboid());
            if (cuboidMetaInfo == null) {
                logger.warn("the cuboid:{} is not exist in the fragment:{}, use basic cuboid instead", (Object)searchContext.getHitCuboid(), (Object)this.fragment.getFragmentId());
                cuboidMetaInfo = fragmentMetaInfo.getBasicCuboidMetaInfo();
            }
        }
        ResponseResultSchema responseSchema = searchContext.getRespResultSchema();
        TblColRef[] dimensions = responseSchema.getDimensions();
        FunctionDesc[] metrics = responseSchema.getMetrics();
        Map<TblColRef, Dictionary<String>> dictMap = this.fragmentData.getDimensionDictionaries(dimensions);
        CubeDesc cubeDesc = responseSchema.getCubeDesc();
        List<MeasureDesc> allMeasures = cubeDesc.getMeasures();
        HashMap<FunctionDesc, MeasureDesc> funcMeasureMap = Maps.newHashMap();
        for (MeasureDesc measure : allMeasures) {
            funcMeasureMap.put(measure.getFunction(), measure);
        }
        MeasureDesc[] measures = new MeasureDesc[metrics.length];
        for (int i = 0; i < measures.length; ++i) {
            measures[i] = (MeasureDesc)funcMeasureMap.get(metrics[i]);
        }
        DimensionEncoding[] dimensionEncodings = ParsedStreamingCubeInfo.getDimensionEncodings(cubeDesc, dimensions, dictMap);
        ColumnarMetricsEncoding[] metricsEncodings = ParsedStreamingCubeInfo.getMetricsEncodings(measures);
        ColumnarRecordCodec recordCodec = new ColumnarRecordCodec(dimensionEncodings, metricsEncodings);
        HashSet<TblColRef> unEvaluateDims = Sets.newHashSet();
        TupleFilter fragmentFilter = null;
        if (searchContext.getFilter() != null) {
            fragmentFilter = this.convertFilter(fragmentMetaInfo, searchContext.getFilter(), recordCodec, dimensions, new CubeDimEncMap(cubeDesc, dictMap), unEvaluateDims, timezoneOffset);
        }
        if (ConstantTupleFilter.TRUE == fragmentFilter) {
            fragmentFilter = null;
        } else if (ConstantTupleFilter.FALSE == fragmentFilter) {
            collector.collectSearchResult(IStreamingSearchResult.EMPTY_RESULT);
        }
        Set<TblColRef> groups = searchContext.getGroups();
        if (!unEvaluateDims.isEmpty()) {
            searchContext.addNewGroups(unEvaluateDims);
            groups = Sets.union(groups, unEvaluateDims);
        }
        collector.collectSearchResult(new FragmentSearchResult(this.fragment, this.fragmentData, cuboidMetaInfo, responseSchema, fragmentFilter, groups, searchContext.getHavingFilter(), recordCodec));
    }

    private TupleFilter convertFilter(FragmentMetaInfo fragmentMetaInfo, TupleFilter rootFilter, ColumnarRecordCodec recordCodec, TblColRef[] dimensions, IDimensionEncodingMap dimEncodingMap, Set<TblColRef> unEvaluableColumnCollector, long timezoneOffset) {
        HashMap<TblColRef, Integer> colMapping = Maps.newHashMap();
        for (int i = 0; i < dimensions.length; ++i) {
            colMapping.put(dimensions[i], i);
        }
        byte[] bytes = TupleFilterSerializer.serialize(rootFilter, null, StringCodeSystem.INSTANCE);
        TupleFilter filter = TupleFilterSerializer.deserialize(bytes, StringCodeSystem.INSTANCE);
        BuiltInFunctionTransformer builtInFunctionTransformer = new BuiltInFunctionTransformer(dimEncodingMap);
        filter = builtInFunctionTransformer.transform(filter);
        FragmentFilterConverter fragmentFilterConverter = new FragmentFilterConverter(fragmentMetaInfo, unEvaluableColumnCollector, colMapping, recordCodec);
        fragmentFilterConverter.setTimezoneOffset(timezoneOffset);
        filter = fragmentFilterConverter.transform(filter);
        filter = new FilterOptimizeTransformer().transform(filter);
        return filter;
    }

    protected static class FragmentFilterConverter
    implements ITupleFilterTransformer {
        protected final Set<TblColRef> unEvaluableColumnCollector;
        protected final Map<TblColRef, Integer> colMapping;
        private CompareFilterTimeRangeChecker filterTimeRangeChecker;
        private ColumnarRecordCodec recordCodec;
        transient ByteBuffer buf;
        private long timezoneOffset = 0L;

        public FragmentFilterConverter(FragmentMetaInfo fragmentMetaInfo, Set<TblColRef> unEvaluableColumnCollector, Map<TblColRef, Integer> colMapping, ColumnarRecordCodec recordCodec) {
            this.unEvaluableColumnCollector = unEvaluableColumnCollector;
            this.recordCodec = recordCodec;
            this.colMapping = colMapping;
            if (fragmentMetaInfo.hasValidEventTimeRange()) {
                this.filterTimeRangeChecker = new CompareFilterTimeRangeChecker(fragmentMetaInfo.getMinEventTime(), fragmentMetaInfo.getMaxEventTime(), true);
            }
            this.buf = ByteBuffer.allocate(recordCodec.getMaxDimLength());
        }

        protected int mapCol(TblColRef col) {
            Integer i = this.colMapping.get(col);
            return i == null ? -1 : i;
        }

        @Override
        public TupleFilter transform(TupleFilter filter) {
            if (filter.getOperator() == TupleFilter.FilterOperatorEnum.NOT && !TupleFilter.isEvaluableRecursively(filter)) {
                TupleFilter.collectColumns(filter, this.unEvaluableColumnCollector);
                return ConstantTupleFilter.TRUE;
            }
            if (!filter.isEvaluable()) {
                TupleFilter.collectColumns(filter, this.unEvaluableColumnCollector);
                return ConstantTupleFilter.TRUE;
            }
            if (filter instanceof CompareTupleFilter) {
                return this.translateCompareFilter((CompareTupleFilter)filter);
            }
            if (filter instanceof LogicalTupleFilter) {
                ListIterator<? extends TupleFilter> childIterator = filter.getChildren().listIterator();
                while (childIterator.hasNext()) {
                    TupleFilter transformed = this.transform(childIterator.next());
                    if (transformed != null) {
                        childIterator.set(transformed);
                        continue;
                    }
                    throw new IllegalStateException("Should not be null");
                }
            }
            return filter;
        }

        protected TupleFilter translateCompareFilter(CompareTupleFilter oldCompareFilter) {
            TupleFilter result;
            TblColRef externalCol = oldCompareFilter.getColumn();
            if (externalCol == null) {
                return oldCompareFilter;
            }
            Collection constValues = oldCompareFilter.getValues();
            if (constValues == null || constValues.isEmpty()) {
                return oldCompareFilter;
            }
            if (TimeDerivedColumnType.isTimeDerivedColumn(externalCol.getName()) && this.filterTimeRangeChecker != null) {
                CompareFilterTimeRangeChecker.CheckResult checkResult = this.filterTimeRangeChecker.check(oldCompareFilter, TimeDerivedColumnType.getTimeDerivedColumnType(externalCol.getName()), this.timezoneOffset);
                if (checkResult == CompareFilterTimeRangeChecker.CheckResult.INCLUDED) {
                    return ConstantTupleFilter.TRUE;
                }
                if (checkResult == CompareFilterTimeRangeChecker.CheckResult.EXCLUDED) {
                    return ConstantTupleFilter.FALSE;
                }
            }
            CompareTupleFilter newCompareFilter = new CompareTupleFilter(oldCompareFilter.getOperator());
            newCompareFilter.addChild(new ColumnTupleFilter(externalCol));
            Object firstValue = constValues.iterator().next();
            int col = this.mapCol(externalCol);
            switch (newCompareFilter.getOperator()) {
                case EQ: 
                case IN: {
                    HashSet<ByteArray> newValues = Sets.newHashSet();
                    for (Object value : constValues) {
                        ByteArray code = this.translate(col, value, 0);
                        if (code == null) continue;
                        newValues.add(code);
                    }
                    if (newValues.isEmpty()) {
                        result = ConstantTupleFilter.FALSE;
                        break;
                    }
                    newCompareFilter.addChild(new ConstantTupleFilter(newValues));
                    result = newCompareFilter;
                    break;
                }
                case NOTIN: {
                    HashSet<ByteArray> notInValues = Sets.newHashSet();
                    for (Object value : constValues) {
                        ByteArray code = this.translate(col, value, 0);
                        if (code == null) continue;
                        notInValues.add(code);
                    }
                    if (notInValues.isEmpty()) {
                        result = ConstantTupleFilter.TRUE;
                        break;
                    }
                    newCompareFilter.addChild(new ConstantTupleFilter(notInValues));
                    result = newCompareFilter;
                    break;
                }
                case NEQ: {
                    ByteArray code = this.translate(col, firstValue, 0);
                    if (code == null) {
                        result = ConstantTupleFilter.TRUE;
                        break;
                    }
                    newCompareFilter.addChild(new ConstantTupleFilter(code));
                    result = newCompareFilter;
                    break;
                }
                case LT: {
                    ByteArray code = this.translate(col, firstValue, 0);
                    if (code == null) {
                        code = this.translate(col, firstValue, -1);
                        if (code == null) {
                            result = ConstantTupleFilter.FALSE;
                            break;
                        }
                        result = this.newCompareFilter(TupleFilter.FilterOperatorEnum.LTE, externalCol, code);
                        break;
                    }
                    newCompareFilter.addChild(new ConstantTupleFilter(code));
                    result = newCompareFilter;
                    break;
                }
                case LTE: {
                    ByteArray code = this.translate(col, firstValue, -1);
                    if (code == null) {
                        result = ConstantTupleFilter.FALSE;
                        break;
                    }
                    newCompareFilter.addChild(new ConstantTupleFilter(code));
                    result = newCompareFilter;
                    break;
                }
                case GT: {
                    ByteArray code = this.translate(col, firstValue, 0);
                    if (code == null) {
                        code = this.translate(col, firstValue, 1);
                        if (code == null) {
                            result = ConstantTupleFilter.FALSE;
                            break;
                        }
                        result = this.newCompareFilter(TupleFilter.FilterOperatorEnum.GTE, externalCol, code);
                        break;
                    }
                    newCompareFilter.addChild(new ConstantTupleFilter(code));
                    result = newCompareFilter;
                    break;
                }
                case GTE: {
                    ByteArray code = this.translate(col, firstValue, 1);
                    if (code == null) {
                        result = ConstantTupleFilter.FALSE;
                        break;
                    }
                    newCompareFilter.addChild(new ConstantTupleFilter(code));
                    result = newCompareFilter;
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot handle operator " + (Object)((Object)newCompareFilter.getOperator()));
                }
            }
            return result;
        }

        private TupleFilter newCompareFilter(TupleFilter.FilterOperatorEnum op, TblColRef col, ByteArray code) {
            CompareTupleFilter r = new CompareTupleFilter(op);
            r.addChild(new ColumnTupleFilter(col));
            r.addChild(new ConstantTupleFilter(code));
            return r;
        }

        protected ByteArray translate(int col, Object value, int roundingFlag) {
            try {
                this.buf.clear();
                this.recordCodec.encodeDimension(col, value, roundingFlag, this.buf);
                int length = this.buf.position();
                return ByteArray.copyOf(this.buf.array(), 0, length);
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }

        public void setTimezoneOffset(long timezoneOffset) {
            this.timezoneOffset = timezoneOffset;
        }
    }
}

