/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.stddev;

import java.io.Serializable;
import java.nio.ByteBuffer;

public class StdDevCounter
implements Serializable {
    protected double variance;
    protected double sum;
    protected long count;

    public StdDevCounter(double variance, double sum, long count) {
        this.variance = variance;
        this.sum = sum;
        this.count = count;
    }

    public StdDevCounter() {
        this(0.0, 0.0, 0L);
    }

    public StdDevCounter(double elem) {
        this(0.0, elem, 1L);
    }

    public StdDevCounter(StdDevCounter another) {
        this(another.variance, another.sum, another.count);
    }

    public void add(double elem) {
        this.merge(new StdDevCounter(elem));
    }

    public void merge(StdDevCounter another) {
        if (another == null || another.count == 0L) {
            return;
        }
        if (this.count == 0L) {
            this.variance = another.variance;
            this.sum = another.sum;
            this.count = another.count;
            return;
        }
        double t = (double)another.count / (double)this.count * this.sum - another.sum;
        this.variance += another.variance + (double)this.count / (double)another.count / ((double)this.count + (double)another.count) * t * t;
        this.sum += another.sum;
        this.count += another.count;
    }

    public double getStandardDeviation() {
        if (this.count == 0L || this.count == 1L) {
            return 0.0;
        }
        return Math.sqrt(this.variance / (double)this.count);
    }

    public void writeRegisters(ByteBuffer out) {
        out.putDouble(this.variance);
        out.putDouble(this.sum);
        out.putLong(this.count);
    }

    public void readRegisters(ByteBuffer in) {
        this.variance = in.getDouble();
        this.sum = in.getDouble();
        this.count = in.getLong();
    }

    public int sizeOfBytes() {
        return 24;
    }
}

