/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.io.IOException;
import java.util.Collection;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.engine.mr.KylinReducer;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.steps.CubeHFileMapper;
import org.apache.kylin.storage.hbase.steps.HFileOutputFormat3;
import org.apache.kylin.storage.hbase.steps.RowKeyWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeHFileJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(CubeHFileJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        Options options = new Options();
        Connection connection = null;
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_PARTITION_FILE_PATH);
            options.addOption(OPTION_INPUT_PATH);
            options.addOption(OPTION_OUTPUT_PATH);
            options.addOption(OPTION_HTABLE_NAME);
            this.parseOptions(options, args);
            Path partitionFilePath = new Path(this.getOptionValue(OPTION_PARTITION_FILE_PATH));
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME);
            CubeManager cubeMgr = CubeManager.getInstance(KylinConfig.getInstanceFromEnv());
            CubeInstance cube = cubeMgr.getCube(cubeName);
            Configuration configuration = new Configuration(HBaseConnection.getCurrentHBaseConfiguration());
            String[] allServices = this.getAllServices(configuration);
            HBaseConfiguration.merge((Configuration)configuration, (Configuration)this.getConf());
            configuration.setStrings("dfs.nameservices", allServices);
            this.job = Job.getInstance((Configuration)configuration, (String)this.getOptionValue(OPTION_JOB_NAME));
            this.setJobClasspath(this.job, cube.getConfig());
            CubeHFileJob.addInputDirs((String)this.getOptionValue(OPTION_INPUT_PATH), (Job)this.job);
            FileOutputFormat.setOutputPath((Job)this.job, (Path)output);
            this.job.getConfiguration().set("cube.name", cubeName);
            this.attachCubeMetadata(cube, this.job.getConfiguration());
            Configuration hbaseConf = HBaseConfiguration.create((Configuration)this.getConf());
            String hTableName = this.getOptionValue(OPTION_HTABLE_NAME);
            connection = ConnectionFactory.createConnection((Configuration)hbaseConf);
            Table table = connection.getTable(TableName.valueOf((String)hTableName));
            RegionLocator regionLocator = connection.getRegionLocator(TableName.valueOf((String)hTableName));
            HFileOutputFormat3.configureIncrementalLoad(this.job, table, regionLocator);
            this.reconfigurePartitions(hbaseConf, partitionFilePath);
            this.job.setInputFormatClass(SequenceFileInputFormat.class);
            this.job.setMapperClass(CubeHFileMapper.class);
            this.job.setReducerClass(KeyValueReducer.class);
            this.job.setMapOutputKeyClass(RowKeyWritable.class);
            this.job.setMapOutputValueClass(KeyValue.class);
            this.job.setSortComparatorClass(RowKeyWritable.RowKeyComparator.class);
            configuration.set("dfs.replication", "3");
            this.deletePath(this.job.getConfiguration(), output);
            int n = this.waitForCompletion(this.job);
            return n;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
            if (null != connection) {
                connection.close();
            }
        }
    }

    private void reconfigurePartitions(Configuration conf, Path path) throws IOException {
        FileSystem fs = path.getFileSystem(conf);
        if (fs.exists(path)) {
            try (SequenceFile.Reader reader = new SequenceFile.Reader(fs, path, conf);){
                int partitionCount = 0;
                Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
                Writable value = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
                while (reader.next(key, value)) {
                    ++partitionCount;
                }
                TotalOrderPartitioner.setPartitionFile((Configuration)this.job.getConfiguration(), (Path)path);
                this.job.setNumReduceTasks(partitionCount + 1);
            }
        } else {
            logger.info("File '" + path.toString() + " doesn't exist, will not reconfigure hfile Partitions");
        }
    }

    private String[] getAllServices(Configuration hbaseConf) {
        Collection hbaseHdfsServices = hbaseConf.getTrimmedStringCollection("dfs.nameservices");
        Collection mainNameServices = this.getConf().getTrimmedStringCollection("dfs.nameservices");
        mainNameServices.addAll(hbaseHdfsServices);
        return mainNameServices.toArray(new String[0]);
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new CubeHFileJob(), (String[])args);
        System.exit(exitCode);
    }

    private static class KeyValueReducer
    extends KylinReducer<RowKeyWritable, KeyValue, ImmutableBytesWritable, KeyValue> {
        private ImmutableBytesWritable immutableBytesWritable = new ImmutableBytesWritable();

        private KeyValueReducer() {
        }

        public void doReduce(RowKeyWritable row, Iterable<KeyValue> kvs, Reducer.Context context) throws IOException, InterruptedException {
            for (KeyValue kv : kvs) {
                this.immutableBytesWritable.set(kv.getKey());
                context.write((Object)this.immutableBytesWritable, (Object)kv);
            }
        }
    }
}

