/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;

public abstract class ContentWriter {
    private boolean isBigContent = false;
    protected long bytesWritten = 0L;

    public static ContentWriter create(byte[] data) {
        return ContentWriter.create(new ByteArrayInputStream(data));
    }

    public static ContentWriter create(final InputStream is) {
        return new ContentWriter(){

            @Override
            void write(DataOutputStream out) throws IOException {
                int n = IOUtils.copy((InputStream)is, (OutputStream)out);
                this.bytesWritten += (long)(n < 0 ? Integer.MAX_VALUE : n);
            }
        };
    }

    public static <T extends RootPersistentEntity> ContentWriter create(final T obj, final Serializer<T> serializer) {
        return new ContentWriter(){

            @Override
            void write(DataOutputStream out) throws IOException {
                int pos = out.size();
                serializer.serialize(obj, out);
                this.bytesWritten += (long)(out.size() - pos);
            }
        };
    }

    abstract void write(DataOutputStream var1) throws IOException;

    public void markBigContent() {
        this.isBigContent = true;
    }

    public boolean isBigContent() {
        return this.isBigContent;
    }

    public long bytesWritten() {
        return this.bytesWritten;
    }

    /*
     * Exception decompiling
     */
    public byte[] extractAllBytes() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

