/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.kv;

import java.io.Serializable;
import java.util.Map;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.RowKeyColDesc;
import org.apache.kylin.dimension.DictionaryDimEnc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.DimensionEncodingFactory;
import org.apache.kylin.dimension.FixedLenDimEnc;
import org.apache.kylin.dimension.IDimensionEncodingMap;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeDimEncMap
implements IDimensionEncodingMap,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(CubeDimEncMap.class);
    private final CubeDesc cubeDesc;
    private final CubeSegment seg;
    private final Map<TblColRef, Dictionary<String>> dictionaryMap;
    private final Map<TblColRef, DimensionEncoding> encMap = Maps.newHashMap();

    public CubeDimEncMap(CubeSegment seg) {
        this.cubeDesc = seg.getCubeDesc();
        this.seg = seg;
        this.dictionaryMap = null;
    }

    public CubeDimEncMap(CubeDesc cubeDesc, Map<TblColRef, Dictionary<String>> dictionaryMap) {
        this.cubeDesc = cubeDesc;
        this.seg = null;
        this.dictionaryMap = dictionaryMap;
    }

    @Override
    public DimensionEncoding get(TblColRef col) {
        DimensionEncoding result = this.encMap.get(col);
        if (result == null) {
            RowKeyColDesc colDesc = this.cubeDesc.getRowkey().getColDesc(col);
            if (colDesc.isUsingDictionary()) {
                Dictionary<String> dict = this.getDictionary(col);
                if (dict == null) {
                    logger.warn("No dictionary found for dict-encoding column " + col + ", segment " + this.seg);
                    result = new FixedLenDimEnc(0);
                } else {
                    result = new DictionaryDimEnc(dict);
                }
            } else {
                result = DimensionEncodingFactory.create(colDesc.getEncodingName(), colDesc.getEncodingArgs(), colDesc.getEncodingVersion());
            }
            this.encMap.put(col, result);
        }
        return result;
    }

    @Override
    public Dictionary<String> getDictionary(TblColRef col) {
        if (this.seg == null) {
            return this.dictionaryMap.get(col);
        }
        return this.seg.getDictionary(col);
    }
}

