/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.flink;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.hadoop.mapreduce.HadoopOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.hadoopcompatibility.HadoopInputs;
import org.apache.flink.util.Collector;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.StringSplitter;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.flink.FlinkBatchCubingJobBuilder2;
import org.apache.kylin.engine.flink.FlinkBatchMergeJobBuilder2;
import org.apache.kylin.engine.flink.FlinkUtil;
import org.apache.kylin.engine.flink.util.PercentileCounterSerializer;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.SerializableConfiguration;
import org.apache.kylin.engine.mr.steps.SegmentReEncoder;
import org.apache.kylin.measure.BufferedMeasureCodec;
import org.apache.kylin.measure.MeasureAggregators;
import org.apache.kylin.measure.percentile.PercentileCounter;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkCubingMerge
extends AbstractApplication
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(FlinkCubingMerge.class);
    public static final Option OPTION_CUBE_NAME;
    public static final Option OPTION_SEGMENT_ID;
    public static final Option OPTION_META_URL;
    public static final Option OPTION_OUTPUT_PATH;
    public static final Option OPTION_INPUT_PATH;
    public static final Option OPTION_ENABLE_OBJECT_REUSE;
    private Options options = new Options();
    private String cubeName;
    private String metaUrl;

    public FlinkCubingMerge() {
        this.options.addOption(OPTION_META_URL);
        this.options.addOption(OPTION_CUBE_NAME);
        this.options.addOption(OPTION_SEGMENT_ID);
        this.options.addOption(OPTION_INPUT_PATH);
        this.options.addOption(OPTION_OUTPUT_PATH);
        this.options.addOption(OPTION_ENABLE_OBJECT_REUSE);
    }

    @Override
    protected Options getOptions() {
        return this.options;
    }

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
        CubeSegment sourceSegment;
        this.metaUrl = optionsHelper.getOptionValue(OPTION_META_URL);
        this.cubeName = optionsHelper.getOptionValue(OPTION_CUBE_NAME);
        String inputPath = optionsHelper.getOptionValue(OPTION_INPUT_PATH);
        String segmentId = optionsHelper.getOptionValue(OPTION_SEGMENT_ID);
        String outputPath = optionsHelper.getOptionValue(OPTION_OUTPUT_PATH);
        String enableObjectReuseOptValue = optionsHelper.getOptionValue(OPTION_ENABLE_OBJECT_REUSE);
        boolean enableObjectReuse = false;
        if (enableObjectReuseOptValue != null && !enableObjectReuseOptValue.isEmpty()) {
            enableObjectReuse = true;
        }
        Job job = Job.getInstance();
        FlinkUtil.modifyFlinkHadoopConfiguration(job);
        HadoopUtil.deletePath(job.getConfiguration(), new Path(outputPath));
        SerializableConfiguration sConf = new SerializableConfiguration(job.getConfiguration());
        KylinConfig envConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(sConf, this.metaUrl);
        CubeInstance cubeInstance = CubeManager.getInstance(envConfig).getCube(this.cubeName);
        CubeDesc cubeDesc = CubeDescManager.getInstance(envConfig).getCubeDesc(cubeInstance.getDescName());
        CubeSegment cubeSegment = cubeInstance.getSegmentById(segmentId);
        logger.info("Input path: {}", (Object)inputPath);
        logger.info("Output path: {}", (Object)outputPath);
        FlinkUtil.setHadoopConfForCuboid(job, cubeSegment, this.metaUrl);
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        if (enableObjectReuse) {
            env.getConfig().enableObjectReuse();
        }
        env.getConfig().registerKryoType(PercentileCounter.class);
        env.getConfig().registerTypeWithKryoSerializer(PercentileCounter.class, PercentileCounterSerializer.class);
        MeasureAggregators aggregators = new MeasureAggregators(cubeDesc.getMeasures());
        int totalLevels = cubeSegment.getCuboidScheduler().getBuildLevel();
        String[] inputFolders = StringSplitter.split(inputPath, ",");
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        boolean isLegacyMode = false;
        for (String inputFolder : inputFolders) {
            Path baseCuboidPath = new Path(FlinkBatchMergeJobBuilder2.getCuboidOutputPathsByLevel(inputFolder, 0));
            if (fs.exists(baseCuboidPath)) continue;
            isLegacyMode = true;
            break;
        }
        if (isLegacyMode) {
            ArrayList<MapOperator> mergingSegs = Lists.newArrayListWithExpectedSize(inputFolders.length);
            for (int i = 0; i < inputFolders.length; ++i) {
                String path = inputFolders[i];
                DataSet segRdd = FlinkUtil.parseInputPath(path, fs, env, Text.class, Text.class);
                sourceSegment = this.findSourceSegment(path, cubeInstance);
                MapOperator newEcoddedRdd = segRdd.map((MapFunction)new ReEncodeCuboidFunction(this.cubeName, sourceSegment.getUuid(), cubeSegment.getUuid(), this.metaUrl, sConf));
                mergingSegs.add(newEcoddedRdd);
            }
            FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
            HadoopOutputFormat hadoopOF = new HadoopOutputFormat(new SequenceFileOutputFormat(), job);
            if (mergingSegs.size() > 0) {
                DataSet unionedDataSet = (DataSet)mergingSegs.get(0);
                for (int i = 1; i < mergingSegs.size(); ++i) {
                    unionedDataSet = unionedDataSet.union((DataSet)mergingSegs.get(i));
                }
                unionedDataSet.groupBy(new int[]{0}).reduceGroup((GroupReduceFunction)new MeasureReduceGroupFunction(aggregators)).map((MapFunction)new ConvertTextMapFunction(sConf, this.metaUrl, this.cubeName)).output(hadoopOF);
            }
        } else {
            for (int level = 0; level <= totalLevels; ++level) {
                ArrayList<MapOperator> mergingSegs = Lists.newArrayList();
                for (int i = 0; i < inputFolders.length; ++i) {
                    String path = inputFolders[i];
                    sourceSegment = this.findSourceSegment(path, cubeInstance);
                    String cuboidInputPath = FlinkBatchMergeJobBuilder2.getCuboidOutputPathsByLevel(path, level);
                    DataSource segRdd = env.createInput(HadoopInputs.readHadoopFile(new SequenceFileInputFormat(), Text.class, Text.class, cuboidInputPath));
                    MapOperator newEcoddedRdd = segRdd.map((MapFunction)new ReEncodeCuboidFunction(this.cubeName, sourceSegment.getUuid(), cubeSegment.getUuid(), this.metaUrl, sConf));
                    mergingSegs.add(newEcoddedRdd);
                }
                String cuboidOutputPath = FlinkBatchMergeJobBuilder2.getCuboidOutputPathsByLevel(outputPath, level);
                Job jobInstanceForEachOutputFormat = Job.getInstance();
                FlinkUtil.modifyFlinkHadoopConfiguration(jobInstanceForEachOutputFormat);
                FlinkUtil.setHadoopConfForCuboid(jobInstanceForEachOutputFormat, cubeSegment, this.metaUrl);
                FileOutputFormat.setOutputPath((Job)jobInstanceForEachOutputFormat, (Path)new Path(cuboidOutputPath));
                HadoopOutputFormat hadoopOF = new HadoopOutputFormat(new SequenceFileOutputFormat(), jobInstanceForEachOutputFormat);
                if (mergingSegs.size() <= 0) continue;
                DataSet unionedDataSet = (DataSet)mergingSegs.get(0);
                for (int i = 1; i < mergingSegs.size(); ++i) {
                    unionedDataSet = unionedDataSet.union((DataSet)mergingSegs.get(i));
                }
                unionedDataSet.groupBy(new int[]{0}).reduceGroup((GroupReduceFunction)new MeasureReduceGroupFunction(aggregators)).map((MapFunction)new ConvertTextMapFunction(sConf, this.metaUrl, this.cubeName)).output(hadoopOF);
            }
        }
        env.execute("Merge segments for cube:" + this.cubeName + ", segment " + segmentId);
        logger.info("HDFS: Number of bytes written=" + FlinkBatchCubingJobBuilder2.getFileSize(outputPath, fs));
    }

    private CubeSegment findSourceSegment(String filePath, CubeInstance cube) {
        String jobID = JobBuilderSupport.extractJobIDFromPath(filePath);
        return CubeInstance.findSegmentWithJobId(jobID, cube);
    }

    static {
        OptionBuilder.withArgName((String)"cubename");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube Name");
        OPTION_CUBE_NAME = OptionBuilder.create((String)"cubename");
        OptionBuilder.withArgName((String)"segment");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube Segment Id");
        OPTION_SEGMENT_ID = OptionBuilder.create((String)"segmentId");
        OptionBuilder.withArgName((String)"metaUrl");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"HDFS metadata url");
        OPTION_META_URL = OptionBuilder.create((String)"metaUrl");
        OptionBuilder.withArgName((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"HFile output path");
        OPTION_OUTPUT_PATH = OptionBuilder.create((String)"output");
        OptionBuilder.withArgName((String)"input");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cuboid files PATH");
        OPTION_INPUT_PATH = OptionBuilder.create((String)"input");
        OptionBuilder.withArgName((String)"enableObjectReuse");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Enable object reuse");
        OPTION_ENABLE_OBJECT_REUSE = OptionBuilder.create((String)"enableObjectReuse");
    }

    private static class ConvertTextMapFunction
    extends RichMapFunction<Tuple2<ByteArray, Object[]>, Tuple2<Text, Text>> {
        private BufferedMeasureCodec codec;
        private SerializableConfiguration sConf;
        private String metaUrl;
        private String cubeName;

        public ConvertTextMapFunction(SerializableConfiguration sConf, String metaUrl, String cubeName) {
            this.sConf = sConf;
            this.metaUrl = metaUrl;
            this.cubeName = cubeName;
        }

        public void open(Configuration parameters) throws Exception {
            KylinConfig kylinConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(this.sConf, this.metaUrl);
            try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(kylinConfig);){
                CubeDesc desc = CubeDescManager.getInstance(kylinConfig).getCubeDesc(this.cubeName);
                this.codec = new BufferedMeasureCodec(desc.getMeasures());
            }
        }

        public Tuple2<Text, Text> map(Tuple2<ByteArray, Object[]> tuple2) throws Exception {
            ByteBuffer valueBuf = this.codec.encode((Object[])tuple2.f1);
            Text result = new Text();
            result.set(valueBuf.array(), 0, valueBuf.position());
            return new Tuple2((Object)new Text(((ByteArray)tuple2.f0).array()), (Object)result);
        }
    }

    private static class MeasureReduceGroupFunction
    extends RichGroupReduceFunction<Tuple2<ByteArray, Object[]>, Tuple2<ByteArray, Object[]>> {
        private MeasureAggregators aggregators;

        public MeasureReduceGroupFunction(MeasureAggregators aggregators) {
            this.aggregators = aggregators;
        }

        public void reduce(Iterable<Tuple2<ByteArray, Object[]>> values, Collector<Tuple2<ByteArray, Object[]>> out) throws Exception {
            Object[] result = null;
            ByteArray key = null;
            for (Tuple2<ByteArray, Object[]> item : values) {
                key = (ByteArray)item.f0;
                if (result == null) {
                    result = (Object[])item.f1;
                    continue;
                }
                Object[] temp = new Object[result.length];
                this.aggregators.aggregate((Object[])item.f1, result, temp);
                result = temp;
            }
            out.collect((Object)new Tuple2(key, result));
        }
    }

    private static class MeasureReduceFunction
    implements ReduceFunction<Tuple2<ByteArray, Object[]>> {
        private MeasureAggregators aggregators;

        public MeasureReduceFunction(MeasureAggregators aggregators) {
            this.aggregators = aggregators;
        }

        public Tuple2<ByteArray, Object[]> reduce(Tuple2<ByteArray, Object[]> input1, Tuple2<ByteArray, Object[]> input2) throws Exception {
            Object[] measureObjs = new Object[((Object[])input1.f1).length];
            this.aggregators.aggregate((Object[])input1.f1, (Object[])input2.f1, measureObjs);
            return new Tuple2(input1.f0, (Object)measureObjs);
        }
    }

    private static class ReEncodeCuboidFunction
    extends RichMapFunction<Tuple2<Text, Text>, Tuple2<ByteArray, Object[]>> {
        private String cubeName;
        private String sourceSegmentId;
        private String mergedSegmentId;
        private String metaUrl;
        private SerializableConfiguration conf;
        private transient KylinConfig kylinConfig;
        private transient SegmentReEncoder segmentReEncoder = null;

        ReEncodeCuboidFunction(String cubeName, String sourceSegmentId, String mergedSegmentId, String metaUrl, SerializableConfiguration conf) {
            this.cubeName = cubeName;
            this.sourceSegmentId = sourceSegmentId;
            this.mergedSegmentId = mergedSegmentId;
            this.metaUrl = metaUrl;
            this.conf = conf;
        }

        public void open(Configuration parameters) throws Exception {
            this.kylinConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(this.conf, this.metaUrl);
            CubeInstance cube = CubeManager.getInstance(this.kylinConfig).getCube(this.cubeName);
            CubeDesc cubeDesc = CubeDescManager.getInstance(this.kylinConfig).getCubeDesc(cube.getDescName());
            CubeSegment sourceSeg = cube.getSegmentById(this.sourceSegmentId);
            CubeSegment mergedSeg = cube.getSegmentById(this.mergedSegmentId);
            this.segmentReEncoder = new SegmentReEncoder(cubeDesc, sourceSeg, mergedSeg, this.kylinConfig);
        }

        public Tuple2<ByteArray, Object[]> map(Tuple2<Text, Text> textTextTuple2) throws Exception {
            Pair<Text, Object[]> encodedPair = this.segmentReEncoder.reEncode2((Text)textTextTuple2.f0, (Text)textTextTuple2.f1);
            return new Tuple2((Object)new ByteArray(encodedPair.getFirst().getBytes()), (Object)encodedPair.getSecond());
        }
    }
}

