/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.util.Locale;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.steps.CuboidJob;
import org.apache.kylin.engine.mr.steps.CuboidReducer;
import org.apache.kylin.engine.mr.steps.MergeCuboidMapper;
import org.apache.kylin.metadata.model.Segments;

public class MergeCuboidJob
extends CuboidJob {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_SEGMENT_ID);
            options.addOption(OPTION_INPUT_PATH);
            options.addOption(OPTION_OUTPUT_PATH);
            this.parseOptions(options, args);
            String input = this.getOptionValue(OPTION_INPUT_PATH);
            String output = this.getOptionValue(OPTION_OUTPUT_PATH);
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME).toUpperCase(Locale.ROOT);
            String segmentID = this.getOptionValue(OPTION_SEGMENT_ID);
            CubeManager cubeMgr = CubeManager.getInstance(KylinConfig.getInstanceFromEnv());
            CubeInstance cube = cubeMgr.getCube(cubeName);
            CubeSegment cubeSeg = cube.getSegmentById(segmentID);
            String jobName = this.getOptionValue(OPTION_JOB_NAME);
            logger.info("Starting: " + jobName);
            this.job = Job.getInstance((Configuration)this.getConf(), (String)jobName);
            this.setJobClasspath(this.job, cube.getConfig());
            Segments<CubeSegment> allSegs = cube.getMergingSegments(cubeSeg);
            allSegs.add(cubeSeg);
            this.attachSegmentsMetadataWithDict(allSegs, this.job.getConfiguration());
            this.job.setMapperClass(MergeCuboidMapper.class);
            this.job.setMapOutputKeyClass(Text.class);
            this.job.setMapOutputValueClass(Text.class);
            this.job.setReducerClass(CuboidReducer.class);
            this.job.setOutputKeyClass(Text.class);
            this.job.setOutputValueClass(Text.class);
            this.job.getConfiguration().set("dfs.replication", KylinConfig.getInstanceFromEnv().getCuboidDfsReplication());
            IMROutput2.IMRMergeOutputFormat outputFormat = MRUtil.getBatchMergeOutputSide2(cubeSeg).getOutputFormat();
            outputFormat.configureJobInput(this.job, input);
            MergeCuboidJob.addInputDirs(input, this.job);
            outputFormat.configureJobOutput(this.job, output, cubeSeg);
            this.job.getConfiguration().set("cube.name", cubeName);
            this.job.getConfiguration().set("cube.segment.id", segmentID);
            int n = this.waitForCompletion(this.job);
            return n;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }
}

