/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Shell;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.apache.kylin.cube.model.CubeDescTiretreeGlobalDomainDictUtil;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.JobRelatedMetaUtil;
import org.apache.kylin.engine.spark.SparkBuildDictionary;
import org.apache.kylin.engine.spark.exception.SparkException;
import org.apache.kylin.job.common.PatternedLogger;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.job.impl.threadpool.IJobRunner;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkExecutable
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(SparkExecutable.class);
    private static final String CLASS_NAME = "className";
    private static final String JARS = "jars";
    private static final String JOB_ID = "jobId";
    private static final String COUNTER_SAVE_AS = "CounterSaveAs";
    private static final String CONFIG_NAME = "configName";
    private static final String EXECUTOR_JVM_ARG = "spark.executor.extraJavaOptions";

    public void setClassName(String className) {
        this.setParam(CLASS_NAME, className);
    }

    public void setJobId(String jobId) {
        this.setParam(JOB_ID, jobId);
    }

    public void setJars(String jars) {
        this.setParam(JARS, jars);
    }

    public void setCounterSaveAs(String value) {
        this.setParam(COUNTER_SAVE_AS, value);
    }

    public void setCounterSaveAs(String value, String counterOutputPath) {
        this.setParam(COUNTER_SAVE_AS, value);
        this.setParam("counterOutput", counterOutputPath);
    }

    public String getCounterSaveAs() {
        return this.getParam(COUNTER_SAVE_AS);
    }

    public void setSparkConfigName(String configName) {
        this.setParam(CONFIG_NAME, configName);
    }

    public String getSparkConfigName() {
        return this.getParam(CONFIG_NAME);
    }

    private String formatArgs() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.getParams().entrySet()) {
            StringBuilder tmp = new StringBuilder();
            tmp.append("-").append(entry.getKey()).append(" ").append(entry.getValue()).append(" ");
            if (entry.getKey().equals(CLASS_NAME)) {
                stringBuilder.insert(0, tmp);
                continue;
            }
            if (entry.getKey().equals(JARS) || entry.getKey().equals(JOB_ID) || entry.getKey().equals(COUNTER_SAVE_AS) || entry.getKey().equals(CONFIG_NAME)) continue;
            stringBuilder.append((CharSequence)tmp);
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 1).toString();
        }
        return "";
    }

    @Override
    protected void onExecuteStart(ExecutableContext executableContext) {
        block6: {
            Output output = this.getOutput();
            if (output.getExtra().containsKey("startTime")) {
                String sparkJobID = output.getExtra().get("spark_job_id");
                if (StringUtils.isEmpty((String)sparkJobID)) {
                    this.getManager().updateJobOutput(this.getId(), ExecutableState.RUNNING, null, null);
                    return;
                }
                try {
                    String status = this.getAppState(sparkJobID);
                    if (status == null || status.equals("FAILED") || status.equals("KILLED")) {
                        super.onExecuteStart(executableContext);
                        break block6;
                    }
                    this.getManager().updateJobOutput(this.getId(), ExecutableState.RUNNING, null, null);
                }
                catch (IOException e) {
                    logger.warn("error get hadoop status");
                    super.onExecuteStart(executableContext);
                }
            } else {
                super.onExecuteStart(executableContext);
            }
        }
    }

    protected ExecuteResult onResumed(String appId, ExecutableManager mgr) throws ExecuteException {
        HashMap<String, String> info = new HashMap<String, String>();
        try {
            logger.info("spark_job_id:" + appId + " resumed");
            info.put("spark_job_id", appId);
            while (!this.isPaused() && !this.isDiscarded()) {
                String status = this.getAppState(appId);
                if (status.equals("FAILED") || status.equals("KILLED")) {
                    mgr.updateJobOutput(this.getId(), ExecutableState.ERROR, null, appId + " has failed");
                    return new ExecuteResult(ExecuteResult.State.FAILED, appId + " has failed");
                }
                if (status.equals("SUCCEEDED")) {
                    mgr.addJobInfo(this.getId(), info);
                    return new ExecuteResult(ExecuteResult.State.SUCCEED, appId + " has finished");
                }
                Thread.sleep(5000L);
            }
            this.killAppRetry(appId);
            if (this.isDiscarded()) {
                return new ExecuteResult(ExecuteResult.State.DISCARDED, appId + " is discarded");
            }
            return new ExecuteResult(ExecuteResult.State.STOPPED, appId + " is stopped");
        }
        catch (Exception e) {
            logger.error("error run spark job:", e);
            return new ExecuteResult(ExecuteResult.State.ERROR, e.getLocalizedMessage());
        }
    }

    @Override
    protected ExecuteResult doWork(ExecutableContext context, IJobRunner jobRunner) throws ExecuteException {
        KylinConfig config;
        ExecutableManager mgr = this.getManager();
        Map<String, String> extra = mgr.getOutput(this.getId()).getExtra();
        String sparkJobId = extra.get("spark_job_id");
        if (!StringUtils.isEmpty((String)sparkJobId)) {
            return this.onResumed(sparkJobId, mgr);
        }
        String cubeName = this.getParam("cubename");
        CubeInstance cube = cubeName != null ? CubeManager.getInstance(context.getConfig()).getCube(cubeName) : null;
        if (cube != null) {
            config = cube.getConfig();
        } else {
            String projectName = this.getParam("project");
            ProjectInstance projectInst = ProjectManager.getInstance(context.getConfig()).getProject(projectName);
            config = projectInst.getConfig();
        }
        if (KylinConfig.getSparkHome() == null) {
            throw new NullPointerException();
        }
        if (config.getKylinJobJarPath() == null) {
            throw new NullPointerException();
        }
        String jars = this.getParam(JARS);
        String hadoopConf = null;
        hadoopConf = System.getProperty("kylin.hadoop.conf.dir");
        if (StringUtils.isEmpty((String)hadoopConf)) {
            throw new RuntimeException("kylin_hadoop_conf_dir is empty, check if there's error in the output of 'kylin.sh start'");
        }
        logger.info("Using " + hadoopConf + " as HADOOP_CONF_DIR");
        String jobJar = config.getKylinJobJarPath();
        if (StringUtils.isEmpty((String)jars)) {
            jars = jobJar;
        }
        if (cube != null && !this.isCreateFlatTable()) {
            this.setAlgorithmLayer();
            String segmentID = this.getParam("segmentId");
            CubeSegment segment = cube.getSegmentById(segmentID);
            Segments<CubeSegment> mergingSeg = cube.getMergingSegments(segment);
            this.dumpMetadata(segment, mergingSeg);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (Shell.osType == Shell.OSType.OS_TYPE_WIN) {
            stringBuilder.append("set HADOOP_CONF_DIR=%s && %s/bin/spark-submit --class org.apache.kylin.common.util.SparkEntry ");
        } else {
            stringBuilder.append("export HADOOP_CONF_DIR=%s && %s/bin/spark-submit --class org.apache.kylin.common.util.SparkEntry ");
        }
        if (this.getName() != null) {
            stringBuilder.append("--name \"" + this.getName() + "\"");
        }
        Map<String, String> sparkConfs = config.getSparkConfigOverride();
        String sparkConfigName = this.getSparkConfigName();
        if (sparkConfigName != null) {
            Map<String, String> sparkSpecificConfs = config.getSparkConfigOverrideWithSpecificName(sparkConfigName);
            sparkConfs.putAll(sparkSpecificConfs);
        }
        if (StringUtils.isNotEmpty((String)config.getHBaseClusterFs())) {
            String fileSystems = sparkConfs.get("spark.yarn.access.hadoopFileSystems");
            if (StringUtils.isNotEmpty((String)fileSystems)) {
                sparkConfs.put("spark.yarn.access.hadoopFileSystems", (String)fileSystems + "," + config.getHBaseClusterFs());
            } else {
                sparkConfs.put("spark.yarn.access.hadoopFileSystems", config.getHBaseClusterFs());
            }
        }
        for (Map.Entry entry : sparkConfs.entrySet()) {
            if (((String)entry.getKey()).equals(EXECUTOR_JVM_ARG)) {
                stringBuilder.append(" --conf ").append("\"").append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("\"").append(" ");
                logger.info("use spark.executor.extraJavaOptions: " + stringBuilder.toString());
                continue;
            }
            stringBuilder.append(" --conf ").append((String)entry.getKey()).append("=").append((String)entry.getValue()).append(" ");
        }
        stringBuilder.append("--jars %s %s %s");
        final String cmd = String.format(Locale.ROOT, stringBuilder.toString(), hadoopConf, KylinConfig.getSparkHome(), jars, jobJar, this.formatArgs());
        logger.info("cmd: " + cmd);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final CliCommandExecutor exec = new CliCommandExecutor();
        final PatternedLogger patternedLogger = new PatternedLogger(logger, 4, new PatternedLogger.ILogListener(){

            @Override
            public void onLogEvent(String infoKey, Map<String, String> info) {
                if ("spark_job_id".equals(infoKey) || "yarn_application_id".equals(infoKey) || "yarn_application_tracking_url".equals(infoKey)) {
                    SparkExecutable.this.getManager().addJobInfo(SparkExecutable.this.getId(), info);
                }
            }
        });
        Callable<Pair<Integer, String>> callable = new Callable<Pair<Integer, String>>(){

            @Override
            public Pair<Integer, String> call() throws Exception {
                Pair<Integer, String> result;
                try {
                    result = exec.execute(cmd, patternedLogger);
                }
                catch (Exception e) {
                    logger.error("error run spark job:", e);
                    result = new Pair<Integer, String>(-1, e.getMessage());
                }
                return result;
            }
        };
        try {
            String resultLog;
            Future<Pair<Integer, String>> future = executorService.submit(callable);
            Pair<Integer, String> result = null;
            while (!this.isDiscarded() && !this.isPaused()) {
                if (future.isDone()) {
                    result = future.get();
                    break;
                }
                Thread.sleep(5000L);
            }
            if (!future.isDone()) {
                String newJobId;
                executorService.shutdownNow();
                extra = mgr.getOutput(this.getId()).getExtra();
                if (extra != null && StringUtils.isNotEmpty((String)(newJobId = extra.get("spark_job_id")))) {
                    this.killAppRetry(newJobId);
                }
                if (this.isDiscarded()) {
                    return new ExecuteResult(ExecuteResult.State.DISCARDED, "Discarded");
                }
                if (this.isPaused()) {
                    return new ExecuteResult(ExecuteResult.State.STOPPED, "Stopped");
                }
                throw new IllegalStateException();
            }
            if (result == null) {
                result = future.get();
            }
            if (result != null && result.getFirst() == 0) {
                Map<String, String> joblogInfo = patternedLogger.getInfo();
                String counterOutput = this.getParam("counterOutput");
                if (counterOutput != null) {
                    if (HadoopUtil.getWorkingFileSystem().exists(new Path(counterOutput))) {
                        Map<String, String> counterMap = HadoopUtil.readFromSequenceFile(counterOutput);
                        joblogInfo.putAll(counterMap);
                    } else {
                        logger.warn("Spark counter output path not exists: " + counterOutput);
                    }
                }
                this.readCounters(joblogInfo);
                this.getManager().addJobInfo(this.getId(), joblogInfo);
                if (joblogInfo.containsKey("spark_dimension_dic_segment_id")) {
                    this.updateSparkDimensionDicMetadata(config, cube, joblogInfo.get("spark_dimension_dic_segment_id"));
                    logger.info("Finished update dictionaries and snapshot info from {} to {}.", (Object)this.getParam(SparkBuildDictionary.OPTION_META_URL.getOpt()), (Object)config.getMetadataUrl());
                }
                return new ExecuteResult(ExecuteResult.State.SUCCEED, patternedLogger.getBufferedLog());
            }
            extra = mgr.getOutput(this.getId()).getExtra();
            extra.put("spark_job_id", "");
            this.getManager().addJobInfo(this.getId(), extra);
            String string = resultLog = result != null ? result.getSecond() : "";
            if (resultLog.length() > config.getSparkOutputMaxSize()) {
                resultLog = resultLog.substring(0, config.getSparkOutputMaxSize());
            }
            return ExecuteResult.createFailed(new SparkException(resultLog));
        }
        catch (Exception e) {
            logger.error("Error run spark job:", e);
            return ExecuteResult.createError(e);
        }
    }

    protected void dumpMetadata(CubeSegment segment, List<CubeSegment> mergingSeg) throws ExecuteException {
        try {
            if (mergingSeg == null || mergingSeg.size() == 0) {
                this.attachSegmentMetadataWithDict(segment);
            } else {
                ArrayList<CubeSegment> allRelatedSegs = new ArrayList<CubeSegment>();
                allRelatedSegs.add(segment);
                allRelatedSegs.addAll(mergingSeg);
                this.attachSegmentsMetadataWithDict(allRelatedSegs);
            }
        }
        catch (IOException e) {
            throw new ExecuteException("meta dump failed");
        }
    }

    private void updateSparkDimensionDicMetadata(KylinConfig config, CubeInstance cube, String segmentId) throws IOException {
        KylinConfig hdfsConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(this.getParam(SparkBuildDictionary.OPTION_META_URL.getOpt()));
        CubeInstance cubeInstance = CubeManager.getInstance(hdfsConfig).reloadCube(cube.getName());
        CubeSegment segment = cubeInstance.getSegmentById(segmentId);
        CubeSegment oldSeg = cube.getSegmentById(segmentId);
        oldSeg.setDictionaries((ConcurrentHashMap)segment.getDictionaries());
        oldSeg.setSnapshots((ConcurrentHashMap)segment.getSnapshots());
        oldSeg.getRowkeyStats().addAll(segment.getRowkeyStats());
        CubeInstance cubeCopy = cube.latestCopyForWrite();
        CubeUpdate update = new CubeUpdate(cubeCopy);
        update.setToUpdateSegs(oldSeg);
        CubeManager.getInstance(config).updateCube(update);
        LinkedHashSet<String> dumpList = new LinkedHashSet<String>();
        dumpList.addAll(segment.getDictionaryPaths());
        dumpList.addAll(segment.getSnapshotPaths());
        JobRelatedMetaUtil.dumpAndUploadKylinPropsAndMetadata(dumpList, (KylinConfigExt)segment.getConfig(), config.getMetadataUrl().toString());
    }

    protected void setAlgorithmLayer() {
        ExecutableManager execMgr = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv());
        CubingJob cubingJob = (CubingJob)execMgr.getJob(this.getParam(JOB_ID));
        cubingJob.setAlgorithm(CubingJob.AlgorithmEnum.LAYER);
    }

    protected String getAppState(String appId) throws IOException {
        if (StringUtils.isEmpty((String)appId)) {
            throw new IOException("The app is is null or empty");
        }
        CliCommandExecutor executor = KylinConfig.getInstanceFromEnv().getCliCommandExecutor();
        PatternedLogger patternedLogger = new PatternedLogger(logger);
        String stateCmd = String.format(Locale.ROOT, "yarn application -status %s", appId);
        executor.execute(stateCmd, patternedLogger);
        Map<String, String> info = patternedLogger.getInfo();
        return info.get("yarn_application_state");
    }

    protected void killApp(String appId) throws IOException, InterruptedException {
        CliCommandExecutor executor = KylinConfig.getInstanceFromEnv().getCliCommandExecutor();
        String killCmd = String.format(Locale.ROOT, "yarn application -kill %s", appId);
        executor.execute(killCmd);
    }

    protected int killAppRetry(String appId) throws IOException, InterruptedException {
        if (StringUtils.isEmpty((String)appId)) {
            logger.warn("The app is is null or empty");
            return 0;
        }
        String state = this.getAppState(appId);
        if ("SUCCEEDED".equals(state) || "FAILED".equals(state) || "KILLED".equals(state)) {
            logger.warn(appId + "is final state, no need to kill");
            return 0;
        }
        this.killApp(appId);
        state = this.getAppState(appId);
        for (int retry = 0; state == null || !state.equals("KILLED") && retry < 5; ++retry) {
            this.killApp(appId);
            Thread.sleep(1000L);
            state = this.getAppState(appId);
        }
        if ("KILLED".equals(state)) {
            logger.info(appId + " killed successfully");
            return 0;
        }
        logger.info(appId + " killed failed");
        return 1;
    }

    private void attachSegmentMetadataWithDict(CubeSegment segment) throws IOException {
        LinkedHashSet<String> dumpList = new LinkedHashSet<String>();
        dumpList.addAll(JobRelatedMetaUtil.collectCubeMetadata(segment.getCubeInstance()));
        dumpList.addAll(segment.getDictionaryPaths());
        ResourceStore rs = ResourceStore.getStore(segment.getConfig());
        if (rs.exists(segment.getStatisticsResourcePath())) {
            dumpList.add(segment.getStatisticsResourcePath());
        }
        CubeDescTiretreeGlobalDomainDictUtil.cuboidJob(segment.getCubeDesc(), dumpList);
        JobRelatedMetaUtil.dumpAndUploadKylinPropsAndMetadata(dumpList, (KylinConfigExt)segment.getConfig(), this.getParam("metaUrl"));
    }

    private void attachSegmentsMetadataWithDict(List<CubeSegment> segments) throws IOException {
        LinkedHashSet<String> dumpList = new LinkedHashSet<String>(JobRelatedMetaUtil.collectCubeMetadata(segments.get(0).getCubeInstance()));
        ResourceStore rs = ResourceStore.getStore(segments.get(0).getConfig());
        for (CubeSegment segment : segments) {
            dumpList.addAll(segment.getDictionaryPaths());
            if (rs.exists(segment.getStatisticsResourcePath())) {
                dumpList.add(segment.getStatisticsResourcePath());
            }
            CubeDescTiretreeGlobalDomainDictUtil.cuboidJob(segment.getCubeDesc(), dumpList);
        }
        JobRelatedMetaUtil.dumpAndUploadKylinPropsAndMetadata(dumpList, (KylinConfigExt)segments.get(0).getConfig(), this.getParam("metaUrl"));
    }

    protected void readCounters(Map<String, String> info) {
        String counter_save_as = this.getCounterSaveAs();
        if (counter_save_as != null) {
            String[] saveAsNames = counter_save_as.split(",");
            this.saveCounterAs(info.get("source_records_count"), saveAsNames, 0, info);
            this.saveCounterAs(info.get("source_records_size"), saveAsNames, 1, info);
            this.saveCounterAs(info.get("hdfs_bytes_written"), saveAsNames, 2, info);
        }
    }

    private void saveCounterAs(String counter, String[] saveAsNames, int i, Map<String, String> info) {
        if (saveAsNames.length > i && !StringUtils.isBlank((String)saveAsNames[i])) {
            info.put(saveAsNames[i].trim(), counter);
        }
    }

    private boolean isCreateFlatTable() {
        return "Create Intermediate Flat Table With Spark".equals(this.getName());
    }
}

