/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.shaded.com.codahale.metrics.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.kylin.job.shaded.com.codahale.metrics.Gauge;
import org.apache.kylin.job.shaded.com.codahale.metrics.Metric;
import org.apache.kylin.job.shaded.com.codahale.metrics.MetricRegistry;
import org.apache.kylin.job.shaded.com.codahale.metrics.MetricSet;
import org.apache.kylin.job.shaded.com.codahale.metrics.RatioGauge;

public class MemoryUsageGaugeSet
implements MetricSet {
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private final MemoryMXBean mxBean;
    private final List<MemoryPoolMXBean> memoryPools;

    public MemoryUsageGaugeSet() {
        this(ManagementFactory.getMemoryMXBean(), ManagementFactory.getMemoryPoolMXBeans());
    }

    public MemoryUsageGaugeSet(MemoryMXBean mxBean, Collection<MemoryPoolMXBean> memoryPools) {
        this.mxBean = mxBean;
        this.memoryPools = new ArrayList<MemoryPoolMXBean>(memoryPools);
    }

    @Override
    public Map<String, Metric> getMetrics() {
        HashMap<String, Gauge<Long>> gauges = new HashMap<String, Gauge<Long>>();
        gauges.put("total.init", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getInit() + MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getInit();
            }
        });
        gauges.put("total.used", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getUsed() + MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getUsed();
            }
        });
        gauges.put("total.max", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getMax() + MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getMax();
            }
        });
        gauges.put("total.committed", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getCommitted() + MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getCommitted();
            }
        });
        gauges.put("heap.init", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getInit();
            }
        });
        gauges.put("heap.used", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getUsed();
            }
        });
        gauges.put("heap.max", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getMax();
            }
        });
        gauges.put("heap.committed", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getCommitted();
            }
        });
        gauges.put("heap.usage", new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                MemoryUsage usage = MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage();
                return RatioGauge.Ratio.of(usage.getUsed(), usage.getMax());
            }
        });
        gauges.put("non-heap.init", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getInit();
            }
        });
        gauges.put("non-heap.used", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getUsed();
            }
        });
        gauges.put("non-heap.max", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getMax();
            }
        });
        gauges.put("non-heap.committed", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getCommitted();
            }
        });
        gauges.put("non-heap.usage", new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                MemoryUsage usage = MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage();
                return RatioGauge.Ratio.of(usage.getUsed(), usage.getMax());
            }
        });
        for (final MemoryPoolMXBean pool : this.memoryPools) {
            String poolName = MetricRegistry.name("pools", WHITESPACE.matcher(pool.getName()).replaceAll("-"));
            gauges.put(MetricRegistry.name(poolName, "usage"), new RatioGauge(){

                @Override
                protected RatioGauge.Ratio getRatio() {
                    MemoryUsage usage = pool.getUsage();
                    return RatioGauge.Ratio.of(usage.getUsed(), usage.getMax() == -1L ? (double)usage.getCommitted() : (double)usage.getMax());
                }
            });
            gauges.put(MetricRegistry.name(poolName, "max"), new Gauge<Long>(){

                @Override
                public Long getValue() {
                    return pool.getUsage().getMax();
                }
            });
            gauges.put(MetricRegistry.name(poolName, "used"), new Gauge<Long>(){

                @Override
                public Long getValue() {
                    return pool.getUsage().getUsed();
                }
            });
            gauges.put(MetricRegistry.name(poolName, "committed"), new Gauge<Long>(){

                @Override
                public Long getValue() {
                    return pool.getUsage().getCommitted();
                }
            });
            gauges.put(MetricRegistry.name(poolName, "init"), new Gauge<Long>(){

                @Override
                public Long getValue() {
                    return pool.getUsage().getInit();
                }
            });
        }
        return Collections.unmodifiableMap(gauges);
    }
}

