/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode.visitor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlCastFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.calcite.util.NlsString;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.expression.BinaryTupleExpression;
import org.apache.kylin.metadata.expression.CaseTupleExpression;
import org.apache.kylin.metadata.expression.ColumnTupleExpression;
import org.apache.kylin.metadata.expression.ConstantTupleExpression;
import org.apache.kylin.metadata.expression.RexCallTupleExpression;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.FilterOptimizeTransformer;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.visitor.TupleFilterVisitor;
import org.apache.kylin.query.schema.OLAPTable;
import org.apache.kylin.query.util.RexUtil;

public class TupleExpressionVisitor
extends RexVisitorImpl<TupleExpression> {
    private final ColumnRowType inputRowType;
    private final boolean ifVerify;

    public TupleExpressionVisitor(ColumnRowType inputRowType, boolean ifVerify) {
        super(true);
        this.inputRowType = inputRowType;
        this.ifVerify = ifVerify;
    }

    @Override
    public TupleExpression visitCall(RexCall call) {
        TupleExpression tupleExpression;
        SqlOperator op = call.getOperator();
        if (op instanceof SqlCastFunction) {
            return call.getOperands().get(0).accept(this);
        }
        if (op instanceof SqlUserDefinedFunction && op.getName().equals("QUARTER")) {
            return this.visitFirstRexInputRef(call);
        }
        switch (op.getKind()) {
            case PLUS: {
                tupleExpression = this.getBinaryTupleExpression(call, TupleExpression.ExpressionOperatorEnum.PLUS);
                break;
            }
            case MINUS: {
                tupleExpression = this.getBinaryTupleExpression(call, TupleExpression.ExpressionOperatorEnum.MINUS);
                break;
            }
            case TIMES: {
                tupleExpression = this.getBinaryTupleExpression(call, TupleExpression.ExpressionOperatorEnum.MULTIPLE);
                break;
            }
            case DIVIDE: {
                tupleExpression = this.getBinaryTupleExpression(call, TupleExpression.ExpressionOperatorEnum.DIVIDE);
                break;
            }
            case CASE: {
                tupleExpression = this.getCaseTupleExpression(call);
                break;
            }
            default: {
                tupleExpression = this.getRexCallTupleExpression(call);
            }
        }
        if (this.ifVerify) {
            tupleExpression.verify();
        }
        return tupleExpression;
    }

    private BinaryTupleExpression getBinaryTupleExpression(RexCall call, TupleExpression.ExpressionOperatorEnum op) {
        assert (call.operands.size() == 2);
        TupleExpression left = ((RexNode)call.operands.get(0)).accept(this);
        TupleExpression right = ((RexNode)call.operands.get(1)).accept(this);
        DataType dataType = DataType.getType(OLAPTable.DATATYPE_MAPPING.get((Object)call.type.getSqlTypeName()));
        BinaryTupleExpression tuple = new BinaryTupleExpression(dataType, op, Lists.newArrayList(left, right));
        tuple.setDigest(call.toString());
        return tuple;
    }

    private CaseTupleExpression getCaseTupleExpression(RexCall call) {
        RexNode elseNode;
        ArrayList<Pair<TupleFilter, TupleExpression>> whenList = Lists.newArrayListWithExpectedSize(call.operands.size() / 2);
        TupleExpression elseExpr = null;
        TupleFilterVisitor filterVistor = new TupleFilterVisitor(this.inputRowType);
        for (int i = 0; i < call.operands.size() - 1; i += 2) {
            if (!(call.operands.get(i) instanceof RexCall)) continue;
            RexCall whenCall = (RexCall)call.operands.get(i);
            CompareTupleFilter.CompareResultType compareResultType = RexUtil.getCompareResultType(whenCall);
            if (compareResultType == CompareTupleFilter.CompareResultType.AlwaysTrue) {
                elseExpr = ((RexNode)call.operands.get(i + 1)).accept(this);
                break;
            }
            if (compareResultType == CompareTupleFilter.CompareResultType.AlwaysFalse) continue;
            TupleFilter whenFilter = whenCall.accept(filterVistor);
            whenFilter = new FilterOptimizeTransformer().transform(whenFilter);
            TupleExpression thenExpr = ((RexNode)call.operands.get(i + 1)).accept(this);
            whenList.add(new Pair<TupleFilter, TupleExpression>(whenFilter, thenExpr));
        }
        if (!(elseExpr != null || call.operands.size() % 2 != 1 || (elseNode = (RexNode)call.operands.get(call.operands.size() - 1)) instanceof RexLiteral && ((RexLiteral)elseNode).getValue() == null)) {
            elseExpr = elseNode.accept(this);
        }
        DataType dataType = DataType.getType(OLAPTable.DATATYPE_MAPPING.get((Object)call.type.getSqlTypeName()));
        CaseTupleExpression tuple = new CaseTupleExpression(dataType, whenList, elseExpr);
        tuple.setDigest(call.toString());
        return tuple;
    }

    private RexCallTupleExpression getRexCallTupleExpression(RexCall call) {
        ArrayList<TupleExpression> children = Lists.newArrayListWithExpectedSize(call.getOperands().size());
        for (RexNode rexNode : call.operands) {
            children.add(rexNode.accept(this));
        }
        DataType dataType = DataType.getType(OLAPTable.DATATYPE_MAPPING.get((Object)call.type.getSqlTypeName()));
        RexCallTupleExpression tuple = new RexCallTupleExpression(dataType, children);
        tuple.setDigest(call.toString());
        return tuple;
    }

    @Override
    public TupleExpression visitLocalRef(RexLocalRef localRef) {
        throw new UnsupportedOperationException("local ref:" + localRef);
    }

    @Override
    public TupleExpression visitInputRef(RexInputRef inputRef) {
        int index = inputRef.getIndex();
        if (index < this.inputRowType.size()) {
            TupleExpression tuple;
            TblColRef column = this.inputRowType.getColumnByIndex(index);
            if (column.getSubTupleExps() != null) {
                DataType dataType = DataType.getType(OLAPTable.DATATYPE_MAPPING.get((Object)inputRef.getType().getSqlTypeName()));
                tuple = new RexCallTupleExpression(dataType, column.getSubTupleExps());
            } else {
                tuple = new ColumnTupleExpression(column);
            }
            tuple.setDigest(inputRef.toString());
            return tuple;
        }
        throw new IllegalStateException("Can't find " + inputRef + " from child columnrowtype");
    }

    public TupleExpression visitFirstRexInputRef(RexCall call) {
        for (RexNode operand : call.getOperands()) {
            TupleExpression r;
            if (operand instanceof RexInputRef) {
                return this.visitInputRef((RexInputRef)operand);
            }
            if (!(operand instanceof RexCall) || (r = this.visitFirstRexInputRef((RexCall)operand)) == null) continue;
            return r;
        }
        return null;
    }

    @Override
    public TupleExpression visitLiteral(RexLiteral literal) {
        Comparable value = literal.getValue();
        DataType dataType = DataType.getType(OLAPTable.DATATYPE_MAPPING.get((Object)literal.getType().getSqlTypeName()));
        ConstantTupleExpression tuple = value instanceof Number ? new ConstantTupleExpression(dataType, value) : (value == null ? new ConstantTupleExpression(dataType, null) : (value instanceof NlsString ? new ConstantTupleExpression(dataType, ((NlsString)value).getValue()) : new ConstantTupleExpression(dataType, value.toString())));
        tuple.setDigest(literal.toString());
        return tuple;
    }
}

