/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.kylin.common.KylinConfig;

public class HiveMetaStoreClientFactory {
    public static IMetaStoreClient getHiveMetaStoreClient(HiveConf hiveConf) throws MetaException, IOException {
        HiveMetaStoreClient metaStoreClient = null;
        String hiveMetadataOption = KylinConfig.getInstanceFromEnv().getHiveMetaDataType();
        if ("hcatalog".equals(hiveMetadataOption)) {
            metaStoreClient = new HiveMetaStoreClient((Configuration)hiveConf);
        } else if ("gluecatalog".equals(hiveMetadataOption)) {
            try {
                Class<?> clazz = Class.forName("org.apache.hive.hcatalog.common.HCatUtil");
                Method getHiveMetastoreClientMethod = clazz.getDeclaredMethod("getHiveMetastoreClient", HiveConf.class);
                metaStoreClient = (IMetaStoreClient)getHiveMetastoreClientMethod.invoke(null, hiveConf);
            }
            catch (Exception exp) {
                throw new IllegalStateException("Unable to create MetaStoreClient for " + hiveMetadataOption, exp);
            }
        } else {
            throw new IllegalArgumentException(hiveMetadataOption + " is not a good option.");
        }
        return metaStoreClient;
    }
}

