/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.coordinator.coordinate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.lock.DistributedLock;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.ZKUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.StreamingCubingEngine;
import org.apache.kylin.engine.mr.common.CubeJobLockUtil;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.shaded.com.google.common.base.Strings;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.stream.coordinator.StreamingCubeInfo;
import org.apache.kylin.stream.coordinator.coordinate.SegmentJobBuildInfo;
import org.apache.kylin.stream.coordinator.coordinate.StreamingCoordinator;
import org.apache.kylin.stream.coordinator.exception.StoreException;
import org.apache.kylin.stream.core.model.CubeAssignment;
import org.apache.kylin.stream.core.model.SegmentBuildState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildJobSubmitter
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(BuildJobSubmitter.class);
    private ConcurrentMap<String, ConcurrentSkipListSet<SegmentJobBuildInfo>> segmentBuildJobCheckList = Maps.newConcurrentMap();
    private Set<String> cubeCheckList = new ConcurrentSkipListSet<String>();
    private StreamingCoordinator coordinator;
    private long checkTimes = 0L;

    public BuildJobSubmitter(StreamingCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    void restore() {
        logger.info("Restore job submitter");
        this.segmentBuildJobCheckList.clear();
        this.cubeCheckList.clear();
        List<String> cubes = this.coordinator.getStreamMetadataStore().getCubes();
        for (String cube : cubes) {
            List<SegmentBuildState> segmentBuildStates = this.coordinator.getStreamMetadataStore().getSegmentBuildStates(cube);
            Collections.sort(segmentBuildStates);
            for (SegmentBuildState segmentBuildState : segmentBuildStates) {
                if (!segmentBuildState.isInBuilding()) continue;
                SegmentJobBuildInfo jobBuildInfo = new SegmentJobBuildInfo(cube, segmentBuildState.getSegmentName(), segmentBuildState.getState().getJobId());
                this.addToJobTrackList(jobBuildInfo);
            }
        }
    }

    void addToJobTrackList(SegmentJobBuildInfo segmentBuildJob) {
        ConcurrentSkipListSet previousValue;
        ConcurrentSkipListSet<SegmentJobBuildInfo> buildInfos = (ConcurrentSkipListSet<SegmentJobBuildInfo>)this.segmentBuildJobCheckList.get(segmentBuildJob.cubeName);
        if (buildInfos == null && (previousValue = this.segmentBuildJobCheckList.putIfAbsent(segmentBuildJob.cubeName, buildInfos = new ConcurrentSkipListSet<SegmentJobBuildInfo>())) != null) {
            buildInfos = previousValue;
        }
        logger.trace("Add job {} of segment [{} - {}] to track.", segmentBuildJob.jobID, segmentBuildJob.cubeName, segmentBuildJob.segmentName);
        boolean addSucceed = buildInfos.add(segmentBuildJob);
        if (!addSucceed) {
            logger.debug("Add {} failed because we have a duplicated one.", (Object)segmentBuildJob);
            buildInfos.remove(segmentBuildJob);
            buildInfos.add(segmentBuildJob);
        }
    }

    void addToCheckList(String cubeName) {
        this.cubeCheckList.add(cubeName);
    }

    void clearCheckList(String cubeName) {
        this.cubeCheckList.remove(cubeName);
        this.segmentBuildJobCheckList.remove(cubeName);
    }

    @Override
    public void run() {
        try {
            if (this.coordinator.isLead()) {
                this.doRun();
            }
        }
        catch (Exception e) {
            logger.error("Unexpected error", e);
        }
    }

    void doRun() {
        ++this.checkTimes;
        logger.debug("\n========================================================================= {}", (Object)this.checkTimes);
        this.fixLock();
        this.dumpSegmentBuildJobCheckList();
        this.coordinator.getStreamMetadataStore().reportStat();
        List<SegmentJobBuildInfo> successJobs = this.traceEarliestSegmentBuildJob();
        for (SegmentJobBuildInfo successJob : successJobs) {
            ConcurrentSkipListSet submittedBuildJobs = (ConcurrentSkipListSet)this.segmentBuildJobCheckList.get(successJob.cubeName);
            logger.trace("Remove job {} from check list.", (Object)successJob.jobID);
            submittedBuildJobs.remove(successJob);
        }
        this.findSegmentReadyToBuild();
        if (this.checkTimes % 100L == 1L) {
            logger.info("Force traverse all cubes periodically.");
            for (StreamingCubeInfo cubeInfo : this.coordinator.getEnableStreamingCubes()) {
                List<String> segmentList = this.checkSegmentBuildJobFromMetadata(cubeInfo.getCubeName());
                for (String segmentName : segmentList) {
                    this.submitSegmentBuildJob(cubeInfo.getCubeName(), segmentName);
                }
            }
        }
    }

    private void fixLock() {
        boolean takeAction = false;
        CuratorFramework zk = ZKUtil.getZookeeperClient(KylinConfig.getInstanceFromEnv());
        DistributedLock lock = KylinConfig.getInstanceFromEnv().getDistributedLockFactory().lockForCurrentThread();
        for (Map.Entry cubeInfo : this.segmentBuildJobCheckList.entrySet()) {
            String cubeName = (String)cubeInfo.getKey();
            Set jobList = ((ConcurrentSkipListSet)cubeInfo.getValue()).stream().map(a -> a.jobID).collect(Collectors.toSet());
            try {
                String lockPath = this.getCubeJobLockParentPathName(cubeName);
                List jobs = (List)zk.getChildren().forPath(lockPath);
                for (String job : jobs) {
                    if (!jobList.contains(job)) {
                        logger.warn("Found a broken job lock {} for streaming, will purge them.", (Object)job);
                        lock.purgeLocks(lockPath);
                        lock.purgeLocks(this.getEphemeralLockPathName(cubeName));
                        takeAction = true;
                        continue;
                    }
                    logger.trace("Job {} own a cube {} lock. ", (Object)job, (Object)cubeName);
                }
            }
            catch (Exception exp) {
                logger.error("Error", exp);
            }
        }
        if (takeAction) {
            logger.info("Fixed inconsistent lock.");
        }
    }

    List<SegmentJobBuildInfo> traceEarliestSegmentBuildJob() {
        ArrayList<SegmentJobBuildInfo> successJobs = Lists.newArrayList();
        for (Map.Entry entry : this.segmentBuildJobCheckList.entrySet()) {
            ConcurrentSkipListSet buildInfos = (ConcurrentSkipListSet)entry.getValue();
            if (buildInfos.isEmpty()) {
                logger.trace("Skip {}", entry.getKey());
                continue;
            }
            SegmentJobBuildInfo segmentBuildJob = (SegmentJobBuildInfo)buildInfos.first();
            logger.debug("Check the cube:{} segment:{} build status.", (Object)segmentBuildJob.cubeName, (Object)segmentBuildJob.segmentName);
            try {
                CubingJob cubingJob = (CubingJob)this.coordinator.getExecutableManager().getJob(segmentBuildJob.jobID);
                if (cubingJob == null) {
                    logger.error("Cannot find metadata of current job.");
                    continue;
                }
                ExecutableState jobState = cubingJob.getStatus();
                logger.debug("Current job state {}", (Object)jobState);
                if (ExecutableState.SUCCEED.equals((Object)jobState)) {
                    CubeManager cubeManager = this.coordinator.getCubeManager();
                    CubeInstance cubeInstance = cubeManager.getCube(segmentBuildJob.cubeName).latestCopyForWrite();
                    CubeSegment cubeSegment = cubeInstance.getSegment(segmentBuildJob.segmentName, null);
                    logger.info("The cube:{} segment:{} is ready to be promoted.", (Object)segmentBuildJob.cubeName, (Object)segmentBuildJob.segmentName);
                    this.coordinator.getClusterManager().segmentBuildComplete(cubingJob, cubeInstance, cubeSegment, segmentBuildJob);
                    this.addToCheckList(cubeInstance.getName());
                    successJobs.add(segmentBuildJob);
                    continue;
                }
                if (!ExecutableState.ERROR.equals((Object)jobState)) continue;
                if (segmentBuildJob.retryCnt < 5) {
                    logger.info("Job:{} is error, resume the job.", (Object)segmentBuildJob);
                    this.coordinator.getExecutableManager().resumeJob(segmentBuildJob.jobID);
                    ++segmentBuildJob.retryCnt;
                    continue;
                }
                logger.warn("Job:{} is error, exceed max retry. Kylin admin could resume it or discard it(to let new building job be sumbitted) .", (Object)segmentBuildJob);
            }
            catch (StoreException storeEx) {
                logger.error("Error when check streaming segment job build state:" + segmentBuildJob, storeEx);
                throw storeEx;
            }
        }
        return successJobs;
    }

    void findSegmentReadyToBuild() {
        Iterator<String> iterator = this.cubeCheckList.iterator();
        while (iterator.hasNext()) {
            String cubeName = iterator.next();
            List<String> segmentList = this.checkSegmentBuildJobFromMetadata(cubeName);
            boolean allSubmited = true;
            for (String segmentName : segmentList) {
                boolean ok = this.submitSegmentBuildJob(cubeName, segmentName);
                boolean bl = allSubmited = allSubmited && ok;
                if (ok) continue;
                logger.debug("Failed to submit building job for {}.", (Object)segmentName);
            }
            if (!allSubmited) continue;
            iterator.remove();
            logger.debug("Removed {} from check list.", (Object)cubeName);
        }
    }

    List<String> checkSegmentBuildJobFromMetadata(String cubeName) {
        ArrayList<String> result = Lists.newArrayList();
        CubeInstance cubeInstance = this.coordinator.getCubeManager().getCube(cubeName);
        if (this.isInOptimize(cubeInstance)) {
            return result;
        }
        int allowMaxBuildingSegments = cubeInstance.getConfig().getMaxBuildingSegments();
        CubeSegment latestHistoryReadySegment = cubeInstance.getLatestReadySegment();
        long minSegmentStart = -1L;
        if (latestHistoryReadySegment != null) {
            minSegmentStart = (Long)latestHistoryReadySegment.getTSRange().end.v;
        } else {
            logger.info("there is no ready segments for cube:{}, so only allow 1 segment build concurrently", (Object)cubeName);
            allowMaxBuildingSegments = 1;
        }
        CubeAssignment assignments = this.coordinator.getStreamMetadataStore().getAssignmentsByCube(cubeName);
        Set<Integer> cubeAssignedReplicaSets = assignments.getReplicaSetIDs();
        List<SegmentBuildState> segmentStates = this.coordinator.getStreamMetadataStore().getSegmentBuildStates(cubeName);
        int inBuildingSegments = cubeInstance.getBuildingSegments().size();
        int leftQuota = allowMaxBuildingSegments - inBuildingSegments;
        boolean stillQuotaForNewSegment = true;
        Collections.sort(segmentStates);
        for (int i = 0; i < segmentStates.size(); ++i) {
            boolean readyToBuild;
            SegmentBuildState segmentState;
            Pair<Long, Long> segmentRange;
            boolean needRebuild = false;
            if (leftQuota <= 0) {
                logger.info("No left quota to build segments for cube:{} at {}", (Object)cubeName, (Object)leftQuota);
                stillQuotaForNewSegment = false;
            }
            if ((segmentRange = CubeSegment.parseSegmentName((segmentState = segmentStates.get(i)).getSegmentName())).getFirst() < minSegmentStart) {
                logger.warn("The cube segment state is not correct because it belongs to historcial part, cube:{} segment:{}, clear it.", (Object)cubeName, (Object)segmentState.getSegmentName());
                this.coordinator.getStreamMetadataStore().removeSegmentBuildState(cubeName, segmentState.getSegmentName());
                continue;
            }
            if (segmentState.isInBuilding()) {
                needRebuild = this.checkSegmentBuildingJob(segmentState, cubeName, cubeInstance);
                if (!needRebuild) {
                    continue;
                }
            } else if (segmentState.isInWaiting()) {
                // empty if block
            }
            if (!(readyToBuild = this.checkSegmentIsReadyToBuild(segmentStates, i, cubeAssignedReplicaSets))) {
                logger.debug("Segment {} {} is not ready to submit a building job.", (Object)cubeName, (Object)segmentState);
                continue;
            }
            if (!stillQuotaForNewSegment && !needRebuild) continue;
            result.add(segmentState.getSegmentName());
            --leftQuota;
        }
        if (logger.isDebugEnabled() && !result.isEmpty()) {
            logger.debug("{} Candidate segment list to be built : {}.", (Object)cubeName, (Object)String.join((CharSequence)", ", result));
        }
        return result;
    }

    private boolean isInOptimize(CubeInstance cube) {
        Segments<CubeSegment> readyPendingSegments = cube.getSegments(SegmentStatusEnum.READY_PENDING);
        if (readyPendingSegments.size() > 0) {
            logger.info("The cube {} has READY_PENDING segments {}. It's not allowed for building", (Object)cube.getName(), (Object)readyPendingSegments);
            return true;
        }
        Segments<CubeSegment> newSegments = cube.getSegments(SegmentStatusEnum.NEW);
        for (CubeSegment newSegment : newSegments) {
            AbstractExecutable job;
            String jobId = newSegment.getLastBuildJobID();
            if (jobId == null || (job = this.coordinator.getExecutableManager().getJob(jobId)) == null || !(job instanceof CubingJob)) continue;
            CubingJob cubingJob = (CubingJob)job;
            if (!CubingJob.CubingJobTypeEnum.OPTIMIZE.toString().equals(cubingJob.getJobType())) continue;
            logger.info("The cube {} is in optimization. It's not allowed to build new segments during optimization.", (Object)cube.getName());
            return true;
        }
        return false;
    }

    boolean submitSegmentBuildJob(String cubeName, String segmentName) {
        logger.info("Try submit streaming segment build job, cube:{} segment:{}", (Object)cubeName, (Object)segmentName);
        CubeInstance cubeInstance = this.coordinator.getCubeManager().getCube(cubeName);
        try {
            CubeSegment newSeg = null;
            Pair<Long, Long> segmentRange = CubeSegment.parseSegmentName(segmentName);
            boolean segmentExists = false;
            for (CubeSegment segment : cubeInstance.getSegments()) {
                SegmentRange.TSRange tsRange = segment.getTSRange();
                if (!((Long)tsRange.start.v).equals(segmentRange.getFirst()) || !segmentRange.getSecond().equals(tsRange.end.v)) continue;
                segmentExists = true;
                newSeg = segment;
            }
            if (segmentExists) {
                logger.warn("Segment {} exists, it will be forced deleted.", (Object)segmentName);
                this.coordinator.getCubeManager().updateCubeDropSegments(cubeInstance, newSeg);
            }
            logger.debug("Create segment for {} {} .", (Object)cubeName, (Object)segmentName);
            newSeg = this.coordinator.getCubeManager().appendSegment(cubeInstance, new SegmentRange.TSRange(segmentRange.getFirst(), segmentRange.getSecond()));
            DefaultChainedExecutable executable = this.getStreamingCubingJob(newSeg);
            this.coordinator.getExecutableManager().addJob(executable);
            String jobId = executable.getId();
            newSeg.setLastBuildJobID(jobId);
            SegmentJobBuildInfo segmentJobBuildInfo = new SegmentJobBuildInfo(cubeName, segmentName, jobId);
            this.addToJobTrackList(segmentJobBuildInfo);
            SegmentBuildState.BuildState state = new SegmentBuildState.BuildState();
            state.setBuildStartTime(System.currentTimeMillis());
            state.setState(SegmentBuildState.BuildState.State.BUILDING);
            state.setJobId(jobId);
            logger.debug("Commit building job {} for {} {} .", jobId, cubeName, segmentName);
            this.coordinator.getStreamMetadataStore().updateSegmentBuildState(cubeName, segmentName, state);
            return true;
        }
        catch (Exception e) {
            logger.error("Streaming job submit fail, cubeName:" + cubeName + " segment:" + segmentName, e);
            return false;
        }
    }

    boolean checkSegmentBuildingJob(SegmentBuildState segmentState, String cubeName, CubeInstance cubeInstance) {
        String jobId = segmentState.getState().getJobId();
        logger.debug("There is segment in building, cube:{} segment:{} jobId:{}", cubeName, segmentState.getSegmentName(), jobId);
        long buildStartTime = segmentState.getState().getBuildStartTime();
        if (buildStartTime != 0L && jobId != null) {
            long buildDuration = System.currentTimeMillis() - buildStartTime;
            if (buildDuration < 900000L) {
                return false;
            }
            CubingJob cubingJob = (CubingJob)this.coordinator.getExecutableManager().getJob(jobId);
            if (cubingJob == null) {
                logger.warn("Looks like cubing job is dropped manually, it will be submitted a new one.");
                return true;
            }
            ExecutableState jobState = cubingJob.getStatus();
            if (ExecutableState.SUCCEED.equals((Object)jobState)) {
                CubeSegment cubeSegment = cubeInstance.getSegment(segmentState.getSegmentName(), null);
                if (cubeSegment != null && SegmentStatusEnum.READY == cubeSegment.getStatus()) {
                    logger.info("Job:{} is already succeed, and segment:{} is ready, remove segment build state", (Object)jobId, (Object)segmentState.getSegmentName());
                    this.coordinator.getStreamMetadataStore().removeSegmentBuildState(cubeName, segmentState.getSegmentName());
                }
                return false;
            }
            if (ExecutableState.ERROR.equals((Object)jobState)) {
                logger.info("Job:{} is error, resume the job.", (Object)jobId);
                this.coordinator.getExecutableManager().resumeJob(jobId);
                return false;
            }
            if (ExecutableState.DISCARDED.equals((Object)jobState)) {
                if (KylinConfig.getInstanceFromEnv().isAutoResubmitDiscardJob()) {
                    logger.debug("Job:{} is discard, resubmit it later.", (Object)jobId);
                    return true;
                }
                logger.debug("Job:{} is discard, please resubmit yourself.", (Object)jobId);
                return false;
            }
            logger.info("Job:{} is in running, job state: {}.", (Object)jobId, (Object)jobState);
        } else {
            logger.info("Unknown state {}", (Object)segmentState);
        }
        return false;
    }

    boolean checkSegmentIsReadyToBuild(List<SegmentBuildState> allSegmentStates, int checkedSegmentIdx, Set<Integer> cubeAssignedReplicaSets) {
        SegmentBuildState checkedSegmentState = allSegmentStates.get(checkedSegmentIdx);
        HashSet<Integer> notCompleteReplicaSets = Sets.newHashSet(Sets.difference(cubeAssignedReplicaSets, checkedSegmentState.getCompleteReplicaSets()));
        if (notCompleteReplicaSets.isEmpty()) {
            return true;
        }
        for (int i = checkedSegmentIdx + 1; i < allSegmentStates.size(); ++i) {
            SegmentBuildState segmentBuildState = allSegmentStates.get(i);
            Set<Integer> completeReplicaSetsForNext = segmentBuildState.getCompleteReplicaSets();
            Iterator notCompleteRSItr = notCompleteReplicaSets.iterator();
            while (notCompleteRSItr.hasNext()) {
                Integer rsID = (Integer)notCompleteRSItr.next();
                if (!completeReplicaSetsForNext.contains(rsID)) continue;
                logger.info("the replica set:{} doesn't have data for segment:{}, but have data for later segment:{}", rsID, checkedSegmentState.getSegmentName(), segmentBuildState.getSegmentName());
                notCompleteRSItr.remove();
            }
        }
        if (notCompleteReplicaSets.isEmpty()) {
            return true;
        }
        logger.debug("Not ready data for replica sets: {}", (Object)notCompleteReplicaSets);
        return false;
    }

    public Set<String> getCubeCheckList() {
        return this.cubeCheckList;
    }

    public DefaultChainedExecutable getStreamingCubingJob(CubeSegment segment) {
        return new StreamingCubingEngine().createStreamingCubingJob(segment, "SYSTEM");
    }

    void dumpSegmentBuildJobCheckList() {
        if (!logger.isTraceEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder("Dump JobCheckList:\t");
        for (Map.Entry cube : this.segmentBuildJobCheckList.entrySet()) {
            sb.append((String)cube.getKey()).append(":").append(cube.getValue());
        }
        if (logger.isTraceEnabled()) {
            logger.trace(sb.toString());
        }
    }

    private String getEphemeralLockPathName(String cube) {
        if (Strings.isNullOrEmpty(cube)) {
            throw new IllegalArgumentException("cube job lock path name is null");
        }
        return CubeJobLockUtil.getEphemeralLockPath(cube);
    }

    private String getCubeJobLockParentPathName(String cube) {
        if (Strings.isNullOrEmpty(cube)) {
            throw new IllegalArgumentException(" create mr hive dict lock path name is null");
        }
        return CubeJobLockUtil.getLockPath(cube, null);
    }
}

