/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.source.kafka;

import java.util.Locale;
import org.apache.kylin.job.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.kylin.stream.core.source.MessageParserInfo;
import org.apache.kylin.stream.source.kafka.AbstractTimeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongTimeParser
extends AbstractTimeParser {
    private static final Logger logger = LoggerFactory.getLogger(LongTimeParser.class);
    private String tsPattern = null;

    public LongTimeParser(MessageParserInfo parserInfo) {
        super(parserInfo);
        this.tsPattern = parserInfo.getTsPattern().toUpperCase(Locale.ENGLISH);
    }

    @Override
    public long parseTime(String time) throws IllegalArgumentException {
        long t;
        if (StringUtils.isEmpty(time)) {
            t = 0L;
        } else {
            try {
                t = Long.parseLong(time);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if ("S".equals(this.tsPattern)) {
            t *= 1000L;
        }
        return t;
    }
}

