/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark;

import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.spark.ISparkInput;
import org.apache.kylin.engine.spark.ISparkOutput;
import org.apache.kylin.engine.spark.SparkCubingMerge;
import org.apache.kylin.engine.spark.SparkExecutable;
import org.apache.kylin.engine.spark.SparkExecutableFactory;
import org.apache.kylin.engine.spark.SparkMergingDictionary;
import org.apache.kylin.engine.spark.SparkUtil;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkBatchMergeJobBuilder2
extends JobBuilderSupport {
    private static final Logger logger = LoggerFactory.getLogger(SparkBatchMergeJobBuilder2.class);
    private final ISparkOutput.ISparkBatchMergeOutputSide outputSide;
    private final ISparkInput.ISparkBatchMergeInputSide inputSide;

    public SparkBatchMergeJobBuilder2(CubeSegment mergeSegment, String submitter) {
        super(mergeSegment, submitter);
        this.outputSide = SparkUtil.getBatchMergeOutputSide2(this.seg);
        this.inputSide = SparkUtil.getBatchMergeInputSide(this.seg);
    }

    public CubingJob build() {
        logger.info("Spark_V2 new job to MERGE segment " + this.seg);
        CubeSegment cubeSegment = this.seg;
        CubingJob result = CubingJob.createMergeJob(cubeSegment, this.submitter, this.config);
        String jobId = result.getId();
        Segments<CubeSegment> mergingSegments = cubeSegment.getCubeInstance().getMergingSegments(cubeSegment);
        Preconditions.checkState(mergingSegments.size() > 1, "there should be more than 2 segments to merge, target segment " + cubeSegment);
        ArrayList<String> mergingSegmentIds = Lists.newArrayList();
        for (CubeSegment merging : mergingSegments) {
            mergingSegmentIds.add(merging.getUuid());
        }
        this.inputSide.addStepPhase1_MergeDictionary(result);
        result.addTask(this.createMergeDictionaryStep(cubeSegment, jobId, mergingSegmentIds));
        result.addTask(this.createUpdateDictionaryStep(cubeSegment, jobId, mergingSegmentIds));
        this.outputSide.addStepPhase1_MergeDictionary(result);
        result.addTask(this.createMergeCuboidDataStep(cubeSegment, mergingSegments, jobId));
        this.outputSide.addStepPhase2_BuildCube(this.seg, mergingSegments, result);
        result.addTask(this.createUpdateCubeInfoAfterMergeStep(mergingSegmentIds, jobId));
        this.outputSide.addStepPhase3_Cleanup(result);
        return result;
    }

    public SparkExecutable createMergeDictionaryStep(CubeSegment seg, String jobID, List<String> mergingSegmentIds) {
        SparkExecutable sparkExecutable = SparkExecutableFactory.instance(seg.getConfig());
        sparkExecutable.setClassName(SparkMergingDictionary.class.getName());
        sparkExecutable.setParam(SparkMergingDictionary.OPTION_CUBE_NAME.getOpt(), seg.getRealization().getName());
        sparkExecutable.setParam(SparkMergingDictionary.OPTION_SEGMENT_ID.getOpt(), seg.getUuid());
        sparkExecutable.setParam(SparkMergingDictionary.OPTION_META_URL.getOpt(), this.getSegmentMetadataUrl(seg.getConfig(), jobID));
        sparkExecutable.setParam(SparkMergingDictionary.OPTION_MERGE_SEGMENT_IDS.getOpt(), StringUtil.join(mergingSegmentIds, ","));
        sparkExecutable.setParam(SparkMergingDictionary.OPTION_OUTPUT_PATH_DICT.getOpt(), this.getDictInfoPath(jobID));
        sparkExecutable.setParam(SparkMergingDictionary.OPTION_OUTPUT_PATH_STAT.getOpt(), this.getStatisticsPath(jobID));
        sparkExecutable.setJobId(jobID);
        sparkExecutable.setName("Merge Cuboid Dictionary:" + seg.toString());
        sparkExecutable.setSparkConfigName("mergedict");
        StringBuilder jars = new StringBuilder();
        StringUtil.appendWithSeparator(jars, seg.getConfig().getSparkAdditionalJars());
        sparkExecutable.setJars(jars.toString());
        return sparkExecutable;
    }

    public SparkExecutable createMergeCuboidDataStep(CubeSegment seg, List<CubeSegment> mergingSegments, String jobID) {
        ArrayList<String> mergingCuboidPaths = Lists.newArrayList();
        for (CubeSegment merging : mergingSegments) {
            mergingCuboidPaths.add(this.getCuboidRootPath(merging));
        }
        String formattedPath = StringUtil.join(mergingCuboidPaths, ",");
        String outputPath = this.getCuboidRootPath(jobID);
        SparkExecutable sparkExecutable = SparkExecutableFactory.instance(seg.getConfig());
        sparkExecutable.setClassName(SparkCubingMerge.class.getName());
        sparkExecutable.setParam(SparkCubingMerge.OPTION_CUBE_NAME.getOpt(), seg.getRealization().getName());
        sparkExecutable.setParam(SparkCubingMerge.OPTION_SEGMENT_ID.getOpt(), seg.getUuid());
        sparkExecutable.setParam(SparkCubingMerge.OPTION_INPUT_PATH.getOpt(), formattedPath);
        sparkExecutable.setParam(SparkCubingMerge.OPTION_META_URL.getOpt(), this.getSegmentMetadataUrl(seg.getConfig(), jobID));
        sparkExecutable.setParam(SparkCubingMerge.OPTION_OUTPUT_PATH.getOpt(), outputPath);
        sparkExecutable.setJobId(jobID);
        sparkExecutable.setName("Merge Cuboid Data:" + seg.toString());
        StringBuilder jars = new StringBuilder();
        StringUtil.appendWithSeparator(jars, seg.getConfig().getSparkAdditionalJars());
        sparkExecutable.setJars(jars.toString());
        return sparkExecutable;
    }
}

