/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.job;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.dict.lookup.ExtTableSnapshotInfo;
import org.apache.kylin.dict.lookup.ExtTableSnapshotInfoManager;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageCleanJobHbaseUtil {
    protected static final Logger logger = LoggerFactory.getLogger(StorageCleanJobHbaseUtil.class);

    public static void cleanUnusedHBaseTables(boolean delete, int deleteTimeout, int threadsNum) throws IOException {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        Connection connection = HBaseConnection.get(kylinConfig.getStorageUrl());
        try (Admin hbaseAdmin = connection.getAdmin();){
            StorageCleanJobHbaseUtil.cleanUnusedHBaseTables(hbaseAdmin, delete, deleteTimeout, threadsNum);
        }
    }

    static List<String> cleanUnusedHBaseTables(Admin hbaseAdmin, boolean delete, int deleteTimeout) throws IOException {
        return StorageCleanJobHbaseUtil.cleanUnusedHBaseTables(hbaseAdmin, delete, deleteTimeout, 1);
    }

    static List<String> cleanUnusedHBaseTables(Admin hbaseAdmin, boolean delete, int deleteTimeout, int threadsNum) throws IOException {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        CubeManager cubeMgr = CubeManager.getInstance(config);
        String namespace = config.getHBaseStorageNameSpace();
        String tableNamePrefix = namespace.equals("default") || namespace.equals("") ? config.getHBaseTableNamePrefix() : namespace + ":" + config.getHBaseTableNamePrefix();
        HTableDescriptor[] tableDescriptors = hbaseAdmin.listTables(tableNamePrefix + ".*");
        ArrayList<String> allTablesNeedToBeDropped = new ArrayList<String>();
        boolean hasExtLookupTable = false;
        for (HTableDescriptor desc : tableDescriptors) {
            String host = desc.getValue("KYLIN_HOST");
            if (!config.getMetadataUrlPrefix().equalsIgnoreCase(host)) continue;
            if (desc.getTableName().getNameAsString().contains("LOOKUP_")) {
                hasExtLookupTable = true;
            }
            allTablesNeedToBeDropped.add(desc.getTableName().getNameAsString());
        }
        for (CubeInstance cube : cubeMgr.reloadAndListAllCubes()) {
            for (CubeSegment seg : cube.getSegments()) {
                String tablename = seg.getStorageLocationIdentifier();
                if (!allTablesNeedToBeDropped.contains(tablename)) continue;
                allTablesNeedToBeDropped.remove(tablename);
                logger.info("Exclude table " + tablename + " from drop list, as the table belongs to cube " + cube.getName() + " with status " + cube.getStatus());
            }
        }
        if (allTablesNeedToBeDropped.isEmpty()) {
            logger.info("No HTable to clean up");
            return allTablesNeedToBeDropped;
        }
        logger.info(allTablesNeedToBeDropped.size() + " HTable(s) to clean up");
        if (hasExtLookupTable) {
            List<String> useExtLookupTables = StorageCleanJobHbaseUtil.getAllUsedExtLookupTables();
            logger.info("Exclude tables:{}, as they are referred by snapshots.", (Object)useExtLookupTables);
            allTablesNeedToBeDropped.removeAll(useExtLookupTables);
        }
        if (delete) {
            logger.info("Use {} threads to drop unused hbase tables", (Object)threadsNum);
            ExecutorService executorService = Executors.newFixedThreadPool(threadsNum);
            ArrayList tasks = Lists.newArrayListWithExpectedSize((int)allTablesNeedToBeDropped.size());
            for (String htableName : allTablesNeedToBeDropped) {
                tasks.add(executorService.submit(new DeleteHTableRunnable(hbaseAdmin, htableName)));
            }
            String htableName = "";
            for (Future futureTask : tasks) {
                if (futureTask.isDone()) continue;
                try {
                    htableName = (String)futureTask.get(deleteTimeout, TimeUnit.MINUTES);
                }
                catch (TimeoutException e) {
                    logger.error("It fails to delete HTable " + htableName + ", for it cost more than " + deleteTimeout + " minutes.", e);
                    futureTask.cancel(true);
                }
                catch (Exception e) {
                    logger.error("Failed to delete HTable " + htableName, e);
                    futureTask.cancel(true);
                }
            }
            executorService.shutdown();
        } else {
            for (String htableName : allTablesNeedToBeDropped) {
                logger.info("Dry run, pending delete HTable " + htableName);
            }
        }
        return allTablesNeedToBeDropped;
    }

    private static List<String> getAllUsedExtLookupTables() throws IOException {
        ArrayList result = Lists.newArrayList();
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        Set<String> activeSnapshotSet = ExtTableSnapshotInfoManager.getInstance(config).getAllExtSnapshotResPaths();
        for (String extSnapshotResource : activeSnapshotSet) {
            try {
                ExtTableSnapshotInfo extTableSnapshot = ExtTableSnapshotInfoManager.getInstance(config).getSnapshot(extSnapshotResource);
                if (extTableSnapshot == null || !"hbase".equals(extTableSnapshot.getStorageType())) continue;
                result.add(extTableSnapshot.getStorageLocationIdentifier());
            }
            catch (Exception e) {
                logger.error("error fetch ext table snapshot:" + extSnapshotResource, e);
            }
        }
        return result;
    }

    static class DeleteHTableRunnable
    implements Callable {
        Admin hbaseAdmin;
        TableName htableName;

        DeleteHTableRunnable(Admin hbaseAdmin, String htableName) {
            this.hbaseAdmin = hbaseAdmin;
            this.htableName = TableName.valueOf((String)htableName);
        }

        public String call() throws Exception {
            if (this.hbaseAdmin.tableExists(this.htableName)) {
                if (this.hbaseAdmin.isTableEnabled(this.htableName)) {
                    this.hbaseAdmin.disableTable(this.htableName);
                }
                this.hbaseAdmin.deleteTable(this.htableName);
                logger.info("Deleted HBase table " + this.htableName);
            } else {
                logger.info("HBase table " + this.htableName + " does not exist");
            }
            return this.htableName.getNameAsString();
        }
    }
}

