/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.NotImplementedException;

public class MockHTable
implements Table {
    private final String tableName;
    private final List<String> columnFamilies = new ArrayList<String>();
    private NavigableMap<byte[], NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>> data = new TreeMap<byte[], NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>>(Bytes.BYTES_COMPARATOR);

    private static List<Cell> toKeyValue(byte[] row, NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> rowdata, int maxVersions) {
        return MockHTable.toKeyValue(row, rowdata, 0L, Long.MAX_VALUE, maxVersions);
    }

    public MockHTable(String tableName) {
        this.tableName = tableName;
    }

    public MockHTable(String tableName, String ... columnFamilies) {
        this.tableName = tableName;
        this.columnFamilies.addAll(Arrays.asList(columnFamilies));
    }

    public void addColumnFamily(String columnFamily) {
        this.columnFamilies.add(columnFamily);
    }

    public TableName getName() {
        return null;
    }

    public Configuration getConfiguration() {
        throw new RuntimeException(this.getClass() + " does NOT implement this method.");
    }

    public HTableDescriptor getTableDescriptor() throws IOException {
        HTableDescriptor table = new HTableDescriptor(TableName.valueOf((String)this.tableName));
        for (String columnFamily : this.columnFamilies) {
            table.addFamily(new HColumnDescriptor(columnFamily));
        }
        return table;
    }

    public TableDescriptor getDescriptor() throws IOException {
        return null;
    }

    public void mutateRow(RowMutations rm) throws IOException {
        for (Mutation mutation : rm.getMutations()) {
            if (mutation instanceof Put) {
                this.put((Put)mutation);
                continue;
            }
            if (!(mutation instanceof Delete)) continue;
            this.delete((Delete)mutation);
        }
    }

    public Result append(Append append) throws IOException {
        throw new RuntimeException(this.getClass() + " does NOT implement this method.");
    }

    private static List<Cell> toKeyValue(byte[] row, NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> rowdata, long timestampStart, long timestampEnd, int maxVersions) {
        ArrayList<Cell> ret = new ArrayList<Cell>();
        for (byte[] family : rowdata.keySet()) {
            block1: for (byte[] qualifier : ((NavigableMap)rowdata.get(family)).keySet()) {
                int versionsAdded = 0;
                for (Map.Entry tsToVal : ((NavigableMap)((NavigableMap)rowdata.get(family)).get(qualifier)).descendingMap().entrySet()) {
                    if (versionsAdded++ == maxVersions) continue block1;
                    Long timestamp = (Long)tsToVal.getKey();
                    if (timestamp < timestampStart || timestamp > timestampEnd) continue;
                    byte[] value = (byte[])tsToVal.getValue();
                    ret.add((Cell)new KeyValue(row, family, qualifier, timestamp.longValue(), value));
                }
            }
        }
        return ret;
    }

    public boolean exists(Get get) throws IOException {
        Result result = this.get(get);
        return result != null && !result.isEmpty();
    }

    public boolean[] exists(List<Get> list) throws IOException {
        return new boolean[0];
    }

    public boolean[] existsAll(List<Get> list) throws IOException {
        return new boolean[0];
    }

    public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
        results = this.batch(actions);
    }

    public Object[] batch(List<? extends Row> actions) throws IOException, InterruptedException {
        Object[] results = new Object[actions.size()];
        for (int i = 0; i < actions.size(); ++i) {
            Result result;
            Row r = actions.get(i);
            if (r instanceof Delete) {
                this.delete((Delete)r);
                results[i] = new Result();
            }
            if (r instanceof Put) {
                this.put((Put)r);
                results[i] = new Result();
            }
            if (r instanceof Get) {
                result = this.get((Get)r);
                results[i] = result;
            }
            if (r instanceof Increment) {
                result = this.increment((Increment)r);
                results[i] = result;
            }
            if (!(r instanceof Append)) continue;
            result = this.append((Append)r);
            results[i] = result;
        }
        return results;
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
    }

    public Result get(Get get) throws IOException {
        if (!this.data.containsKey(get.getRow())) {
            return new Result();
        }
        byte[] row = get.getRow();
        List<Object> kvs = new ArrayList();
        if (!get.hasFamilies()) {
            kvs = MockHTable.toKeyValue(row, (NavigableMap)this.data.get(row), get.getMaxVersions());
        } else {
            for (byte[] family : get.getFamilyMap().keySet()) {
                if (((NavigableMap)this.data.get(row)).get(family) == null) continue;
                NavigableSet qualifiers = (NavigableSet)get.getFamilyMap().get(family);
                if (qualifiers == null || qualifiers.isEmpty()) {
                    qualifiers = ((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).navigableKeySet();
                }
                for (byte[] qualifier : qualifiers) {
                    if (qualifier == null) {
                        qualifier = "".getBytes(StandardCharsets.UTF_8);
                    }
                    if (!((NavigableMap)this.data.get(row)).containsKey(family) || !((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).containsKey(qualifier) || ((NavigableMap)((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).get(qualifier)).isEmpty()) continue;
                    Map.Entry timestampAndValue = ((NavigableMap)((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).get(qualifier)).lastEntry();
                    kvs.add(new KeyValue(row, family, qualifier, ((Long)timestampAndValue.getKey()).longValue(), (byte[])timestampAndValue.getValue()));
                }
            }
        }
        Filter filter = get.getFilter();
        if (filter != null) {
            kvs = this.filter(filter, kvs);
        }
        return Result.create(kvs);
    }

    public Result[] get(List<Get> gets) throws IOException {
        ArrayList<Result> results = new ArrayList<Result>();
        for (Get g : gets) {
            results.add(this.get(g));
        }
        return results.toArray(new Result[results.size()]);
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        final ArrayList<Result> ret = new ArrayList<Result>();
        byte[] st = scan.getStartRow();
        byte[] sp = scan.getStopRow();
        Filter filter = scan.getFilter();
        for (byte[] row : this.data.keySet()) {
            if (st != null && st.length > 0 && Bytes.BYTES_COMPARATOR.compare(st, row) != 0) {
                if (st != null && st.length > 0 && Bytes.BYTES_COMPARATOR.compare(st, row) > 0) continue;
                if (sp != null && sp.length > 0 && Bytes.BYTES_COMPARATOR.compare(sp, row) <= 0) break;
            }
            List<Object> kvs = null;
            if (!scan.hasFamilies()) {
                kvs = MockHTable.toKeyValue(row, (NavigableMap)this.data.get(row), scan.getTimeRange().getMin(), scan.getTimeRange().getMax(), scan.getMaxVersions());
            } else {
                kvs = new ArrayList();
                for (byte[] family : scan.getFamilyMap().keySet()) {
                    if (((NavigableMap)this.data.get(row)).get(family) == null) continue;
                    NavigableSet qualifiers = (NavigableSet)scan.getFamilyMap().get(family);
                    if (qualifiers == null || qualifiers.isEmpty()) {
                        qualifiers = ((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).navigableKeySet();
                    }
                    block2: for (byte[] qualifier : qualifiers) {
                        if (((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).get(qualifier) == null) continue;
                        for (Long timestamp : ((NavigableMap)((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).get(qualifier)).descendingKeySet()) {
                            if (timestamp < scan.getTimeRange().getMin() || timestamp > scan.getTimeRange().getMax()) continue;
                            byte[] value = (byte[])((NavigableMap)((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).get(qualifier)).get(timestamp);
                            kvs.add(new KeyValue(row, family, qualifier, timestamp.longValue(), value));
                            if (kvs.size() != scan.getMaxVersions()) continue;
                            continue block2;
                        }
                    }
                }
            }
            if (filter != null) {
                kvs = this.filter(filter, kvs);
                if (filter.filterAllRemaining()) break;
            }
            if (kvs.isEmpty()) continue;
            ret.add(Result.create(kvs));
        }
        return new ResultScanner(){
            private final Iterator<Result> iterator;
            {
                this.iterator = ret.iterator();
            }

            public Iterator<Result> iterator() {
                return this.iterator;
            }

            public Result[] next(int nbRows) throws IOException {
                Result next;
                ArrayList<Result> resultSets = new ArrayList<Result>(nbRows);
                for (int i = 0; i < nbRows && (next = this.next()) != null; ++i) {
                    resultSets.add(next);
                }
                return resultSets.toArray(new Result[resultSets.size()]);
            }

            public Result next() throws IOException {
                try {
                    return this.iterator().next();
                }
                catch (NoSuchElementException e) {
                    return null;
                }
            }

            public void close() {
            }

            public boolean renewLease() {
                return false;
            }

            public ScanMetrics getScanMetrics() {
                return null;
            }
        };
    }

    private List<Cell> filter(Filter filter, List<Cell> kvs) throws IOException {
        filter.reset();
        ArrayList<Cell> tmp = new ArrayList<Cell>(kvs.size());
        tmp.addAll(kvs);
        boolean filteredOnRowKey = false;
        ArrayList<Cell> nkvs = new ArrayList<Cell>(tmp.size());
        for (Cell kv : tmp) {
            if (filter.filterRowKey(kv)) {
                filteredOnRowKey = true;
                break;
            }
            Filter.ReturnCode filterResult = filter.filterKeyValue(kv);
            if (filterResult == Filter.ReturnCode.INCLUDE) {
                nkvs.add(kv);
                continue;
            }
            if (filterResult == Filter.ReturnCode.NEXT_ROW) break;
            if (filterResult != Filter.ReturnCode.NEXT_COL && filterResult != Filter.ReturnCode.SKIP) continue;
        }
        if (filter.hasFilterRow() && !filteredOnRowKey) {
            filter.filterRow();
        }
        if (filter.filterRow() || filteredOnRowKey) {
            nkvs.clear();
        }
        tmp = nkvs;
        return tmp;
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.getScanner(scan);
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.getScanner(scan);
    }

    private <K, V> V forceFind(NavigableMap<K, V> map, K key, V newObject) {
        Object data = map.get(key);
        if (data == null) {
            data = newObject;
            map.put(key, data);
        }
        return data;
    }

    public void put(Put put) throws IOException {
        byte[] row = put.getRow();
        NavigableMap rowData = this.forceFind(this.data, row, new TreeMap(Bytes.BYTES_COMPARATOR));
        for (byte[] family : put.getFamilyCellMap().keySet()) {
            if (!this.columnFamilies.contains(new String(family, StandardCharsets.UTF_8))) {
                throw new RuntimeException("Not Exists columnFamily : " + new String(family, StandardCharsets.UTF_8));
            }
            NavigableMap familyData = this.forceFind(rowData, family, new TreeMap(Bytes.BYTES_COMPARATOR));
            for (Cell kv : (List)put.getFamilyCellMap().get(family)) {
                CellUtil.updateLatestStamp((Cell)kv, (long)System.currentTimeMillis());
                byte[] qualifier = kv.getQualifierArray();
                NavigableMap qualifierData = this.forceFind(familyData, qualifier, new TreeMap());
                qualifierData.put(kv.getTimestamp(), kv.getValueArray());
            }
        }
    }

    public void put(List<Put> puts) throws IOException {
        for (Put put : puts) {
            this.put(put);
        }
    }

    private boolean check(byte[] row, byte[] family, byte[] qualifier, byte[] value) {
        if (value == null || value.length == 0) {
            return !this.data.containsKey(row) || !((NavigableMap)this.data.get(row)).containsKey(family) || !((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).containsKey(qualifier);
        }
        return this.data.containsKey(row) && ((NavigableMap)this.data.get(row)).containsKey(family) && ((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).containsKey(qualifier) && !((NavigableMap)((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).get(qualifier)).isEmpty() && Arrays.equals((byte[])((NavigableMap)((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).get(qualifier)).lastEntry().getValue(), value);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        if (this.check(row, family, qualifier, value)) {
            this.put(put);
            return true;
        }
        return false;
    }

    public boolean checkAndPut(byte[] bytes, byte[] bytes1, byte[] bytes2, CompareFilter.CompareOp compareOp, byte[] bytes3, Put put) throws IOException {
        return false;
    }

    public boolean checkAndPut(byte[] bytes, byte[] bytes1, byte[] bytes2, CompareOperator compareOperator, byte[] bytes3, Put put) throws IOException {
        return false;
    }

    public void delete(Delete delete) throws IOException {
        byte[] row = delete.getRow();
        if (this.data.get(row) == null) {
            return;
        }
        if (delete.getFamilyCellMap().size() == 0) {
            this.data.remove(row);
            return;
        }
        for (byte[] family : delete.getFamilyCellMap().keySet()) {
            if (((NavigableMap)this.data.get(row)).get(family) == null) continue;
            if (((List)delete.getFamilyCellMap().get(family)).isEmpty()) {
                ((NavigableMap)this.data.get(row)).remove(family);
                continue;
            }
            for (Cell kv : (List)delete.getFamilyCellMap().get(family)) {
                if (CellUtil.isDelete((Cell)kv)) {
                    ((NavigableMap)((NavigableMap)this.data.get(row)).get(kv.getFamilyArray())).clear();
                    continue;
                }
                ((NavigableMap)((NavigableMap)this.data.get(row)).get(kv.getFamilyArray())).remove(kv.getQualifierArray());
            }
            if (!((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).isEmpty()) continue;
            ((NavigableMap)this.data.get(row)).remove(family);
        }
        if (((NavigableMap)this.data.get(row)).isEmpty()) {
            this.data.remove(row);
        }
    }

    public void delete(List<Delete> deletes) throws IOException {
        for (Delete delete : deletes) {
            this.delete(delete);
        }
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        if (this.check(row, family, qualifier, value)) {
            this.delete(delete);
            return true;
        }
        return false;
    }

    public boolean checkAndDelete(byte[] bytes, byte[] bytes1, byte[] bytes2, CompareFilter.CompareOp compareOp, byte[] bytes3, Delete delete) throws IOException {
        return false;
    }

    public boolean checkAndDelete(byte[] bytes, byte[] bytes1, byte[] bytes2, CompareOperator compareOperator, byte[] bytes3, Delete delete) throws IOException {
        return false;
    }

    public Table.CheckAndMutateBuilder checkAndMutate(byte[] bytes, byte[] bytes1) {
        return null;
    }

    public Result increment(Increment increment) throws IOException {
        throw new NotImplementedException();
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        return this.incrementColumnValue(row, family, qualifier, amount, null);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        return 0L;
    }

    public void close() throws IOException {
    }

    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        throw new NotImplementedException();
    }

    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        throw new NotImplementedException();
    }

    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        throw new NotImplementedException();
    }

    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
        throw new NotImplementedException();
    }

    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
        throw new NotImplementedException();
    }

    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations mutation) throws IOException {
        throw new NotImplementedException();
    }

    public boolean checkAndMutate(byte[] bytes, byte[] bytes1, byte[] bytes2, CompareOperator compareOperator, byte[] bytes3, RowMutations rowMutations) throws IOException {
        return false;
    }

    public long getRpcTimeout(TimeUnit timeUnit) {
        return 0L;
    }

    public void setOperationTimeout(int i) {
    }

    public int getOperationTimeout() {
        return 0;
    }

    public int getRpcTimeout() {
        return 0;
    }

    public void setRpcTimeout(int i) {
    }

    public long getReadRpcTimeout(TimeUnit timeUnit) {
        return 0L;
    }

    public int getReadRpcTimeout() {
        return 0;
    }

    public void setReadRpcTimeout(int i) {
    }

    public long getWriteRpcTimeout(TimeUnit timeUnit) {
        return 0L;
    }

    public int getWriteRpcTimeout() {
        return 0;
    }

    public void setWriteRpcTimeout(int i) {
    }

    public long getOperationTimeout(TimeUnit timeUnit) {
        return 0L;
    }
}

