/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.List;
import java.util.Locale;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

@Component(value="encodingService")
public class EncodingService
extends BasicService {
    public List<String> getValidEncodings(DataType dataType) {
        Message msg = MsgPicker.getMsg();
        if (dataType.isIntegerFamily()) {
            return Lists.newArrayList("boolean", "date", "time", "dict", "integer");
        }
        if (dataType.isNumberFamily()) {
            return Lists.newArrayList("dict");
        }
        if (dataType.isDateTimeFamily()) {
            return Lists.newArrayList("date", "time", "dict");
        }
        if (dataType.isStringFamily()) {
            return Lists.newArrayList("boolean", "dict", "fixed_length", "fixed_length_hex", "integer");
        }
        throw new BadRequestException(String.format(Locale.ROOT, msg.getVALID_ENCODING_NOT_AVAILABLE(), dataType));
    }
}

