/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cachesync;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.persistence.ContentReader;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.metadata.cachesync.SingleValueCache;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CachedCrudAssist<T extends RootPersistentEntity> {
    private static final Logger logger = LoggerFactory.getLogger(CachedCrudAssist.class);
    private final ResourceStore store;
    private final Class<T> entityType;
    private final String resRootPath;
    private final String resPathSuffix;
    private final Serializer<T> serializer;
    private final SingleValueCache<String, T> cache;
    private boolean checkCopyOnWrite;
    private final List<String> loadErrors = new ArrayList<String>();

    public CachedCrudAssist(ResourceStore store, String resourceRootPath, Class<T> entityType, SingleValueCache<String, T> cache) {
        this(store, resourceRootPath, ".json", entityType, cache, false);
    }

    public CachedCrudAssist(ResourceStore store, String resourceRootPath, String resourcePathSuffix, Class<T> entityType, SingleValueCache<String, T> cache, boolean compact) {
        this.store = store;
        this.entityType = entityType;
        this.resRootPath = resourceRootPath;
        this.resPathSuffix = resourcePathSuffix;
        this.serializer = new JsonSerializer<T>(entityType, compact);
        this.cache = cache;
        this.checkCopyOnWrite = store.getConfig().isCheckCopyOnWrite();
        Preconditions.checkArgument(this.resRootPath.startsWith("/"));
        Preconditions.checkArgument(!this.resRootPath.endsWith("/"));
    }

    public Serializer<DataModelDesc> getSerializer() {
        return this.serializer;
    }

    public void setCheckCopyOnWrite(boolean check) {
        this.checkCopyOnWrite = check;
    }

    public T copyForWrite(T entity) {
        T copy;
        if (!((RootPersistentEntity)entity).isCachedAndShared()) {
            return entity;
        }
        try {
            byte[] bytes;
            try (ByteArrayOutputStream buf = new ByteArrayOutputStream();
                 DataOutputStream dout = new DataOutputStream(buf);){
                this.serializer.serialize(entity, dout);
                bytes = buf.toByteArray();
            }
            var5_3 = null;
            try (DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));){
                copy = this.serializer.deserialize(in);
            }
            catch (Throwable throwable) {
                var5_3 = throwable;
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ((RootPersistentEntity)copy).setCachedAndShared(false);
        this.initEntityAfterReload(copy, ((RootPersistentEntity)entity).resourceName());
        return copy;
    }

    private String resourcePath(String resourceName) {
        return this.resRootPath + "/" + resourceName + this.resPathSuffix;
    }

    protected String resourceName(String resourcePath) {
        Preconditions.checkArgument(resourcePath.startsWith(this.resRootPath));
        Preconditions.checkArgument(resourcePath.endsWith(this.resPathSuffix));
        return resourcePath.substring(this.resRootPath.length() + 1, resourcePath.length() - this.resPathSuffix.length());
    }

    public void reloadAll() throws IOException {
        logger.debug("Reloading " + this.entityType.getSimpleName() + " from " + this.store.getReadableResourcePath(this.resRootPath));
        this.cache.clear();
        this.loadErrors.clear();
        Map<String, T> entities = this.store.getAllResourcesMap(this.resRootPath, true, null, new ContentReader<T>(this.serializer));
        for (Map.Entry<String, T> entitySet : entities.entrySet()) {
            String path = entitySet.getKey();
            if (!path.endsWith(this.resPathSuffix)) continue;
            RootPersistentEntity entity = (RootPersistentEntity)entitySet.getValue();
            try {
                if (entity == null) {
                    logger.warn("No " + this.entityType.getSimpleName() + " found at " + path + ", returning null");
                    this.cache.removeLocal(this.resourceName(path));
                    continue;
                }
                entity.setCachedAndShared(true);
                if (!path.equals(this.resourcePath((entity = this.initEntityAfterReload(entity, this.resourceName(path))).resourceName()))) continue;
                this.cache.putLocal(entity.resourceName(), entity);
            }
            catch (Exception ex) {
                logger.error("Error loading " + this.entityType.getSimpleName() + " at " + path, (Throwable)ex);
                this.loadErrors.add(path);
            }
        }
        logger.debug("Loaded " + this.cache.size() + " " + this.entityType.getSimpleName() + "(s) out of " + entities.size() + " resource with " + this.loadErrors.size() + " errors");
    }

    public T reload(String resourceName) {
        return this.reloadAt(this.resourcePath(resourceName));
    }

    public T reloadQuietly(String resourceName) {
        return this.reloadQuietlyAt(this.resourcePath(resourceName));
    }

    private T reloadQuietlyAt(String path) {
        try {
            return this.reloadAt(path);
        }
        catch (Exception ex) {
            logger.error("Error loading " + this.entityType.getSimpleName() + " at " + path, (Throwable)ex);
            this.loadErrors.add(path);
            return null;
        }
    }

    public List<String> getLoadFailedEntities() {
        return this.loadErrors;
    }

    public T reloadAt(String path) {
        try {
            T entity = this.store.getResource(path, this.serializer);
            if (entity == null) {
                logger.warn("No " + this.entityType.getSimpleName() + " found at " + path + ", returning null");
                this.cache.removeLocal(this.resourceName(path));
                return null;
            }
            ((RootPersistentEntity)entity).setCachedAndShared(true);
            entity = this.initEntityAfterReload(entity, this.resourceName(path));
            if (!path.equals(this.resourcePath(((RootPersistentEntity)entity).resourceName()))) {
                throw new IllegalStateException("The entity " + entity + " read from " + path + " will save to a different path " + this.resourcePath(((RootPersistentEntity)entity).resourceName()));
            }
            this.cache.putLocal(((RootPersistentEntity)entity).resourceName(), entity);
            return entity;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error loading " + this.entityType.getSimpleName() + " at " + path, e);
        }
    }

    protected abstract T initEntityAfterReload(T var1, String var2);

    public T save(T entity) throws IOException {
        Preconditions.checkArgument(entity != null);
        this.completeUuidIfNeeded(entity);
        Preconditions.checkArgument(this.entityType.isInstance(entity));
        String resName = ((RootPersistentEntity)entity).resourceName();
        Preconditions.checkArgument(resName != null && resName.length() > 0);
        if (this.checkCopyOnWrite && (((RootPersistentEntity)entity).isCachedAndShared() || this.cache.get(resName) == entity)) {
            throw new IllegalStateException("Copy-on-write violation! The updating entity " + entity + " is a shared object in " + this.entityType.getSimpleName() + " cache, which should not be.");
        }
        String path = this.resourcePath(resName);
        logger.debug("Saving {} at {}", (Object)this.entityType.getSimpleName(), (Object)path);
        this.store.checkAndPutResource(path, entity, this.serializer);
        this.cache.put(resName, entity);
        return this.reload(resName);
    }

    private void completeUuidIfNeeded(T entity) {
        if (((RootPersistentEntity)entity).getUuid() == null) {
            ((RootPersistentEntity)entity).updateRandomUuid();
        }
    }

    public void delete(T entity) throws IOException {
        this.delete(((RootPersistentEntity)entity).resourceName());
    }

    public void delete(String resName) throws IOException {
        Preconditions.checkArgument(resName != null);
        String path = this.resourcePath(resName);
        logger.debug("Deleting {} at {}", (Object)this.entityType.getSimpleName(), (Object)path);
        this.store.deleteResource(path);
        this.cache.remove(resName);
    }
}

