/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.tapmessage;

import net.spy.memcached.tapmessage.RequestMessage;
import net.spy.memcached.tapmessage.TapMagic;
import net.spy.memcached.tapmessage.TapOpcode;
import net.spy.memcached.tapmessage.TapRequestFlag;

public class MessageBuilder {
    private RequestMessage message = new RequestMessage();

    public MessageBuilder() {
        this.message.setMagic(TapMagic.PROTOCOL_BINARY_REQ);
        this.message.setOpcode(TapOpcode.REQUEST);
    }

    public void doBackfill(long date) {
        this.message.setBackfill(date);
        this.message.setFlags(TapRequestFlag.BACKFILL);
    }

    public void doDump() {
        this.message.setFlags(TapRequestFlag.DUMP);
    }

    public void specifyVbuckets(short[] vbucketlist) {
        this.message.setVbucketlist(vbucketlist);
        this.message.setFlags(TapRequestFlag.LIST_VBUCKETS);
    }

    public void supportAck() {
        this.message.setFlags(TapRequestFlag.SUPPORT_ACK);
    }

    public void keysOnly() {
        this.message.setFlags(TapRequestFlag.KEYS_ONLY);
    }

    public void takeoverVbuckets(short[] vbucketlist) {
        this.message.setVbucketlist(vbucketlist);
        this.message.setFlags(TapRequestFlag.TAKEOVER_VBUCKETS);
    }

    public RequestMessage getMessage() {
        return this.message;
    }
}

