/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.SnapshotTableDesc;
import org.apache.kylin.engine.mr.ILookupMaterializer;
import org.apache.kylin.engine.mr.LookupMaterializeContext;
import org.apache.kylin.engine.mr.LookupSnapshotBuildJob;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.steps.lookup.LookupExecutableUtil;
import org.apache.kylin.engine.mr.steps.lookup.LookupSnapshotToMetaStoreStep;
import org.apache.kylin.engine.mr.steps.lookup.UpdateCubeAfterSnapshotStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupSnapshotJobBuilder {
    private static final Logger logger = LoggerFactory.getLogger(LookupSnapshotJobBuilder.class);
    private CubeInstance cube;
    private String lookupTable;
    private List<String> segments;
    private String submitter;
    private KylinConfig kylinConfig;

    public LookupSnapshotJobBuilder(CubeInstance cube, String lookupTable, List<String> segments, String submitter) {
        this.cube = cube;
        this.lookupTable = lookupTable;
        this.segments = segments;
        this.submitter = submitter;
        this.kylinConfig = cube.getConfig();
    }

    public LookupSnapshotBuildJob build() {
        logger.info("new job to build lookup snapshot:{} for cube:{}", (Object)this.lookupTable, (Object)this.cube.getName());
        LookupSnapshotBuildJob result = LookupSnapshotBuildJob.createJob(this.cube, this.lookupTable, this.submitter, this.kylinConfig);
        CubeDesc cubeDesc = this.cube.getDescriptor();
        SnapshotTableDesc snapshotTableDesc = cubeDesc.getSnapshotTableDesc(this.lookupTable);
        if (snapshotTableDesc != null && snapshotTableDesc.isExtSnapshotTable()) {
            this.addExtMaterializeLookupTableSteps(result, snapshotTableDesc);
        } else {
            this.addInMetaStoreMaterializeLookupTableSteps(result);
        }
        return result;
    }

    private void addExtMaterializeLookupTableSteps(LookupSnapshotBuildJob result, SnapshotTableDesc snapshotTableDesc) {
        LookupMaterializeContext lookupMaterializeContext = new LookupMaterializeContext(result);
        ILookupMaterializer materializer = MRUtil.getExtLookupMaterializer(snapshotTableDesc.getStorageType());
        materializer.materializeLookupTable(lookupMaterializeContext, this.cube, this.lookupTable);
        UpdateCubeAfterSnapshotStep afterSnapshotStep = new UpdateCubeAfterSnapshotStep();
        afterSnapshotStep.setName("Update Cube Info");
        afterSnapshotStep.getParams().put("extlookupsnapshots", lookupMaterializeContext.getAllLookupSnapshotsInString());
        LookupExecutableUtil.setCubeName(this.cube.getName(), afterSnapshotStep.getParams());
        LookupExecutableUtil.setLookupTableName(this.lookupTable, afterSnapshotStep.getParams());
        LookupExecutableUtil.setSegments(this.segments, afterSnapshotStep.getParams());
        LookupExecutableUtil.setJobID(result.getId(), afterSnapshotStep.getParams());
        result.addTask(afterSnapshotStep);
    }

    private void addInMetaStoreMaterializeLookupTableSteps(LookupSnapshotBuildJob result) {
        LookupSnapshotToMetaStoreStep lookupSnapshotToMetaStoreStep = new LookupSnapshotToMetaStoreStep();
        lookupSnapshotToMetaStoreStep.setName("Take Snapshot to Metadata Store");
        LookupExecutableUtil.setCubeName(this.cube.getName(), lookupSnapshotToMetaStoreStep.getParams());
        LookupExecutableUtil.setLookupTableName(this.lookupTable, lookupSnapshotToMetaStoreStep.getParams());
        LookupExecutableUtil.setSegments(this.segments, lookupSnapshotToMetaStoreStep.getParams());
        result.addTask(lookupSnapshotToMetaStoreStep);
    }
}

