/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.impl.curator;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;
import org.apache.curator.framework.recipes.leader.Participant;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.impl.threadpool.DefaultScheduler;
import org.apache.kylin.job.lock.MockJobLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorLeaderSelector
extends LeaderSelectorListenerAdapter
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(CuratorLeaderSelector.class);
    private final String name;
    private final LeaderSelector leaderSelector;
    private JobEngineConfig jobEngineConfig;
    private DefaultScheduler defaultScheduler = null;

    CuratorLeaderSelector(CuratorFramework client, String path, String name, JobEngineConfig jobEngineConfig) {
        this.name = name;
        this.leaderSelector = new LeaderSelector(client, path, this);
        this.leaderSelector.setId(name);
        this.leaderSelector.autoRequeue();
        this.jobEngineConfig = jobEngineConfig;
        this.defaultScheduler = DefaultScheduler.getInstance();
    }

    public Participant getLeader() {
        try {
            return this.leaderSelector.getLeader();
        }
        catch (Exception e) {
            logger.error("Can not get leader.", e);
            return new Participant("", false);
        }
    }

    public Set<Participant> getParticipants() {
        HashSet<Participant> r = new HashSet<Participant>();
        try {
            r.addAll(this.leaderSelector.getParticipants());
        }
        catch (Exception e) {
            logger.error("Can not get participants.", e);
        }
        return r;
    }

    public boolean hasDefaultSchedulerStarted() {
        return this.defaultScheduler.hasStarted();
    }

    public void start() throws IOException {
        this.leaderSelector.start();
    }

    public boolean hasLeadership() throws IOException {
        return this.leaderSelector.hasLeadership();
    }

    @Override
    public void close() throws IOException {
        try {
            this.leaderSelector.close();
        }
        catch (IllegalStateException e) {
            if (e.getMessage().equals("Already closed or has not been started")) {
                logger.warn("LeaderSelector already closed or has not been started");
            }
            throw e;
        }
        logger.info(this.name + " is stopped");
    }

    @Override
    public void takeLeadership(CuratorFramework client) throws Exception {
        logger.info(this.name + " is the leader for job engine now.");
        try {
            this.defaultScheduler.init(this.jobEngineConfig, new MockJobLock());
            while (true) {
                Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
            }
        }
        catch (InterruptedException ie) {
            logger.error(this.name + " was interrupted.", ie);
            logger.warn(this.name + " relinquishing leadership.");
            if (this.defaultScheduler != null) {
                this.defaultScheduler.shutdown();
            }
        }
        catch (Throwable th) {
            try {
                logger.error("Other exception occurred when initialization DefaultScheduler:", th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                logger.warn(this.name + " relinquishing leadership.");
                if (this.defaultScheduler != null) {
                    this.defaultScheduler.shutdown();
                }
            }
        }
    }
}

