/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.util.AutoReadWriteLock;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.cachesync.CaseInsensitiveStringCache;
import org.apache.kylin.metadata.model.ExternalFilterDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMetadataManager {
    private static final Logger logger = LoggerFactory.getLogger(TableMetadataManager.class);
    public static final Serializer<TableDesc> TABLE_SERIALIZER = new JsonSerializer<TableDesc>(TableDesc.class);
    private static final Serializer<TableExtDesc> TABLE_EXT_SERIALIZER = new JsonSerializer<TableExtDesc>(TableExtDesc.class);
    private KylinConfig config;
    private CaseInsensitiveStringCache<TableDesc> srcTableMap;
    private CachedCrudAssist<TableDesc> srcTableCrud;
    private AutoReadWriteLock srcTableMapLock = new AutoReadWriteLock();
    private CaseInsensitiveStringCache<TableExtDesc> srcExtMap;
    private CachedCrudAssist<TableExtDesc> srcExtCrud;
    private AutoReadWriteLock srcExtMapLock = new AutoReadWriteLock();
    private CaseInsensitiveStringCache<ExternalFilterDesc> extFilterMap;
    private CachedCrudAssist<ExternalFilterDesc> extFilterCrud;
    private AutoReadWriteLock extFilterMapLock = new AutoReadWriteLock();

    public static TableMetadataManager getInstance(KylinConfig config) {
        return config.getManager(TableMetadataManager.class);
    }

    static TableMetadataManager newInstance(KylinConfig config) throws IOException {
        return new TableMetadataManager(config);
    }

    private TableMetadataManager(KylinConfig cfg) throws IOException {
        this.config = cfg;
        this.initSrcTable();
        this.initSrcExt();
        this.initExtFilter();
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    public ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }

    private void initSrcTable() throws IOException {
        this.srcTableMap = new CaseInsensitiveStringCache(this.config, "table");
        this.srcTableCrud = new CachedCrudAssist<TableDesc>(this.getStore(), "/table", TableDesc.class, this.srcTableMap){

            @Override
            protected TableDesc initEntityAfterReload(TableDesc t, String resourceName) {
                String prj = TableDesc.parseResourcePath(resourceName).getProject();
                t.init(TableMetadataManager.this.config, prj);
                return t;
            }
        };
        this.srcTableCrud.reloadAll();
        Broadcaster.getInstance(this.config).registerListener(new SrcTableSyncListener(), "table");
    }

    public void reloadSourceTableQuietly(String table, String project) {
        try (AutoReadWriteLock.AutoLock lock = this.srcTableMapLock.lockForWrite();){
            this.srcTableCrud.reloadQuietly(TableDesc.makeResourceName(table, project));
        }
    }

    public List<TableDesc> listAllTables(String prj) {
        try (AutoReadWriteLock.AutoLock lock = this.srcTableMapLock.lockForWrite();){
            ArrayList<TableDesc> arrayList = Lists.newArrayList(this.getAllTablesMap(prj).values());
            return arrayList;
        }
    }

    public Map<String, TableDesc> getAllTablesMap(String prj) {
        ProjectInstance project = prj == null ? null : ProjectManager.getInstance(this.config).getProject(prj);
        try (AutoReadWriteLock.AutoLock lock = this.srcTableMapLock.lockForWrite();){
            if (prj == null) {
                LinkedHashMap<String, TableDesc> globalTables = new LinkedHashMap<String, TableDesc>();
                for (TableDesc t : this.srcTableMap.values()) {
                    globalTables.put(t.getIdentity(), t);
                }
                LinkedHashMap<String, TableDesc> linkedHashMap = globalTables;
                return linkedHashMap;
            }
            Set<String> prjTableNames = project.getTables();
            LinkedHashMap<String, TableDesc> ret = new LinkedHashMap<String, TableDesc>();
            for (String tableName : prjTableNames) {
                String tableIdentity = this.getTableIdentity(tableName);
                ret.put(tableIdentity, this.getProjectSpecificTableDesc(tableIdentity, prj, true));
            }
            LinkedHashMap<String, TableDesc> linkedHashMap = ret;
            return linkedHashMap;
        }
    }

    public TableDesc getTableDesc(String tableName, String prj) {
        return this.getTableDesc(tableName, prj, true);
    }

    public TableDesc getTableDesc(String tableName, String prj, boolean ifUseGlobal) {
        try (AutoReadWriteLock.AutoLock lock = this.srcTableMapLock.lockForWrite();){
            TableDesc tableDesc = this.getProjectSpecificTableDesc(this.getTableIdentity(tableName), prj, ifUseGlobal);
            return tableDesc;
        }
    }

    private TableDesc getProjectSpecificTableDesc(String fullTableName, String prj, boolean ifUseGlobal) {
        String key = this.mapKey(fullTableName, prj);
        TableDesc result = (TableDesc)this.srcTableMap.get(key);
        if (result == null && ifUseGlobal) {
            try (AutoReadWriteLock.AutoLock lock = this.srcTableMapLock.lockForWrite();){
                result = (TableDesc)this.srcTableMap.get(this.mapKey(fullTableName, null));
                if (result != null) {
                    result = new TableDesc(result);
                    result.setLastModified(0L);
                    result.setProject(prj);
                    result.setBorrowedFromGlobal(true);
                    this.srcTableMap.putLocal(key, result);
                }
            }
        }
        return result;
    }

    private String getTableIdentity(String tableName) {
        if (!tableName.contains(".")) {
            return "DEFAULT." + tableName.toUpperCase(Locale.ROOT);
        }
        return tableName.toUpperCase(Locale.ROOT);
    }

    public void saveSourceTable(TableDesc srcTable, String prj) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.srcTableMapLock.lockForWrite();){
            srcTable.init(this.config, prj);
            this.srcTableCrud.save(srcTable);
        }
    }

    public void removeSourceTable(String tableIdentity, String prj) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.srcTableMapLock.lockForWrite();){
            TableDesc t = this.getTableDesc(tableIdentity, prj);
            if (t == null) {
                return;
            }
            this.srcTableCrud.delete(t);
        }
    }

    public void resetProjectSpecificTableDesc(String prj) throws IOException {
        ProjectInstance project = ProjectManager.getInstance(this.config).getProject(prj);
        try (AutoReadWriteLock.AutoLock lock = this.srcTableMapLock.lockForWrite();){
            for (String tableName : project.getTables()) {
                String tableIdentity = this.getTableIdentity(tableName);
                String key = this.mapKey(tableIdentity, prj);
                TableDesc originTableDesc = (TableDesc)this.srcTableMap.get(key);
                if (originTableDesc == null) continue;
                if (originTableDesc.isBorrowedFromGlobal()) {
                    this.srcTableMap.removeLocal(key);
                    continue;
                }
                this.srcTableCrud.reload(key);
            }
        }
    }

    private String mapKey(String identity, String prj) {
        return TableDesc.makeResourceName(identity, prj);
    }

    private void initSrcExt() throws IOException {
        this.srcExtMap = new CaseInsensitiveStringCache(this.config, "table_ext");
        this.srcExtCrud = new CachedCrudAssist<TableExtDesc>(this.getStore(), "/table_exd", TableExtDesc.class, this.srcExtMap){

            @Override
            protected TableExtDesc initEntityAfterReload(TableExtDesc t, String resourceName) {
                if (t.getIdentity() == null) {
                    t = TableMetadataManager.this.convertOldTableExtToNewer(resourceName);
                }
                String prj = TableDesc.parseResourcePath(resourceName).getProject();
                t.init(prj);
                return t;
            }
        };
        this.srcExtCrud.reloadAll();
        Broadcaster.getInstance(this.config).registerListener(new SrcTableExtSyncListener(), "table_ext");
    }

    public void reloadTableExtQuietly(String table, String project) {
        try (AutoReadWriteLock.AutoLock lock = this.srcExtMapLock.lockForWrite();){
            this.srcExtCrud.reloadQuietly(TableDesc.makeResourceName(table, project));
        }
    }

    public TableExtDesc getTableExt(String tableName, String prj) {
        TableDesc t = this.getTableDesc(tableName, prj);
        if (t == null) {
            return null;
        }
        return this.getTableExt(t);
    }

    public TableExtDesc getTableExt(TableDesc t) {
        try (AutoReadWriteLock.AutoLock lock = this.srcExtMapLock.lockForRead();){
            TableExtDesc result = (TableExtDesc)this.srcExtMap.get(this.mapKey(t.getIdentity(), t.getProject()));
            if (null == result) {
                result = (TableExtDesc)this.srcExtMap.get(this.mapKey(t.getIdentity(), null));
            }
            if (null == result) {
                result = new TableExtDesc();
                result.setIdentity(t.getIdentity());
                result.setUuid(RandomUtil.randomUUID().toString());
                result.setLastModified(0L);
                result.init(t.getProject());
                this.srcExtMap.putLocal(this.mapKey(t.getIdentity(), t.getProject()), result);
            }
            TableExtDesc tableExtDesc = result;
            return tableExtDesc;
        }
    }

    public void saveTableExt(TableExtDesc tableExt, String prj) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.srcExtMapLock.lockForWrite();){
            if (tableExt.getUuid() == null || tableExt.getIdentity() == null) {
                throw new IllegalArgumentException();
            }
            if (tableExt.getProject() == null) {
                if (this.getTableExt(tableExt.getIdentity(), prj).getProject() != null) {
                    throw new IllegalStateException("Updating a legacy global TableExtDesc while a project level version exists: " + tableExt.getIdentity() + ", " + prj);
                }
                prj = tableExt.getProject();
            }
            tableExt.init(prj);
            String path = TableExtDesc.concatResourcePath(tableExt.getIdentity(), prj);
            ResourceStore store = this.getStore();
            TableExtDesc t = store.getResource(path, TABLE_EXT_SERIALIZER);
            if (t != null && t.getIdentity() == null) {
                store.deleteResource(path);
            }
            this.srcExtCrud.save(tableExt);
        }
    }

    public void removeTableExt(String tableName, String prj) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.srcExtMapLock.lockForWrite();){
            TableExtDesc t = this.getTableExt(tableName, prj);
            if (t == null) {
                return;
            }
            this.srcExtCrud.delete(t);
        }
    }

    public void saveNewTableExtFromOld(String oldTableId, String prj, String newTableId) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.srcExtMapLock.lockForWrite();){
            String path = TableExtDesc.concatResourcePath(oldTableId, prj);
            ResourceStore store = this.getStore();
            TableExtDesc newTableExt = store.getResource(path, TABLE_EXT_SERIALIZER);
            if (newTableExt != null) {
                newTableExt.setIdentity(newTableId);
                newTableExt.setLastModified(0L);
                newTableExt.init(prj);
                this.srcExtCrud.save(newTableExt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableExtDesc convertOldTableExtToNewer(String resourceName) {
        ResourceStore store = this.getStore();
        HashMap attrs = Maps.newHashMap();
        try {
            RawResource res = store.getResource("/table_exd/" + resourceName + ".json");
            try (InputStream is = res.content();){
                attrs.putAll(JsonUtil.readValue(is, HashMap.class));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        String cardinality = (String)attrs.get("cardinality");
        String tableIdentity = TableDesc.parseResourcePath(resourceName).getTable();
        TableExtDesc result = new TableExtDesc();
        result.setIdentity(tableIdentity);
        result.setUuid(RandomUtil.randomUUID().toString());
        result.setLastModified(0L);
        result.setCardinality(cardinality);
        return result;
    }

    private void initExtFilter() throws IOException {
        this.extFilterMap = new CaseInsensitiveStringCache(this.config, "external_filter");
        this.extFilterCrud = new CachedCrudAssist<ExternalFilterDesc>(this.getStore(), "/ext_filter", ExternalFilterDesc.class, this.extFilterMap){

            @Override
            protected ExternalFilterDesc initEntityAfterReload(ExternalFilterDesc t, String resourceName) {
                return t;
            }
        };
        this.extFilterCrud.reloadAll();
        Broadcaster.getInstance(this.config).registerListener(new ExtFilterSyncListener(), "external_filter");
    }

    public List<ExternalFilterDesc> listAllExternalFilters() {
        try (AutoReadWriteLock.AutoLock lock = this.extFilterMapLock.lockForRead();){
            ArrayList<ExternalFilterDesc> arrayList = Lists.newArrayList(this.extFilterMap.values());
            return arrayList;
        }
    }

    public ExternalFilterDesc getExtFilterDesc(String filterTableName) {
        try (AutoReadWriteLock.AutoLock lock = this.extFilterMapLock.lockForRead();){
            ExternalFilterDesc result;
            ExternalFilterDesc externalFilterDesc = result = (ExternalFilterDesc)this.extFilterMap.get(filterTableName);
            return externalFilterDesc;
        }
    }

    public void saveExternalFilter(ExternalFilterDesc desc) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.extFilterMapLock.lockForWrite();){
            this.extFilterCrud.save(desc);
        }
    }

    public void removeExternalFilter(String name) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.extFilterMapLock.lockForWrite();){
            name = name.replaceAll("[./]", "");
            this.extFilterCrud.delete(name);
        }
    }

    private class ExtFilterSyncListener
    extends Broadcaster.Listener {
        private ExtFilterSyncListener() {
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            try (AutoReadWriteLock.AutoLock lock = TableMetadataManager.this.extFilterMapLock.lockForWrite();){
                if (event == Broadcaster.Event.DROP) {
                    TableMetadataManager.this.extFilterMap.removeLocal(cacheKey);
                } else {
                    TableMetadataManager.this.extFilterCrud.reloadQuietly(cacheKey);
                }
            }
        }
    }

    private class SrcTableExtSyncListener
    extends Broadcaster.Listener {
        private SrcTableExtSyncListener() {
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            try (AutoReadWriteLock.AutoLock lock = TableMetadataManager.this.srcExtMapLock.lockForWrite();){
                if (event == Broadcaster.Event.DROP) {
                    TableMetadataManager.this.srcExtMap.removeLocal(cacheKey);
                } else {
                    TableMetadataManager.this.srcExtCrud.reloadQuietly(cacheKey);
                }
            }
        }
    }

    private class SrcTableSyncListener
    extends Broadcaster.Listener {
        private SrcTableSyncListener() {
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            try (AutoReadWriteLock.AutoLock lock = TableMetadataManager.this.srcTableMapLock.lockForWrite();){
                if (event == Broadcaster.Event.DROP) {
                    TableMetadataManager.this.srcTableMap.removeLocal(cacheKey);
                } else {
                    TableMetadataManager.this.srcTableCrud.reloadQuietly(cacheKey);
                }
            }
            TableDesc.TableProject tableProject = TableDesc.parseResourcePath(cacheKey);
            String table = tableProject.getTable();
            String prj = tableProject.getProject();
            if (prj == null) {
                for (ProjectInstance p : ProjectManager.getInstance(TableMetadataManager.this.config).findProjectsByTable(table)) {
                    broadcaster.notifyProjectSchemaUpdate(p.getName());
                }
            } else {
                broadcaster.notifyProjectSchemaUpdate(prj);
            }
        }
    }
}

