/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Maps;

public class TableRef
implements Serializable {
    private final transient DataModelDesc model;
    private final String alias;
    private final TableDesc table;
    private final Map<String, TblColRef> columns;
    private final String modelName;

    TableRef(DataModelDesc model, String alias, TableDesc table, boolean filterOutComputedColumns) {
        this.model = model;
        this.modelName = model.getName();
        this.alias = alias;
        this.table = table;
        this.columns = Maps.newLinkedHashMap();
        for (ColumnDesc col : table.getColumns()) {
            if (filterOutComputedColumns && col.isComputedColumn()) continue;
            this.columns.put(col.getName(), new TblColRef(this, col));
        }
    }

    public DataModelDesc getModel() {
        return this.model;
    }

    public String getAlias() {
        return this.alias;
    }

    public TableDesc getTableDesc() {
        return this.table;
    }

    public String getTableName() {
        return this.table.getName();
    }

    public String getTableIdentity() {
        return this.table.getIdentity();
    }

    public TblColRef getColumn(String name) {
        return this.columns.get(name);
    }

    public Collection<TblColRef> getColumns() {
        return Collections.unmodifiableCollection(this.columns.values());
    }

    @Deprecated
    public TblColRef makeFakeColumn(String name) {
        ColumnDesc colDesc = new ColumnDesc();
        colDesc.setName(name);
        colDesc.setTable(this.table);
        return new TblColRef(this, colDesc);
    }

    @Deprecated
    public TblColRef makeFakeColumn(ColumnDesc colDesc) {
        return new TblColRef(this, colDesc);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableRef t = (TableRef)o;
        if (!(this.modelName == null ? t.modelName != null : this.modelName.equals(t.modelName))) {
            return false;
        }
        if (!(this.alias == null ? t.alias == null : this.alias.equals(t.alias))) {
            return false;
        }
        return this.table.getIdentity().equals(t.table.getIdentity());
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + this.modelName.hashCode();
        result = 31 * result + this.alias.hashCode();
        result = 31 * result + this.table.getIdentity().hashCode();
        return result;
    }

    public String toString() {
        if (this.alias.equals(this.table.getName())) {
            return "TableRef[" + this.table.getName() + "]";
        }
        return "TableRef[" + this.alias + ":" + this.table.getName() + "]";
    }
}

