/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPTableScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface OLAPRel
extends RelNode {
    public static final Logger logger = LoggerFactory.getLogger(OLAPRel.class);
    public static final Convention CONVENTION = new Convention.Impl("OLAP", OLAPRel.class);

    public OLAPContext getContext();

    public ColumnRowType getColumnRowType();

    public boolean hasSubQuery();

    public RelTraitSet replaceTraitSet(RelTrait var1);

    public void implementOLAP(OLAPImplementor var1);

    public void implementRewrite(RewriteImplementor var1);

    public EnumerableRel implementEnumerable(List<EnumerableRel> var1);

    public static class JavaImplementor
    extends EnumerableRelImplementor {
        private IdentityHashMap<EnumerableRel, OLAPContext> relContexts = Maps.newIdentityHashMap();
        private boolean calciteDebug = System.getProperty("calcite.debug") != null;

        public JavaImplementor(EnumerableRelImplementor enumImplementor) {
            super(enumImplementor.getRexBuilder(), new LinkedHashMap<String, Object>());
        }

        public EnumerableRel createEnumerable(OLAPRel parent) {
            ArrayList<EnumerableRel> enumInputs = null;
            List<RelNode> children = parent.getInputs();
            if (children != null) {
                enumInputs = Lists.newArrayListWithCapacity(children.size());
                for (RelNode child : children) {
                    enumInputs.add(this.createEnumerable((OLAPRel)child));
                }
            }
            EnumerableRel result = parent.implementEnumerable(enumInputs);
            this.relContexts.put(result, parent.getContext());
            return result;
        }

        @Override
        public EnumerableRel.Result visitChild(EnumerableRel parent, int ordinal, EnumerableRel child, EnumerableRel.Prefer prefer) {
            if (this.calciteDebug) {
                OLAPContext context = child instanceof OLAPRel ? ((OLAPRel)((Object)child)).getContext() : this.relContexts.get(child);
                System.out.println(context + " - " + child);
            }
            return super.visitChild(parent, ordinal, child, prefer);
        }
    }

    public static class RewriteImplementor {
        private OLAPContext parentContext;

        public void visitChild(RelNode parent, RelNode child) {
            if (parent instanceof OLAPRel) {
                OLAPRel olapRel = (OLAPRel)parent;
                this.parentContext = olapRel.getContext();
            }
            OLAPRel olapChild = (OLAPRel)child;
            olapChild.implementRewrite(this);
        }

        public OLAPContext getParentContext() {
            return this.parentContext;
        }

        public static boolean needRewrite(OLAPContext ctx) {
            if (ctx.hasJoin) {
                return true;
            }
            if (ctx.realization == null) {
                return false;
            }
            String realRootFact = ctx.realization.getModel().getRootFactTable().getTableIdentity();
            return ctx.firstTableScan.getTableName().equals(realRootFact);
        }
    }

    public static class OLAPImplementor {
        private Stack<RelNode> parentNodeStack = new Stack();
        private int ctxSeq = 0;
        private Stack<OLAPContext> ctxStack = new Stack();
        private boolean newOLAPContextRequired = false;

        public void visitChild(RelNode input, RelNode parentNode) {
            this.parentNodeStack.push(parentNode);
            ((OLAPRel)input).implementOLAP(this);
            this.parentNodeStack.pop();
        }

        public RelNode getParentNode() {
            return this.parentNodeStack.peek();
        }

        public Stack<RelNode> getParentNodeStack() {
            return this.parentNodeStack;
        }

        public OLAPContext getContext() {
            if (this.ctxStack.isEmpty()) {
                return null;
            }
            return this.ctxStack.peek();
        }

        public void freeContext() {
            this.ctxStack.pop();
        }

        public void allocateContext() {
            OLAPContext context = new OLAPContext(this.ctxSeq++);
            if (!this.ctxStack.isEmpty()) {
                this.ctxStack.peek().disableLimitPushdown = true;
                context.disableLimitPushdown = true;
            }
            this.ctxStack.push(context);
            OLAPContext.registerContext(context);
            this.setNewOLAPContextRequired(false);
        }

        public void setNewOLAPContextRequired(boolean newOLAPContextRequired) {
            this.newOLAPContextRequired = newOLAPContextRequired;
        }

        public boolean isNewOLAPContextRequired() {
            return this.newOLAPContextRequired;
        }

        public void fixSharedOlapTableScan(SingleRel parent) {
            OLAPTableScan copy = this.copyTableScanIfNeeded(parent.getInput());
            if (copy != null) {
                parent.replaceInput(0, copy);
            }
        }

        public void fixSharedOlapTableScanOnTheLeft(BiRel parent) {
            OLAPTableScan copy = this.copyTableScanIfNeeded(parent.getLeft());
            if (copy != null) {
                parent.replaceInput(0, copy);
            }
        }

        public void fixSharedOlapTableScanOnTheRight(BiRel parent) {
            OLAPTableScan copy = this.copyTableScanIfNeeded(parent.getRight());
            if (copy != null) {
                parent.replaceInput(1, copy);
            }
        }

        public void fixSharedOlapTableScanAt(RelNode parent, int ordinalInParent) {
            OLAPTableScan copy = this.copyTableScanIfNeeded(parent.getInputs().get(ordinalInParent));
            if (copy != null) {
                parent.replaceInput(ordinalInParent, copy);
            }
        }

        private OLAPTableScan copyTableScanIfNeeded(RelNode input) {
            OLAPTableScan tableScan;
            if (input instanceof OLAPTableScan && (tableScan = (OLAPTableScan)input).getColumnRowType() != null) {
                OLAPTableScan copy = (OLAPTableScan)tableScan.copy(tableScan.getTraitSet(), tableScan.getInputs());
                return copy;
            }
            return null;
        }
    }
}

