/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.adaptor;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.rowset.CachedRowSet;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.sdk.datasource.adaptor.AdaptorConfig;
import org.apache.kylin.sdk.datasource.adaptor.DefaultAdaptor;

public class PrestoAdaptor
extends DefaultAdaptor {
    private Pattern patternASYM = Pattern.compile("BETWEEN(\\s*)ASYMMETRIC");
    private Pattern patternSYM = Pattern.compile("BETWEEN(\\s*)SYMMETRIC");
    private Pattern patternTrim = Pattern.compile("TRIM\\(.*BOTH.*FROM\\s+(.+)\\)");
    private Pattern patternOffset = Pattern.compile("(?i)OFFSET\\s\\d+");

    public PrestoAdaptor(AdaptorConfig config) throws Exception {
        super(config);
    }

    @Override
    public String fixSql(String sql) {
        sql = this.resolveBetweenAsymmetricSymmetric(sql);
        sql = this.convertTrim(sql);
        sql = this.convertOffset(sql);
        return sql;
    }

    @Override
    public int toKylinTypeId(String type, int typeId) {
        if (2000 == typeId) {
            return 3;
        }
        if (-16 == typeId) {
            return 12;
        }
        if (-1 == typeId) {
            return 12;
        }
        return typeId;
    }

    @Override
    public String toKylinTypeName(int sourceTypeId) {
        String result = "any";
        logger.info("table schema info :" + sourceTypeId);
        switch (sourceTypeId) {
            case 1: {
                result = "char";
                break;
            }
            case 12: {
                result = "varchar";
                break;
            }
            case -9: {
                result = "varchar";
                break;
            }
            case -1: {
                result = "varchar";
                break;
            }
            case -16: {
                result = "varchar";
                break;
            }
            case 2: {
                result = "decimal";
                break;
            }
            case 3: {
                result = "decimal";
                break;
            }
            case -7: 
            case 16: {
                result = "boolean";
                break;
            }
            case -6: {
                result = "tinyint";
                break;
            }
            case 5: {
                result = "smallint";
                break;
            }
            case 4: {
                result = "integer";
                break;
            }
            case -5: {
                result = "bigint";
                break;
            }
            case 7: {
                result = "real";
                break;
            }
            case 6: {
                result = "real";
                break;
            }
            case 8: {
                result = "double";
                break;
            }
            case -2: {
                result = "VARBINARY";
                break;
            }
            case -3: {
                result = "VARBINARY";
                break;
            }
            case -4: {
                result = "char";
                break;
            }
            case 91: {
                result = "date";
                break;
            }
            case 92: {
                result = "time";
                break;
            }
            case 93: {
                result = "timestamp";
                break;
            }
        }
        return result;
    }

    private String resolveBetweenAsymmetricSymmetric(String sql) {
        String sqlReturn = sql;
        Matcher matcher = this.patternASYM.matcher(sql);
        if (matcher.find()) {
            sqlReturn = sql.replace(matcher.group(), "BETWEEN");
        }
        if ((matcher = this.patternSYM.matcher(sql)).find()) {
            sqlReturn = sqlReturn.replace(matcher.group(), "BETWEEN");
        }
        return sqlReturn;
    }

    private String convertTrim(String sql) {
        String sqlReturn = sql;
        Matcher matcher = this.patternTrim.matcher(sql);
        boolean isFind = matcher.find();
        if (isFind) {
            String originStr = matcher.group(0);
            String fixStr = "TRIM(" + matcher.group(1) + ")";
            sqlReturn = sqlReturn.replace(originStr, fixStr);
        }
        return sqlReturn;
    }

    private String convertOffset(String sql) {
        String sqlReturn = sql;
        Matcher matcher = this.patternOffset.matcher(sqlReturn);
        while (matcher.find()) {
            String originStr = matcher.group(0);
            sqlReturn = sqlReturn.replaceFirst(originStr, " ");
        }
        return sqlReturn;
    }

    @Override
    public List<String> listTables(String schema) throws SQLException {
        ArrayList<String> ret = new ArrayList<String>();
        try (Connection conn = this.getConnection();
             ResultSet rs = conn.getMetaData().getTables(null, schema, null, null);){
            while (rs.next()) {
                String name = rs.getString("TABLE_NAME");
                if (!StringUtils.isNotBlank((String)name)) continue;
                ret.add(name);
            }
        }
        return ret;
    }

    /*
     * Exception decompiling
     */
    @Override
    public CachedRowSet getTable(String schema, String table) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public CachedRowSet getTableColumns(String schema, String table) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

