/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar;

import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.dimension.TimeDerivedColumnType;

public class TimeDerivedColumnEncoding {
    private String columnName;
    private TimeDerivedColumnType timeColumnType;
    private long baseTime;
    private long normalizedBaseTime;

    public TimeDerivedColumnEncoding(String columnName, long baseTime) {
        this.columnName = columnName;
        this.baseTime = baseTime;
        this.timeColumnType = TimeDerivedColumnType.getTimeDerivedColumnType(columnName);
        this.normalizedBaseTime = this.timeColumnType.normalize(baseTime);
    }

    public void encode(String value, byte[] output, int outputOffset) {
        long timeVal = DateFormat.stringToMillis(value);
        this.timeColumnType.calculateTimeUnitRange(timeVal);
    }
}

