/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.source.kafka;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.shaded.com.google.common.base.Function;
import org.apache.kylin.shaded.com.google.common.collect.FluentIterable;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.MapDifference;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.stream.core.consumer.ConsumerStartMode;
import org.apache.kylin.stream.core.consumer.ConsumerStartProtocol;
import org.apache.kylin.stream.core.consumer.IStreamingConnector;
import org.apache.kylin.stream.core.exception.StreamingException;
import org.apache.kylin.stream.core.source.ISourcePosition;
import org.apache.kylin.stream.core.source.ISourcePositionHandler;
import org.apache.kylin.stream.core.source.IStreamingMessageParser;
import org.apache.kylin.stream.core.source.IStreamingSource;
import org.apache.kylin.stream.core.source.MessageParserInfo;
import org.apache.kylin.stream.core.source.Partition;
import org.apache.kylin.stream.core.source.StreamingSourceConfig;
import org.apache.kylin.stream.core.source.StreamingSourceConfigManager;
import org.apache.kylin.stream.core.source.StreamingSourceFactory;
import org.apache.kylin.stream.core.source.StreamingTableSourceInfo;
import org.apache.kylin.stream.core.storage.StreamingSegmentManager;
import org.apache.kylin.stream.source.kafka.KafkaPosition;
import org.apache.kylin.stream.source.kafka.KafkaPositionHandler;
import org.apache.kylin.stream.source.kafka.consumer.KafkaConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSource
implements IStreamingSource {
    public static final String PROP_TOPIC = "topic";
    public static final String PROP_BOOTSTRAP_SERVERS = "bootstrap.servers";
    public static final String PROP_MESSAGE_PARSER = "message.parser";
    private static final Logger logger = LoggerFactory.getLogger(KafkaSource.class);
    private static final String DEF_MSSAGE_PARSER_CLAZZ = "org.apache.kylin.stream.source.kafka.TimedJsonStreamParser";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamingTableSourceInfo load(String cubeName) {
        KylinConfig kylinConf = KylinConfig.getInstanceFromEnv();
        CubeInstance cube = CubeManager.getInstance(kylinConf).getCube(cubeName);
        String streamingTableName = cube.getRootFactTable();
        String projectName = cube.getProject();
        StreamingSourceConfig streamingSourceConfig = StreamingSourceConfigManager.getInstance(kylinConf).getConfig(streamingTableName, projectName);
        String topicName = KafkaSource.getTopicName(streamingSourceConfig.getProperties());
        Map<String, Object> conf = KafkaSource.getKafkaConf(streamingSourceConfig.getProperties(), cube.getConfig());
        try (KafkaConsumer kafkaConsumer = new KafkaConsumer(conf);){
            List partitionInfos = kafkaConsumer.partitionsFor(topicName);
            List<Partition> kafkaPartitions = Lists.transform(partitionInfos, new Function<PartitionInfo, Partition>(){

                @Override
                @Nullable
                public Partition apply(@Nullable PartitionInfo input) {
                    return new Partition(input.partition());
                }
            });
            StreamingTableSourceInfo streamingTableSourceInfo = new StreamingTableSourceInfo(kafkaPartitions);
            return streamingTableSourceInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMessageTemplate(StreamingSourceConfig streamingSourceConfig) {
        String template = null;
        try (KafkaConsumer consumer = null;){
            String topicName = KafkaSource.getTopicName(streamingSourceConfig.getProperties());
            Map<String, Object> config = KafkaSource.getKafkaConf(streamingSourceConfig.getProperties());
            consumer = new KafkaConsumer(config);
            HashSet<TopicPartition> partitions = Sets.newHashSet(FluentIterable.from(consumer.partitionsFor(topicName)).transform(new Function<PartitionInfo, TopicPartition>(){

                @Override
                public TopicPartition apply(PartitionInfo input) {
                    return new TopicPartition(input.topic(), input.partition());
                }
            }));
            consumer.assign(partitions);
            consumer.seekToBeginning(partitions);
            ConsumerRecords records = consumer.poll(500L);
            if (records == null) {
                String string = null;
                return string;
            }
            Iterator iterator = records.iterator();
            if (iterator == null || !iterator.hasNext()) {
                String string = null;
                return string;
            }
            ConsumerRecord record = (ConsumerRecord)iterator.next();
            template = new String((byte[])record.value(), "UTF8");
        }
        return template;
    }

    @Override
    public IStreamingConnector createStreamingConnector(String cubeName, List<Partition> assignedPartitions, ConsumerStartProtocol startProtocol, StreamingSegmentManager streamingSegmentManager) {
        logger.info("Create StreamingConnector for Cube {}, assignedPartitions {}, startProtocol {}", cubeName, assignedPartitions, startProtocol);
        try {
            KylinConfig kylinConf = KylinConfig.getInstanceFromEnv();
            CubeInstance cubeInstance = CubeManager.getInstance(kylinConf).getCube(cubeName);
            IStreamingSource streamingSource = StreamingSourceFactory.getStreamingSource(cubeInstance);
            String streamingName = cubeInstance.getRootFactTable();
            String projectName = cubeInstance.getProject();
            StreamingSourceConfig streamingSourceConfig = StreamingSourceConfigManager.getInstance(kylinConf).getConfig(streamingName, projectName);
            String topic = KafkaSource.getTopicName(streamingSourceConfig.getProperties());
            Map<String, Object> conf = KafkaSource.getKafkaConf(streamingSourceConfig.getProperties(), cubeInstance.getConfig());
            Class<?> clazz = KafkaSource.getStreamingMessageParserClass(streamingSourceConfig.getProperties());
            Constructor<?> constructor = clazz.getConstructor(CubeDesc.class, MessageParserInfo.class);
            IStreamingMessageParser parser = (IStreamingMessageParser)constructor.newInstance(cubeInstance.getDescriptor(), streamingSourceConfig.getParserInfo());
            KafkaConnector connector = new KafkaConnector(conf, topic, parser, this);
            if (startProtocol != null) {
                if (startProtocol.getStartPosition() != null && startProtocol.getStartPosition().length() > 0) {
                    KafkaPosition position = (KafkaPosition)streamingSource.getSourcePositionHandler().parsePosition(startProtocol.getStartPosition());
                    connector.setStartPartition(assignedPartitions, startProtocol.getStartMode(), position.getPartitionOffsets());
                    streamingSegmentManager.restoreConsumerStates(position);
                } else {
                    connector.setStartPartition(assignedPartitions, startProtocol.getStartMode(), null);
                }
                streamingSegmentManager.checkpoint();
            } else if (streamingSegmentManager != null) {
                this.setupConnectorFromCheckpoint(connector, assignedPartitions, streamingSource, streamingSegmentManager);
            }
            return connector;
        }
        catch (Exception e) {
            throw new StreamingException("streaming connector create fail, cube:" + cubeName, e);
        }
    }

    @Override
    public ISourcePositionHandler getSourcePositionHandler() {
        return new KafkaPositionHandler();
    }

    private void setupConnectorFromCheckpoint(KafkaConnector connector, List<Partition> assignedPartitions, IStreamingSource streamingSource, StreamingSegmentManager cubeDataStore) {
        KafkaPosition consumerStartPos;
        CubeInstance cubeInstance = cubeDataStore.getCubeInstance();
        CubeSegment latestReadySegment = cubeInstance.getLatestReadySegment();
        String localCheckpointConsumePos = cubeDataStore.getCheckPointSourcePosition();
        String remoteCheckpointConsumePos = null;
        if (latestReadySegment != null) {
            remoteCheckpointConsumePos = latestReadySegment.getStreamSourceCheckpoint();
        }
        logger.info("localConsumeStats from local checkpoint {}, remoteConsumeStats from remote checkpoint {} ", (Object)localCheckpointConsumePos, (Object)remoteCheckpointConsumePos);
        KafkaPosition localCPPosition = null;
        KafkaPosition remoteCPPosition = null;
        if (localCheckpointConsumePos != null) {
            localCPPosition = (KafkaPosition)streamingSource.getSourcePositionHandler().parsePosition(localCheckpointConsumePos);
        }
        if (remoteCheckpointConsumePos != null) {
            remoteCPPosition = (KafkaPosition)streamingSource.getSourcePositionHandler().parsePosition(remoteCheckpointConsumePos);
        }
        if (this.isEmptyPosition(localCPPosition) && this.isEmptyPosition(remoteCPPosition)) {
            if (cubeInstance.getSegments().isEmpty() && cubeInstance.getConfig().isStreamingConsumeFromLatestOffsets()) {
                logger.info("start kafka connector from latest");
                connector.setStartPartition(assignedPartitions, ConsumerStartMode.LATEST, null);
            } else {
                logger.info("start kafka connector from earliest");
                connector.setStartPartition(assignedPartitions, ConsumerStartMode.EARLIEST, null);
            }
            return;
        }
        if (this.isEmptyPosition(localCPPosition) && !this.isEmptyPosition(remoteCPPosition)) {
            consumerStartPos = remoteCPPosition;
        } else if (this.isEmptyPosition(remoteCPPosition) && !this.isEmptyPosition(localCPPosition)) {
            consumerStartPos = (KafkaPosition)localCPPosition.advance();
        } else {
            HashMap<Integer, Long> mergedStartOffsets = Maps.newHashMap();
            MapDifference<Integer, Long> statsDiff = Maps.difference(localCPPosition.getPartitionOffsets(), remoteCPPosition.getPartitionOffsets());
            mergedStartOffsets.putAll(statsDiff.entriesInCommon());
            mergedStartOffsets.putAll(statsDiff.entriesOnlyOnLeft());
            mergedStartOffsets.putAll(statsDiff.entriesOnlyOnRight());
            mergedStartOffsets.putAll(Maps.transformValues(statsDiff.entriesDiffering(), new Function<MapDifference.ValueDifference<Long>, Long>(){

                @Override
                @Nullable
                public Long apply(@Nullable MapDifference.ValueDifference<Long> input) {
                    return input.leftValue() > input.rightValue() ? input.leftValue() : input.rightValue();
                }
            }));
            consumerStartPos = new KafkaPosition(mergedStartOffsets);
        }
        logger.info("start kafka connector from specified position:{}", (Object)consumerStartPos);
        connector.setStartPartition(assignedPartitions, ConsumerStartMode.SPECIFIC_POSITION, consumerStartPos.getPartitionOffsets());
    }

    private boolean isEmptyPosition(KafkaPosition kafkaPosition) {
        return kafkaPosition == null || kafkaPosition.getPartitionOffsets().isEmpty();
    }

    public static Map<String, Object> getKafkaConf(Map<String, String> sourceProperties, KylinConfig kylinConfig) {
        Map<String, String> kafkaConfigOverride = kylinConfig.getKafkaConfigOverride();
        Map<String, Object> kafkaConf = KafkaSource.getKafkaConf(sourceProperties);
        kafkaConf.putAll(kafkaConfigOverride);
        return kafkaConf;
    }

    public static Map<String, Object> getKafkaConf(Map<String, String> sourceProperties) {
        HashMap<String, Object> conf = Maps.newHashMap();
        String bootstrapServersString = KafkaSource.getBootstrapServers(sourceProperties);
        conf.put(PROP_BOOTSTRAP_SERVERS, bootstrapServersString);
        conf.put("enable.auto.commit", "false");
        conf.put("session.timeout.ms", String.valueOf(20000));
        conf.put("request.timeout.ms", String.valueOf(30000));
        conf.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        conf.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        return conf;
    }

    public static String getBootstrapServers(Map<String, String> sourceProperties) {
        return sourceProperties.get(PROP_BOOTSTRAP_SERVERS);
    }

    public static String getTopicName(Map<String, String> sourceProperties) {
        return sourceProperties.get(PROP_TOPIC);
    }

    public static Class<?> getStreamingMessageParserClass(Map<String, String> sourceProperties) throws ClassNotFoundException {
        String parserName = sourceProperties.get(PROP_MESSAGE_PARSER);
        String parserClazzName = DEF_MSSAGE_PARSER_CLAZZ;
        if (parserName != null) {
            parserClazzName = KafkaSource.getParserClassName(parserName);
        }
        return Class.forName(parserClazzName);
    }

    public static String getParserClassName(String parser) {
        return parser;
    }

    private ISourcePosition getLatestPosition(String cubeName) {
        KylinConfig kylinConf = KylinConfig.getInstanceFromEnv();
        CubeInstance cube = CubeManager.getInstance(kylinConf).getCube(cubeName);
        String streamingTableName = cube.getRootFactTable();
        StreamingSourceConfig streamingSourceConfig = StreamingSourceConfigManager.getInstance(kylinConf).getConfig(streamingTableName, cube.getProject());
        String topicName = KafkaSource.getTopicName(streamingSourceConfig.getProperties());
        KafkaPosition sourcePosition = new KafkaPosition();
        Map<String, Object> conf = KafkaSource.getKafkaConf(streamingSourceConfig.getProperties(), cube.getConfig());
        try (KafkaConsumer consumer = new KafkaConsumer(conf);){
            HashSet<TopicPartition> partitions = Sets.newHashSet(FluentIterable.from(consumer.partitionsFor(topicName)).transform(new Function<PartitionInfo, TopicPartition>(){

                @Override
                public TopicPartition apply(PartitionInfo input) {
                    return new TopicPartition(input.topic(), input.partition());
                }
            }));
            Map lastestEventOffset = consumer.endOffsets(partitions);
            for (Map.Entry entry : lastestEventOffset.entrySet()) {
                KafkaPosition.KafkaPartitionPosition partitionPosition = new KafkaPosition.KafkaPartitionPosition(((TopicPartition)entry.getKey()).partition(), (Long)entry.getValue());
                sourcePosition.update(partitionPosition);
            }
        }
        return sourcePosition;
    }

    @Override
    public Map<Integer, Long> calConsumeLag(String cubeName, ISourcePosition currentPosition) {
        ISourcePosition latestPosition = this.getLatestPosition(cubeName);
        HashMap<Integer, Long> consumeLag = Maps.newHashMap();
        for (ISourcePosition.IPartitionPosition partitionPosition : currentPosition.getPartitionPositions().values()) {
            long current = ((KafkaPosition.KafkaPartitionPosition)partitionPosition).offset;
            ISourcePosition.IPartitionPosition latestPartition = latestPosition.getPartitionPositions().get(partitionPosition.getPartition());
            if (latestPartition == null) continue;
            long diff = ((KafkaPosition.KafkaPartitionPosition)latestPartition).offset - current;
            consumeLag.put(partitionPosition.getPartition(), diff);
        }
        return consumeLag;
    }
}

