/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit4.rules;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kylin.job.shaded.org.apache.commons.logging.Log;
import org.apache.kylin.job.shaded.org.apache.commons.logging.LogFactory;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.junit4.rules.SpringMethodRule;
import org.springframework.test.context.junit4.statements.ProfileValueChecker;
import org.springframework.test.context.junit4.statements.RunAfterTestClassCallbacks;
import org.springframework.test.context.junit4.statements.RunBeforeTestClassCallbacks;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class SpringClassRule
implements TestRule {
    private static final Log logger = LogFactory.getLog(SpringClassRule.class);
    private static final Map<Class<?>, TestContextManager> testContextManagerCache = new ConcurrentHashMap(64);

    public Statement apply(Statement base, Description description) {
        Class testClass = description.getTestClass();
        if (logger.isDebugEnabled()) {
            logger.debug("Applying SpringClassRule to test class [" + testClass.getName() + "]");
        }
        SpringClassRule.validateSpringMethodRuleConfiguration(testClass);
        TestContextManager testContextManager = SpringClassRule.getTestContextManager(testClass);
        Statement statement = base;
        statement = this.withBeforeTestClassCallbacks(statement, testContextManager);
        statement = this.withAfterTestClassCallbacks(statement, testContextManager);
        statement = this.withProfileValueCheck(statement, testClass);
        statement = this.withTestContextManagerCacheEviction(statement, testClass);
        return statement;
    }

    private Statement withBeforeTestClassCallbacks(Statement statement, TestContextManager testContextManager) {
        return new RunBeforeTestClassCallbacks(statement, testContextManager);
    }

    private Statement withAfterTestClassCallbacks(Statement statement, TestContextManager testContextManager) {
        return new RunAfterTestClassCallbacks(statement, testContextManager);
    }

    private Statement withProfileValueCheck(Statement statement, Class<?> testClass) {
        return new ProfileValueChecker(statement, testClass, null);
    }

    private Statement withTestContextManagerCacheEviction(Statement statement, Class<?> testClass) {
        return new TestContextManagerCacheEvictor(statement, testClass);
    }

    private static void validateSpringMethodRuleConfiguration(Class<?> testClass) {
        AccessibleObject ruleField = null;
        for (Field field : testClass.getFields()) {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !SpringMethodRule.class.isAssignableFrom(field.getType())) continue;
            ruleField = field;
            break;
        }
        if (ruleField == null) {
            throw new IllegalStateException(String.format("Failed to find 'public SpringMethodRule' field in test class [%s]. Consult the javadoc for SpringClassRule for details.", testClass.getName()));
        }
        if (!ruleField.isAnnotationPresent(Rule.class)) {
            throw new IllegalStateException(String.format("SpringMethodRule field [%s] must be annotated with JUnit's @Rule annotation. Consult the javadoc for SpringClassRule for details.", ruleField));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TestContextManager getTestContextManager(Class<?> testClass) {
        Assert.notNull(testClass, "testClass must not be null");
        Map<Class<?>, TestContextManager> map = testContextManagerCache;
        synchronized (map) {
            TestContextManager testContextManager = testContextManagerCache.get(testClass);
            if (testContextManager == null) {
                testContextManager = new TestContextManager(testClass);
                testContextManagerCache.put(testClass, testContextManager);
            }
            return testContextManager;
        }
    }

    static {
        if (!ClassUtils.isPresent("org.junit.internal.Throwables", SpringClassRule.class.getClassLoader())) {
            throw new IllegalStateException("SpringClassRule requires JUnit 4.12 or higher.");
        }
    }

    private static class TestContextManagerCacheEvictor
    extends Statement {
        private final Statement next;
        private final Class<?> testClass;

        TestContextManagerCacheEvictor(Statement next, Class<?> testClass) {
            this.next = next;
            this.testClass = testClass;
        }

        public void evaluate() throws Throwable {
            try {
                this.next.evaluate();
            }
            finally {
                testContextManagerCache.remove(this.testClass);
            }
        }
    }
}

