/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.LinkedHashSet;
import org.apache.kylin.job.shaded.org.apache.commons.logging.Log;
import org.apache.kylin.job.shaded.org.apache.commons.logging.LogFactory;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ActiveProfilesResolver;
import org.springframework.test.util.MetaAnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultActiveProfilesResolver
implements ActiveProfilesResolver {
    private static final Log logger = LogFactory.getLog(DefaultActiveProfilesResolver.class);

    @Override
    public String[] resolve(Class<?> testClass) {
        Assert.notNull(testClass, "Class must not be null");
        LinkedHashSet<String> activeProfiles = new LinkedHashSet<String>();
        Class<ActiveProfiles> annotationType = ActiveProfiles.class;
        MetaAnnotationUtils.AnnotationDescriptor<ActiveProfiles> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(testClass, annotationType);
        if (descriptor == null) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", annotationType.getName(), testClass.getName()));
            }
        } else {
            Class<?> declaringClass = descriptor.getDeclaringClass();
            ActiveProfiles annotation = descriptor.synthesizeAnnotation();
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Retrieved @ActiveProfiles [%s] for declaring class [%s].", annotation, declaringClass.getName()));
            }
            for (String profile : annotation.profiles()) {
                if (!StringUtils.hasText(profile)) continue;
                activeProfiles.add(profile.trim());
            }
        }
        return StringUtils.toStringArray(activeProfiles);
    }
}

